/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.util;

import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.model.api.BestRowIdentifierScopeType;
import org.jboss.dna.common.jdbc.model.api.ColumnPseudoType;
import org.jboss.dna.common.jdbc.model.api.IndexType;
import org.jboss.dna.common.jdbc.model.api.KeyDeferrabilityType;
import org.jboss.dna.common.jdbc.model.api.KeyModifyRuleType;
import org.jboss.dna.common.jdbc.model.api.NullabilityType;
import org.jboss.dna.common.jdbc.model.api.ParameterIoType;
import org.jboss.dna.common.jdbc.model.api.PrivilegeType;
import org.jboss.dna.common.jdbc.model.api.ResultSetConcurrencyType;
import org.jboss.dna.common.jdbc.model.api.ResultSetHoldabilityType;
import org.jboss.dna.common.jdbc.model.api.ResultSetType;
import org.jboss.dna.common.jdbc.model.api.SQLStateType;
import org.jboss.dna.common.jdbc.model.api.SearchabilityType;
import org.jboss.dna.common.jdbc.model.api.SortSequenceType;
import org.jboss.dna.common.jdbc.model.api.SqlType;
import org.jboss.dna.common.jdbc.model.api.StoredProcedureResultType;
import org.jboss.dna.common.jdbc.model.api.TransactionIsolationLevelType;
import org.jboss.dna.common.jdbc.util.DatabaseUtil;

public class DatabaseUtilTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetBoolean() throws Exception {
        DatabaseUtilTest.assertNull((String)"getBoolean(null, 0) should return null", (Object)DatabaseUtil.getBoolean(null, (int)0));
        DatabaseUtilTest.assertNull((String)"getBoolean(null, 'myColumn') should return null", (Object)DatabaseUtil.getBoolean(null, (String)"myColumn"));
    }

    public void testGetInteger() throws Exception {
        DatabaseUtilTest.assertNull((String)"getInteger(null, 0) should return null", (Object)DatabaseUtil.getInteger(null, (int)0));
        DatabaseUtilTest.assertNull((String)"getInteger(null, 'myColumn') should return null", (Object)DatabaseUtil.getInteger(null, (String)"myColumn"));
    }

    public void testGetDouble() throws Exception {
        DatabaseUtilTest.assertNull((String)"getDouble(null, 0) should return null", (Object)DatabaseUtil.getDouble(null, (int)0));
        DatabaseUtilTest.assertNull((String)"getDouble(null, 'myColumn') should return null", (Object)DatabaseUtil.getDouble(null, (String)"myColumn"));
    }

    public void testGetString() throws Exception {
        DatabaseUtilTest.assertNull((String)"getString(null, 0) should return null", (Object)DatabaseUtil.getString(null, (int)0));
        DatabaseUtilTest.assertNull((String)"getString(null, 'myColumn') should return null", (Object)DatabaseUtil.getString(null, (String)"myColumn"));
    }

    public void testGetBestRowIdentifierScopeType() {
        DatabaseUtilTest.assertNull((String)"getBestRowIdentifierScopeType (null) should return null ", (Object)DatabaseUtil.getBestRowIdentifierScopeType(null));
        DatabaseUtilTest.assertSame((String)"getBestRowIdentifierScopeType () should return BestRowIdentifierScopeType.TEMPORARY", (Object)BestRowIdentifierScopeType.TEMPORARY, (Object)DatabaseUtil.getBestRowIdentifierScopeType((Integer)BestRowIdentifierScopeType.TEMPORARY.getScope()));
        DatabaseUtilTest.assertSame((String)"getBestRowIdentifierScopeType () should return BestRowIdentifierScopeType.TRANSACTION", (Object)BestRowIdentifierScopeType.TRANSACTION, (Object)DatabaseUtil.getBestRowIdentifierScopeType((Integer)BestRowIdentifierScopeType.TRANSACTION.getScope()));
        DatabaseUtilTest.assertSame((String)"getBestRowIdentifierScopeType () should return BestRowIdentifierScopeType.SESSION", (Object)BestRowIdentifierScopeType.SESSION, (Object)DatabaseUtil.getBestRowIdentifierScopeType((Integer)BestRowIdentifierScopeType.SESSION.getScope()));
    }

    public void testGetColumnPseudoType() {
        DatabaseUtilTest.assertNull((String)"getColumnPseudoType (null) should return null ", (Object)DatabaseUtil.getColumnPseudoType(null));
        DatabaseUtilTest.assertSame((String)"getColumnPseudoType () should return ColumnPseudoType.UNKNOWN", (Object)ColumnPseudoType.UNKNOWN, (Object)DatabaseUtil.getColumnPseudoType((Integer)ColumnPseudoType.UNKNOWN.getType()));
        DatabaseUtilTest.assertSame((String)"getColumnPseudoType () should return ColumnPseudoType.NOT_PSEUDO", (Object)ColumnPseudoType.NOT_PSEUDO, (Object)DatabaseUtil.getColumnPseudoType((Integer)ColumnPseudoType.NOT_PSEUDO.getType()));
        DatabaseUtilTest.assertSame((String)"getColumnPseudoType () should return ColumnPseudoType.PSEUDO", (Object)ColumnPseudoType.PSEUDO, (Object)DatabaseUtil.getColumnPseudoType((Integer)ColumnPseudoType.PSEUDO.getType()));
    }

    public void testGetIndexType() {
        DatabaseUtilTest.assertNull((String)"getIndexType (null) should return null ", (Object)DatabaseUtil.getIndexType(null));
        DatabaseUtilTest.assertSame((String)"getIndexType () should return IndexType.STATISTIC", (Object)IndexType.STATISTIC, (Object)DatabaseUtil.getIndexType((Integer)IndexType.STATISTIC.getType()));
        DatabaseUtilTest.assertSame((String)"getIndexType () should return IndexType.CLUSTERED", (Object)IndexType.CLUSTERED, (Object)DatabaseUtil.getIndexType((Integer)IndexType.CLUSTERED.getType()));
        DatabaseUtilTest.assertSame((String)"getIndexType () should return IndexType.HASHED", (Object)IndexType.HASHED, (Object)DatabaseUtil.getIndexType((Integer)IndexType.HASHED.getType()));
        DatabaseUtilTest.assertSame((String)"getIndexType () should return IndexType.OTHER", (Object)IndexType.OTHER, (Object)DatabaseUtil.getIndexType((Integer)IndexType.OTHER.getType()));
    }

    public void testGetKeyDeferrabilityType() {
        DatabaseUtilTest.assertNull((String)"getKeyDeferrabilityType (null) should return null ", (Object)DatabaseUtil.getKeyDeferrabilityType(null));
        DatabaseUtilTest.assertSame((String)"getKeyDeferrabilityType () should return KeyDeferrabilityType.INITIALLY_DEFERRED", (Object)KeyDeferrabilityType.INITIALLY_DEFERRED, (Object)DatabaseUtil.getKeyDeferrabilityType((Integer)KeyDeferrabilityType.INITIALLY_DEFERRED.getDeferrability()));
        DatabaseUtilTest.assertSame((String)"getKeyDeferrabilityType () should return KeyDeferrabilityType.INTIALLY_IMMEDIATE", (Object)KeyDeferrabilityType.INTIALLY_IMMEDIATE, (Object)DatabaseUtil.getKeyDeferrabilityType((Integer)KeyDeferrabilityType.INTIALLY_IMMEDIATE.getDeferrability()));
        DatabaseUtilTest.assertSame((String)"getKeyDeferrabilityType () should return KeyDeferrabilityType.NOT_DEFERRABLE", (Object)KeyDeferrabilityType.NOT_DEFERRABLE, (Object)DatabaseUtil.getKeyDeferrabilityType((Integer)KeyDeferrabilityType.NOT_DEFERRABLE.getDeferrability()));
    }

    public void testGetKeyModifyRuleType() {
        DatabaseUtilTest.assertNull((String)"getKeyModifyRuleType (null) should return null ", (Object)DatabaseUtil.getKeyModifyRuleType(null));
        DatabaseUtilTest.assertSame((String)"getKeyModifyRuleType () should return KeyModifyRuleType.CASCADE", (Object)KeyModifyRuleType.CASCADE, (Object)DatabaseUtil.getKeyModifyRuleType((Integer)KeyModifyRuleType.CASCADE.getRule()));
        DatabaseUtilTest.assertSame((String)"getKeyModifyRuleType () should return KeyModifyRuleType.RESTRICT", (Object)KeyModifyRuleType.RESTRICT, (Object)DatabaseUtil.getKeyModifyRuleType((Integer)KeyModifyRuleType.RESTRICT.getRule()));
        DatabaseUtilTest.assertSame((String)"getKeyModifyRuleType () should return KeyModifyRuleType.SET_NULL", (Object)KeyModifyRuleType.SET_NULL, (Object)DatabaseUtil.getKeyModifyRuleType((Integer)KeyModifyRuleType.SET_NULL.getRule()));
        DatabaseUtilTest.assertSame((String)"getKeyModifyRuleType () should return KeyModifyRuleType.NO_ACTION", (Object)KeyModifyRuleType.NO_ACTION, (Object)DatabaseUtil.getKeyModifyRuleType((Integer)KeyModifyRuleType.NO_ACTION.getRule()));
        DatabaseUtilTest.assertSame((String)"getKeyModifyRuleType () should return KeyModifyRuleType.SET_DEFAULT", (Object)KeyModifyRuleType.SET_DEFAULT, (Object)DatabaseUtil.getKeyModifyRuleType((Integer)KeyModifyRuleType.SET_DEFAULT.getRule()));
    }

    public void testGetNullabilityType() {
        DatabaseUtilTest.assertNull((String)"getNullabilityType (null) should return null ", (Object)DatabaseUtil.getNullabilityType(null));
        DatabaseUtilTest.assertSame((String)"getNullabilityType () should return NullabilityType.UNKNOWN", (Object)NullabilityType.UNKNOWN, (Object)DatabaseUtil.getNullabilityType((Integer)NullabilityType.UNKNOWN.getNullability()));
        DatabaseUtilTest.assertSame((String)"getNullabilityType () should return NullabilityType.NO_NULLS", (Object)NullabilityType.NO_NULLS, (Object)DatabaseUtil.getNullabilityType((Integer)NullabilityType.NO_NULLS.getNullability()));
        DatabaseUtilTest.assertSame((String)"getNullabilityType () should return NullabilityType.NULLABLE", (Object)NullabilityType.NULLABLE, (Object)DatabaseUtil.getNullabilityType((Integer)NullabilityType.NULLABLE.getNullability()));
    }

    public void testGetParameterIoType() {
        DatabaseUtilTest.assertNull((String)"getParameterIoType (null) should return null ", (Object)DatabaseUtil.getParameterIoType(null));
        DatabaseUtilTest.assertSame((String)"getParameterIoType () should return ParameterIoType.UNKNOWN", (Object)ParameterIoType.UNKNOWN, (Object)DatabaseUtil.getParameterIoType((Integer)ParameterIoType.UNKNOWN.getType()));
        DatabaseUtilTest.assertSame((String)"getParameterIoType () should return ParameterIoType.IN", (Object)ParameterIoType.IN, (Object)DatabaseUtil.getParameterIoType((Integer)ParameterIoType.IN.getType()));
        DatabaseUtilTest.assertSame((String)"getParameterIoType () should return ParameterIoType.IN_OUT", (Object)ParameterIoType.IN_OUT, (Object)DatabaseUtil.getParameterIoType((Integer)ParameterIoType.IN_OUT.getType()));
        DatabaseUtilTest.assertSame((String)"getParameterIoType () should return ParameterIoType.OUT", (Object)ParameterIoType.OUT, (Object)DatabaseUtil.getParameterIoType((Integer)ParameterIoType.OUT.getType()));
        DatabaseUtilTest.assertSame((String)"getParameterIoType () should return ParameterIoType.RET", (Object)ParameterIoType.RET, (Object)DatabaseUtil.getParameterIoType((Integer)ParameterIoType.RET.getType()));
        DatabaseUtilTest.assertSame((String)"getParameterIoType () should return ParameterIoType.RESULT", (Object)ParameterIoType.RESULT, (Object)DatabaseUtil.getParameterIoType((Integer)ParameterIoType.RESULT.getType()));
    }

    public void testGetPrivilegeType() {
        DatabaseUtilTest.assertNull((String)"getPrivilegeType (null) should return null ", (Object)DatabaseUtil.getPrivilegeType(null));
        DatabaseUtilTest.assertSame((String)"getPrivilegeType () should return PrivilegeType.INSERT", (Object)PrivilegeType.INSERT, (Object)DatabaseUtil.getPrivilegeType((String)PrivilegeType.INSERT.getType()));
        DatabaseUtilTest.assertSame((String)"getPrivilegeType () should return PrivilegeType.SELECT", (Object)PrivilegeType.SELECT, (Object)DatabaseUtil.getPrivilegeType((String)PrivilegeType.SELECT.getType()));
        DatabaseUtilTest.assertSame((String)"getPrivilegeType () should return PrivilegeType.UPDATE", (Object)PrivilegeType.UPDATE, (Object)DatabaseUtil.getPrivilegeType((String)PrivilegeType.UPDATE.getType()));
        DatabaseUtilTest.assertSame((String)"getPrivilegeType () should return PrivilegeType.DELETE", (Object)PrivilegeType.DELETE, (Object)DatabaseUtil.getPrivilegeType((String)PrivilegeType.DELETE.getType()));
        DatabaseUtilTest.assertSame((String)"getPrivilegeType () should return PrivilegeType.REFERENCE", (Object)PrivilegeType.REFERENCE, (Object)DatabaseUtil.getPrivilegeType((String)PrivilegeType.REFERENCE.getType()));
        DatabaseUtilTest.assertSame((String)"getPrivilegeType () should return PrivilegeType.OTHER", (Object)PrivilegeType.OTHER, (Object)DatabaseUtil.getPrivilegeType((String)PrivilegeType.OTHER.getType()));
    }

    public void testGetResultSetConcurrencyType() {
        DatabaseUtilTest.assertNull((String)"getResultSetConcurrencyType (null) should return null ", (Object)DatabaseUtil.getResultSetConcurrencyType(null));
        DatabaseUtilTest.assertSame((String)"getResultSetConcurrencyType () should return ResultSetConcurrencyType.READ_ONLY", (Object)ResultSetConcurrencyType.READ_ONLY, (Object)DatabaseUtil.getResultSetConcurrencyType((Integer)ResultSetConcurrencyType.READ_ONLY.getConcurrency()));
        DatabaseUtilTest.assertSame((String)"getResultSetConcurrencyType () should return ResultSetConcurrencyType.UPDATABLE", (Object)ResultSetConcurrencyType.UPDATABLE, (Object)DatabaseUtil.getResultSetConcurrencyType((Integer)ResultSetConcurrencyType.UPDATABLE.getConcurrency()));
    }

    public void testGetResultSetHoldabilityType() {
        DatabaseUtilTest.assertNull((String)"getResultSetHoldabilityType (null) should return null ", (Object)DatabaseUtil.getResultSetHoldabilityType(null));
        DatabaseUtilTest.assertSame((String)"getResultSetHoldabilityType () should return ResultSetHoldabilityType.HOLD_CURSORS_OVER_COMMIT", (Object)ResultSetHoldabilityType.HOLD_CURSORS_OVER_COMMIT, (Object)DatabaseUtil.getResultSetHoldabilityType((Integer)ResultSetHoldabilityType.HOLD_CURSORS_OVER_COMMIT.getHoldability()));
        DatabaseUtilTest.assertSame((String)"getResultSetHoldabilityType () should return ResultSetHoldabilityType.CLOSE_CURSORS_AT_COMMIT", (Object)ResultSetHoldabilityType.CLOSE_CURSORS_AT_COMMIT, (Object)DatabaseUtil.getResultSetHoldabilityType((Integer)ResultSetHoldabilityType.CLOSE_CURSORS_AT_COMMIT.getHoldability()));
    }

    public void testGetResultSetType() {
        DatabaseUtilTest.assertNull((String)"getResultSetType (null) should return null ", (Object)DatabaseUtil.getResultSetType(null));
        DatabaseUtilTest.assertSame((String)"getResultSetType () should return ResultSetType.FORWARD_ONLY ", (Object)ResultSetType.FORWARD_ONLY, (Object)DatabaseUtil.getResultSetType((Integer)ResultSetType.FORWARD_ONLY.getType()));
        DatabaseUtilTest.assertSame((String)"getResultSetType () should return ResultSetType.SCROLL_INSENSITIVE ", (Object)ResultSetType.SCROLL_INSENSITIVE, (Object)DatabaseUtil.getResultSetType((Integer)ResultSetType.SCROLL_INSENSITIVE.getType()));
        DatabaseUtilTest.assertSame((String)"getResultSetType () should return ResultSetType.SCROLL_SENSITIVE ", (Object)ResultSetType.SCROLL_SENSITIVE, (Object)DatabaseUtil.getResultSetType((Integer)ResultSetType.SCROLL_SENSITIVE.getType()));
    }

    public void testGetSearchabilityType() {
        DatabaseUtilTest.assertNull((String)"getSearchabilityType (null) should return null ", (Object)DatabaseUtil.getSearchabilityType(null));
        DatabaseUtilTest.assertSame((String)"getSearchabilityType () should return SearchabilityType.NOT_SUPPORTED ", (Object)SearchabilityType.NOT_SUPPORTED, (Object)DatabaseUtil.getSearchabilityType((Integer)SearchabilityType.NOT_SUPPORTED.getSearchability()));
        DatabaseUtilTest.assertSame((String)"getSearchabilityType () should return SearchabilityType.WHERE_LIKE ", (Object)SearchabilityType.WHERE_LIKE, (Object)DatabaseUtil.getSearchabilityType((Integer)SearchabilityType.WHERE_LIKE.getSearchability()));
        DatabaseUtilTest.assertSame((String)"getSearchabilityType () should return SearchabilityType.BASIC ", (Object)SearchabilityType.BASIC, (Object)DatabaseUtil.getSearchabilityType((Integer)SearchabilityType.BASIC.getSearchability()));
        DatabaseUtilTest.assertSame((String)"getSearchabilityType () should return SearchabilityType.SEARCHABLE ", (Object)SearchabilityType.SEARCHABLE, (Object)DatabaseUtil.getSearchabilityType((Integer)SearchabilityType.SEARCHABLE.getSearchability()));
    }

    public void testGetSortSequenceType() {
        DatabaseUtilTest.assertNull((String)"getSortSequenceType (null) should return null ", (Object)DatabaseUtil.getSortSequenceType(null));
        DatabaseUtilTest.assertSame((String)"getSortSequenceType () should return SortSequenceType.ASCENDING ", (Object)SortSequenceType.ASCENDING, (Object)DatabaseUtil.getSortSequenceType((String)SortSequenceType.ASCENDING.getType()));
        DatabaseUtilTest.assertSame((String)"getSortSequenceType () should return SortSequenceType.DESCENDING ", (Object)SortSequenceType.DESCENDING, (Object)DatabaseUtil.getSortSequenceType((String)SortSequenceType.DESCENDING.getType()));
        DatabaseUtilTest.assertSame((String)"getSortSequenceType () should return SortSequenceType.NOT_SUPPORTED ", (Object)SortSequenceType.NOT_SUPPORTED, (Object)DatabaseUtil.getSortSequenceType((String)SortSequenceType.NOT_SUPPORTED.getType()));
    }

    public void testGetSqlStateType() {
        DatabaseUtilTest.assertNull((String)"getSqlStateType (null) should return null ", (Object)DatabaseUtil.getSqlStateType(null));
        DatabaseUtilTest.assertSame((String)"getSqlStateType () should return SqlStateType.XOPEN ", (Object)SQLStateType.XOPEN, (Object)DatabaseUtil.getSqlStateType((Integer)SQLStateType.XOPEN.getState()));
        DatabaseUtilTest.assertSame((String)"getSqlStateType () should return SqlStateType.SQL99 ", (Object)SQLStateType.SQL99, (Object)DatabaseUtil.getSqlStateType((Integer)SQLStateType.SQL99.getState()));
    }

    public void testGetSqlType() {
        DatabaseUtilTest.assertNull((String)"getSqlType (null) should return null ", (Object)DatabaseUtil.getSqlType(null));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.BIT ", (Object)SqlType.BIT, (Object)DatabaseUtil.getSqlType((Integer)SqlType.BIT.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.TINYINT ", (Object)SqlType.TINYINT, (Object)DatabaseUtil.getSqlType((Integer)SqlType.TINYINT.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.SMALLINT ", (Object)SqlType.SMALLINT, (Object)DatabaseUtil.getSqlType((Integer)SqlType.SMALLINT.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.INTEGER ", (Object)SqlType.INTEGER, (Object)DatabaseUtil.getSqlType((Integer)SqlType.INTEGER.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.BIGINT ", (Object)SqlType.BIGINT, (Object)DatabaseUtil.getSqlType((Integer)SqlType.BIGINT.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.FLOAT ", (Object)SqlType.FLOAT, (Object)DatabaseUtil.getSqlType((Integer)SqlType.FLOAT.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.REAL ", (Object)SqlType.REAL, (Object)DatabaseUtil.getSqlType((Integer)SqlType.REAL.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.DOUBLE ", (Object)SqlType.DOUBLE, (Object)DatabaseUtil.getSqlType((Integer)SqlType.DOUBLE.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.NUMERIC ", (Object)SqlType.NUMERIC, (Object)DatabaseUtil.getSqlType((Integer)SqlType.NUMERIC.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.DECIMAL ", (Object)SqlType.DECIMAL, (Object)DatabaseUtil.getSqlType((Integer)SqlType.DECIMAL.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.CHAR ", (Object)SqlType.CHAR, (Object)DatabaseUtil.getSqlType((Integer)SqlType.CHAR.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.VARCHAR ", (Object)SqlType.VARCHAR, (Object)DatabaseUtil.getSqlType((Integer)SqlType.VARCHAR.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.LONGVARCHAR ", (Object)SqlType.LONGVARCHAR, (Object)DatabaseUtil.getSqlType((Integer)SqlType.LONGVARCHAR.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.DATE ", (Object)SqlType.DATE, (Object)DatabaseUtil.getSqlType((Integer)SqlType.DATE.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.TIME ", (Object)SqlType.TIME, (Object)DatabaseUtil.getSqlType((Integer)SqlType.TIME.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.TIMESTAMP ", (Object)SqlType.TIMESTAMP, (Object)DatabaseUtil.getSqlType((Integer)SqlType.TIMESTAMP.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.BINARY ", (Object)SqlType.BINARY, (Object)DatabaseUtil.getSqlType((Integer)SqlType.BINARY.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.VARBINARY ", (Object)SqlType.VARBINARY, (Object)DatabaseUtil.getSqlType((Integer)SqlType.VARBINARY.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.LONGVARBINARY ", (Object)SqlType.LONGVARBINARY, (Object)DatabaseUtil.getSqlType((Integer)SqlType.LONGVARBINARY.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.NULL ", (Object)SqlType.NULL, (Object)DatabaseUtil.getSqlType((Integer)SqlType.NULL.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.OTHER ", (Object)SqlType.OTHER, (Object)DatabaseUtil.getSqlType((Integer)SqlType.OTHER.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.JAVA_OBJECT ", (Object)SqlType.JAVA_OBJECT, (Object)DatabaseUtil.getSqlType((Integer)SqlType.JAVA_OBJECT.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.DISTINCT ", (Object)SqlType.DISTINCT, (Object)DatabaseUtil.getSqlType((Integer)SqlType.DISTINCT.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.STRUCT ", (Object)SqlType.STRUCT, (Object)DatabaseUtil.getSqlType((Integer)SqlType.STRUCT.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.ARRAY ", (Object)SqlType.ARRAY, (Object)DatabaseUtil.getSqlType((Integer)SqlType.ARRAY.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.BLOB ", (Object)SqlType.BLOB, (Object)DatabaseUtil.getSqlType((Integer)SqlType.BLOB.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.CLOB ", (Object)SqlType.CLOB, (Object)DatabaseUtil.getSqlType((Integer)SqlType.CLOB.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.REF ", (Object)SqlType.REF, (Object)DatabaseUtil.getSqlType((Integer)SqlType.REF.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.DATALINK ", (Object)SqlType.DATALINK, (Object)DatabaseUtil.getSqlType((Integer)SqlType.DATALINK.getType()));
        DatabaseUtilTest.assertSame((String)"getSqlType () should return SqlType.BOOLEAN ", (Object)SqlType.BOOLEAN, (Object)DatabaseUtil.getSqlType((Integer)SqlType.BOOLEAN.getType()));
    }

    public void testGetStoredProcedureResultType() {
        DatabaseUtilTest.assertNull((String)"getStoredProcedureResultType (null) should return null ", (Object)DatabaseUtil.getStoredProcedureResultType(null));
        DatabaseUtilTest.assertSame((String)"getStoredProcedureResultType () should return StoredProcedureResultType.NO_RESULT ", (Object)StoredProcedureResultType.NO_RESULT, (Object)DatabaseUtil.getStoredProcedureResultType((Integer)StoredProcedureResultType.NO_RESULT.getType()));
        DatabaseUtilTest.assertSame((String)"getStoredProcedureResultType () should return StoredProcedureResultType.RETURNS_RESULT ", (Object)StoredProcedureResultType.RETURNS_RESULT, (Object)DatabaseUtil.getStoredProcedureResultType((Integer)StoredProcedureResultType.RETURNS_RESULT.getType()));
        DatabaseUtilTest.assertSame((String)"getStoredProcedureResultType () should return StoredProcedureResultType.UNKNOWN ", (Object)StoredProcedureResultType.UNKNOWN, (Object)DatabaseUtil.getStoredProcedureResultType((Integer)StoredProcedureResultType.UNKNOWN.getType()));
    }

    public void testGetTransactionIsolationLevelType() {
        DatabaseUtilTest.assertNull((String)"getTransactionIsolationLevelType (null) should return null ", (Object)DatabaseUtil.getTransactionIsolationLevelType(null));
        DatabaseUtilTest.assertSame((String)"getTransactionIsolationLevelType () should return TransactionIsolationLevelType.NONE", (Object)TransactionIsolationLevelType.NONE, (Object)DatabaseUtil.getTransactionIsolationLevelType((Integer)TransactionIsolationLevelType.NONE.getLevel()));
        DatabaseUtilTest.assertSame((String)"getTransactionIsolationLevelType () should return TransactionIsolationLevelType.READ_UNCOMMITTED", (Object)TransactionIsolationLevelType.READ_UNCOMMITTED, (Object)DatabaseUtil.getTransactionIsolationLevelType((Integer)TransactionIsolationLevelType.READ_UNCOMMITTED.getLevel()));
        DatabaseUtilTest.assertSame((String)"getTransactionIsolationLevelType () should return TransactionIsolationLevelType.READ_COMMITTED", (Object)TransactionIsolationLevelType.READ_COMMITTED, (Object)DatabaseUtil.getTransactionIsolationLevelType((Integer)TransactionIsolationLevelType.READ_COMMITTED.getLevel()));
        DatabaseUtilTest.assertSame((String)"getTransactionIsolationLevelType () should return TransactionIsolationLevelType.REPEATABLE_READ", (Object)TransactionIsolationLevelType.REPEATABLE_READ, (Object)DatabaseUtil.getTransactionIsolationLevelType((Integer)TransactionIsolationLevelType.REPEATABLE_READ.getLevel()));
        DatabaseUtilTest.assertSame((String)"getTransactionIsolationLevelType () should return TransactionIsolationLevelType.SERIALIZABLE", (Object)TransactionIsolationLevelType.SERIALIZABLE, (Object)DatabaseUtil.getTransactionIsolationLevelType((Integer)TransactionIsolationLevelType.SERIALIZABLE.getLevel()));
    }

    public void testGetStandardUserDefinedTypes() {
        String udtTypes = DatabaseUtil.getStandardUserDefinedTypes();
        DatabaseUtilTest.assertNotNull((String)"DatabaseUtil.getStandardUserDefinedTypes should return not empty list", (Object)udtTypes);
        DatabaseUtilTest.assertTrue((String)"JAVA_OBJECT should be specified among standard UDT", (boolean)udtTypes.contains("JAVA_OBJECT"));
        DatabaseUtilTest.assertTrue((String)"STRUCT should be specified among standard UDT", (boolean)udtTypes.contains("STRUCT"));
        DatabaseUtilTest.assertTrue((String)"DISTINCT should be specified among standard UDT", (boolean)udtTypes.contains("DISTINCT"));
    }

    public void testGetUserDefinedTypes() {
        String udtTypes = "DISTINCT,JAVA_OBJECT,STRUCT";
        int[] udtIntTypes = DatabaseUtil.getUserDefinedTypes((String)udtTypes);
        DatabaseUtilTest.assertNotNull((String)"UDT int array should be not null", (Object)udtIntTypes);
        DatabaseUtilTest.assertEquals((String)"The size of UDT int array is expected to be three", (int)3, (int)udtIntTypes.length);
        DatabaseUtilTest.assertEquals((String)"The udtIntTypes[0] should be equal to Types.DISTINCT", (int)2001, (int)udtIntTypes[0]);
        DatabaseUtilTest.assertEquals((String)"The udtIntTypes[1] should be equal to Types.JAVA_OBJECT", (int)2000, (int)udtIntTypes[1]);
        DatabaseUtilTest.assertEquals((String)"The udtIntTypes[2] should be equal to Types.STRUCT", (int)2002, (int)udtIntTypes[2]);
    }
}

