/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.provider;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Properties;
import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.provider.DefaultDriverDatabaseMetadataProvider;
import org.jboss.dna.common.jdbc.provider.DriverDatabaseMetadataProvider;

public class DriverDatabaseMetadataProviderTest
extends TestCase {
    private static final String PROVIDER_NAME = "TestProvider";
    private static final String DRIVER_CLASS_NAME = "org.hsqldb.jdbcDriver";
    private static final String DATABASE_URL = "jdbc:hsqldb:mem:test";
    private static final String USER_NAME = "sa";
    private static final String PASSWORD = "";
    private static final String EMPTY_STRING_NOTATION = "<EMPTY>";
    private static final String NULL_STRING_NOTATION = "<NULL>";
    private DriverDatabaseMetadataProvider driverProvider;

    protected void setUp() throws Exception {
        super.setUp();
        this.driverProvider = new DefaultDriverDatabaseMetadataProvider();
    }

    protected void tearDown() throws Exception {
        this.driverProvider = null;
        super.tearDown();
    }

    public void testSetDriverClassName() {
        this.driverProvider.setDriverClassName(DRIVER_CLASS_NAME);
        DriverDatabaseMetadataProviderTest.assertEquals((String)"Unable to set the driver class name", (String)DRIVER_CLASS_NAME, (String)this.driverProvider.getDriverClassName());
    }

    public void testSetDatabaseUrl() {
        this.driverProvider.setDatabaseUrl(DATABASE_URL);
        DriverDatabaseMetadataProviderTest.assertEquals((String)"Unable to set the database URL", (String)DATABASE_URL, (String)this.driverProvider.getDatabaseUrl());
    }

    public void testSetUserName() {
        this.driverProvider.setUserName(USER_NAME);
        DriverDatabaseMetadataProviderTest.assertEquals((String)"Unable to set the user name", (String)USER_NAME, (String)this.driverProvider.getUserName());
    }

    public void testSetPassword() {
        this.driverProvider.setPassword(PASSWORD);
        DriverDatabaseMetadataProviderTest.assertEquals((String)"Unable to set the password", (String)PASSWORD, (String)this.driverProvider.getPassword());
    }

    public void testRelease() {
        this.driverProvider.release(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDatabaseMetaData() throws Exception {
        this.driverProvider.setName(PROVIDER_NAME);
        this.driverProvider.setDriverClassName(DRIVER_CLASS_NAME);
        this.driverProvider.setDatabaseUrl(DATABASE_URL);
        this.driverProvider.setUserName(USER_NAME);
        this.driverProvider.setPassword(PASSWORD);
        try {
            DatabaseMetaData databaseMetaData = this.driverProvider.getDatabaseMetaData();
            DriverDatabaseMetadataProviderTest.assertNotNull((String)"Database metadata shall be provided", (Object)databaseMetaData);
        }
        finally {
            this.driverProvider.release(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetConnection() throws Exception {
        this.driverProvider.setName(PROVIDER_NAME);
        this.driverProvider.setDriverClassName(DRIVER_CLASS_NAME);
        this.driverProvider.setDatabaseUrl(DATABASE_URL);
        this.driverProvider.setUserName(USER_NAME);
        this.driverProvider.setPassword(PASSWORD);
        try {
            Connection connection = this.driverProvider.getConnection();
            DriverDatabaseMetadataProviderTest.assertNotNull((String)"Database connection shall be provided", (Object)connection);
        }
        finally {
            this.driverProvider.release(true);
        }
    }

    public void testSetName() {
        this.driverProvider.setName(PROVIDER_NAME);
        DriverDatabaseMetadataProviderTest.assertEquals((String)"Unable to set the driver provider name", (String)PROVIDER_NAME, (String)this.driverProvider.getName());
    }

    public void testSetProperties() {
        Properties properties = new Properties();
        this.driverProvider.setProperties(properties);
        DriverDatabaseMetadataProviderTest.assertSame((String)"Unable to set the driver provider properties", (Object)properties, (Object)this.driverProvider.getProperties());
    }

    public void testSetEmptyStringNotation() {
        this.driverProvider.setEmptyStringNotation(EMPTY_STRING_NOTATION);
        DriverDatabaseMetadataProviderTest.assertSame((String)"Unable to set the empty string notation", (Object)EMPTY_STRING_NOTATION, (Object)this.driverProvider.getEmptyStringNotation());
    }

    public void testSetNullStringNotation() {
        this.driverProvider.setNullStringNotation(NULL_STRING_NOTATION);
        DriverDatabaseMetadataProviderTest.assertSame((String)"Unable to set the NULL string notation", (Object)NULL_STRING_NOTATION, (Object)this.driverProvider.getNullStringNotation());
    }
}

