/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.model.spi;

import java.util.Set;
import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.model.DefaultModelFactory;
import org.jboss.dna.common.jdbc.model.ModelFactory;
import org.jboss.dna.common.jdbc.model.api.BestRowIdentifier;
import org.jboss.dna.common.jdbc.model.api.BestRowIdentifierScopeType;
import org.jboss.dna.common.jdbc.model.api.Catalog;
import org.jboss.dna.common.jdbc.model.api.ForeignKey;
import org.jboss.dna.common.jdbc.model.api.Index;
import org.jboss.dna.common.jdbc.model.api.PrimaryKey;
import org.jboss.dna.common.jdbc.model.api.Privilege;
import org.jboss.dna.common.jdbc.model.api.Schema;
import org.jboss.dna.common.jdbc.model.api.Table;
import org.jboss.dna.common.jdbc.model.api.TableColumn;
import org.jboss.dna.common.jdbc.model.api.TableType;
import org.jboss.dna.common.jdbc.model.spi.TableBean;

public class TableBeanTest
extends TestCase {
    private Table bean;
    private ModelFactory factory;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new TableBean();
        this.factory = new DefaultModelFactory();
    }

    protected void tearDown() throws Exception {
        this.bean = null;
        this.factory = null;
        super.tearDown();
    }

    public void testSetTableType() {
        TableType tableType = this.factory.createTableType();
        this.bean.setTableType(tableType);
        TableBeanTest.assertSame((String)"Unable to set table type", (Object)tableType, (Object)this.bean.getTableType());
    }

    public void testSetTypeCatalog() {
        Catalog typeCatalog = this.factory.createCatalog();
        this.bean.setTypeCatalog(typeCatalog);
        TableBeanTest.assertSame((String)"Unable to set type catalog", (Object)typeCatalog, (Object)this.bean.getTypeCatalog());
    }

    public void testSetTypeSchema() {
        Schema typeSchema = this.factory.createSchema();
        this.bean.setTypeSchema(typeSchema);
        TableBeanTest.assertSame((String)"Unable to set type schema", (Object)typeSchema, (Object)this.bean.getTypeSchema());
    }

    public void testSetTypeName() {
        String typeName = "My type";
        this.bean.setTypeName(typeName);
        TableBeanTest.assertSame((String)"Unable to set type name", (Object)typeName, (Object)this.bean.getTypeName());
    }

    public void testSetSelfReferencingColumnName() {
        String selfReferencingColumnName = "Self-Ref column name";
        this.bean.setSelfReferencingColumnName(selfReferencingColumnName);
        TableBeanTest.assertSame((String)"Unable to set self referencing column name", (Object)selfReferencingColumnName, (Object)this.bean.getSelfReferencingColumnName());
    }

    public void testSetReferenceGeneration() {
        String referenceGeneration = "Reference generation";
        this.bean.setReferenceGeneration(referenceGeneration);
        TableBeanTest.assertSame((String)"Unable to set reference generation", (Object)referenceGeneration, (Object)this.bean.getReferenceGeneration());
    }

    public void testGetColumns() {
        Set columns = this.bean.getColumns();
        TableBeanTest.assertNotNull((String)"Unable to get columns", (Object)columns);
        TableBeanTest.assertTrue((String)"Column set should be empty by default", (boolean)columns.isEmpty());
    }

    public void testAddColumn() {
        String COLUMN_NAME = "My column";
        TableColumn column = this.factory.createTableColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        TableBeanTest.assertFalse((String)"column set should not be empty", (boolean)this.bean.getColumns().isEmpty());
    }

    public void testDeleteColumn() {
        String COLUMN_NAME = "My column";
        TableColumn column = this.factory.createTableColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        TableBeanTest.assertFalse((String)"column set should not be empty", (boolean)this.bean.getColumns().isEmpty());
        this.bean.deleteColumn(column);
        TableBeanTest.assertTrue((String)"Parameter set should be empty", (boolean)this.bean.getColumns().isEmpty());
    }

    public void testFindColumnByName() {
        String COLUMN_NAME = "My column";
        TableColumn column = this.factory.createTableColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        TableBeanTest.assertFalse((String)"column set should not be empty", (boolean)this.bean.getColumns().isEmpty());
        TableBeanTest.assertSame((String)"Unable to find column", (Object)column, (Object)this.bean.findColumnByName(COLUMN_NAME));
    }

    public void testSetPrimaryKey() {
        PrimaryKey primaryKey = this.factory.createPrimaryKey();
        this.bean.setPrimaryKey(primaryKey);
        TableBeanTest.assertSame((String)"Unable to set primary key", (Object)primaryKey, (Object)this.bean.getPrimaryKey());
    }

    public void testGetForeignKeys() {
        Set foreignKeys = this.bean.getForeignKeys();
        TableBeanTest.assertNotNull((String)"Unable to get FK list", (Object)foreignKeys);
        TableBeanTest.assertTrue((String)"FK set should be empty by default", (boolean)foreignKeys.isEmpty());
    }

    public void testAddForeignKey() {
        String NAME = "My FK";
        ForeignKey fk = this.factory.createForeignKey();
        fk.setName(NAME);
        this.bean.addForeignKey(fk);
        TableBeanTest.assertFalse((String)"FK set should not be empty", (boolean)this.bean.getForeignKeys().isEmpty());
    }

    public void testDeleteForeignKey() {
        String NAME = "My FK";
        ForeignKey fk = this.factory.createForeignKey();
        fk.setName(NAME);
        this.bean.addForeignKey(fk);
        TableBeanTest.assertFalse((String)"FK set should not be empty", (boolean)this.bean.getForeignKeys().isEmpty());
        this.bean.deleteForeignKey(fk);
        TableBeanTest.assertTrue((String)"FK set should be empty", (boolean)this.bean.getForeignKeys().isEmpty());
    }

    public void testFindForeignKeyByName() {
        String NAME = "My FK";
        ForeignKey fk = this.factory.createForeignKey();
        fk.setName(NAME);
        this.bean.addForeignKey(fk);
        TableBeanTest.assertFalse((String)"FK set should not be empty", (boolean)this.bean.getForeignKeys().isEmpty());
        TableBeanTest.assertSame((String)"Unable to find FK", (Object)fk, (Object)this.bean.findForeignKeyByName(NAME));
    }

    public void testGetIndexes() {
        Set indexes = this.bean.getIndexes();
        TableBeanTest.assertNotNull((String)"Unable to get Indexes", (Object)indexes);
        TableBeanTest.assertTrue((String)"Index set should be empty by default", (boolean)indexes.isEmpty());
    }

    public void testAddIndex() {
        String NAME = "My Index";
        Index i = this.factory.createIndex();
        i.setName(NAME);
        this.bean.addIndex(i);
        TableBeanTest.assertFalse((String)"Index set should not be empty", (boolean)this.bean.getIndexes().isEmpty());
    }

    public void testDeleteIndex() {
        String NAME = "My Index";
        Index i = this.factory.createIndex();
        i.setName(NAME);
        this.bean.addIndex(i);
        TableBeanTest.assertFalse((String)"Index set should not be empty", (boolean)this.bean.getIndexes().isEmpty());
        this.bean.deleteIndex(i);
        TableBeanTest.assertTrue((String)"*Index set should be empty", (boolean)this.bean.getIndexes().isEmpty());
    }

    public void testFindIndexByName() {
        String NAME = "My Index";
        Index i = this.factory.createIndex();
        i.setName(NAME);
        this.bean.addIndex(i);
        TableBeanTest.assertFalse((String)"Index set should not be empty", (boolean)this.bean.getIndexes().isEmpty());
        TableBeanTest.assertSame((String)"Unable to find Index", (Object)i, (Object)this.bean.findIndexByName(NAME));
    }

    public void testGetVersionColumns() {
        Set columns = this.bean.getVersionColumns();
        TableBeanTest.assertNotNull((String)"Unable to get version columns", (Object)columns);
        TableBeanTest.assertTrue((String)"Version column set should be empty by default", (boolean)columns.isEmpty());
    }

    public void testAddVersionColumn() {
        String COLUMN_NAME = "My column";
        TableColumn column = this.factory.createTableColumn();
        column.setName(COLUMN_NAME);
        this.bean.addVersionColumn(column);
        TableBeanTest.assertFalse((String)"column set should not be empty", (boolean)this.bean.getVersionColumns().isEmpty());
    }

    public void testDeleteVersionColumn() {
        String COLUMN_NAME = "My column";
        TableColumn column = this.factory.createTableColumn();
        column.setName(COLUMN_NAME);
        this.bean.addVersionColumn(column);
        TableBeanTest.assertFalse((String)"column set should not be empty", (boolean)this.bean.getVersionColumns().isEmpty());
        this.bean.deleteVersionColumn(column);
        TableBeanTest.assertTrue((String)"Version Column set should be empty", (boolean)this.bean.getVersionColumns().isEmpty());
    }

    public void testFindVersionColumnByName() {
        String COLUMN_NAME = "My column";
        TableColumn column = this.factory.createTableColumn();
        column.setName(COLUMN_NAME);
        this.bean.addVersionColumn(column);
        TableBeanTest.assertFalse((String)"column set should not be empty", (boolean)this.bean.getVersionColumns().isEmpty());
        TableBeanTest.assertSame((String)"Unable to find column", (Object)column, (Object)this.bean.findVersionColumnByName(COLUMN_NAME));
    }

    public void testGetPrivileges() {
        Set privileges = this.bean.getPrivileges();
        TableBeanTest.assertNotNull((String)"Unable to get privileges", (Object)privileges);
        TableBeanTest.assertTrue((String)"Privilege set should be empty by default", (boolean)privileges.isEmpty());
    }

    public void testAddPrivilege() {
        String NAME = "My privilege";
        Privilege privilege = this.factory.createPrivilege();
        privilege.setName(NAME);
        this.bean.addPrivilege(privilege);
        TableBeanTest.assertFalse((String)"Privilege set should not be empty", (boolean)this.bean.getPrivileges().isEmpty());
    }

    public void testDeletePrivilege() {
        String NAME = "My privilege";
        Privilege privilege = this.factory.createPrivilege();
        privilege.setName(NAME);
        this.bean.addPrivilege(privilege);
        TableBeanTest.assertFalse((String)"Privilege set should not be empty", (boolean)this.bean.getPrivileges().isEmpty());
        this.bean.deletePrivilege(privilege);
        TableBeanTest.assertTrue((String)"Privilege set should be empty", (boolean)this.bean.getPrivileges().isEmpty());
    }

    public void testFindPriviledgeByName() {
        String NAME = "My privilege";
        Privilege privilege = this.factory.createPrivilege();
        privilege.setName(NAME);
        this.bean.addPrivilege(privilege);
        TableBeanTest.assertFalse((String)"Privilege set should not be empty", (boolean)this.bean.getPrivileges().isEmpty());
        TableBeanTest.assertSame((String)"Unable to find privilege", (Object)privilege, (Object)this.bean.findPriviledgeByName(NAME));
    }

    public void testGetBestRowIdentifiers() {
        Set bris = this.bean.getBestRowIdentifiers();
        TableBeanTest.assertNotNull((String)"Unable to get BestRowIdentifiers", (Object)bris);
        TableBeanTest.assertTrue((String)"BestRowIdentifier set should be empty by default", (boolean)bris.isEmpty());
    }

    public void testAddBestRowIdentifier() {
        BestRowIdentifier id = this.factory.createBestRowIdentifier();
        id.setScopeType(BestRowIdentifierScopeType.SESSION);
        this.bean.addBestRowIdentifier(id);
        TableBeanTest.assertFalse((String)"BestRowIdentifier set should not be empty", (boolean)this.bean.getBestRowIdentifiers().isEmpty());
    }

    public void testDeleteBestRowIdentifier() {
        BestRowIdentifier id = this.factory.createBestRowIdentifier();
        id.setScopeType(BestRowIdentifierScopeType.SESSION);
        this.bean.addBestRowIdentifier(id);
        TableBeanTest.assertFalse((String)"BestRowIdentifier set should not be empty", (boolean)this.bean.getBestRowIdentifiers().isEmpty());
        this.bean.deleteBestRowIdentifier(id);
        TableBeanTest.assertTrue((String)"BestRowIdentifier set should be empty", (boolean)this.bean.getBestRowIdentifiers().isEmpty());
    }

    public void testFindBestRowIdentifierByScopeType() {
        BestRowIdentifier id = this.factory.createBestRowIdentifier();
        id.setScopeType(BestRowIdentifierScopeType.SESSION);
        this.bean.addBestRowIdentifier(id);
        TableBeanTest.assertFalse((String)"BestRowIdentifier set should not be empty", (boolean)this.bean.getBestRowIdentifiers().isEmpty());
        TableBeanTest.assertSame((String)"Unable to find BestRowIdentifier", (Object)id, (Object)this.bean.findBestRowIdentifierByScopeType(BestRowIdentifierScopeType.SESSION));
    }

    public void testSetSuperTable() {
        Table superTable = this.factory.createTable();
        this.bean.setSuperTable(superTable);
        TableBeanTest.assertSame((String)"Unable to set super table", (Object)superTable, (Object)this.bean.getSuperTable());
    }
}

