/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.model.spi;

import java.util.Set;
import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.model.DefaultModelFactory;
import org.jboss.dna.common.jdbc.model.api.Parameter;
import org.jboss.dna.common.jdbc.model.api.StoredProcedure;
import org.jboss.dna.common.jdbc.model.api.StoredProcedureResultType;
import org.jboss.dna.common.jdbc.model.spi.StoredProcedureBean;

public class StoredProcedureBeanTest
extends TestCase {
    private StoredProcedure bean;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new StoredProcedureBean();
    }

    protected void tearDown() throws Exception {
        this.bean = null;
        super.tearDown();
    }

    public void testSetResultType() {
        this.bean.setResultType(StoredProcedureResultType.RETURNS_RESULT);
        StoredProcedureBeanTest.assertSame((String)"Unable to set result type", (Object)StoredProcedureResultType.RETURNS_RESULT, (Object)this.bean.getResultType());
    }

    public void testGetParameters() {
        Set parameters = this.bean.getParameters();
        StoredProcedureBeanTest.assertNotNull((String)"Unable to get parameters", (Object)parameters);
        StoredProcedureBeanTest.assertTrue((String)"Parameter set should be empty by default", (boolean)parameters.isEmpty());
    }

    public void testAddParameter() {
        String PARAMETER_NAME = "My parameter";
        Parameter parameter = new DefaultModelFactory().createParameter();
        parameter.setName(PARAMETER_NAME);
        this.bean.addParameter(parameter);
        StoredProcedureBeanTest.assertFalse((String)"Parameter set should not be empty", (boolean)this.bean.getParameters().isEmpty());
    }

    public void testDeleteParameter() {
        String PARAMETER_NAME = "My parameter";
        Parameter parameter = new DefaultModelFactory().createParameter();
        parameter.setName(PARAMETER_NAME);
        this.bean.addParameter(parameter);
        StoredProcedureBeanTest.assertFalse((String)"Parameter set should not be empty", (boolean)this.bean.getParameters().isEmpty());
        this.bean.deleteParameter(parameter);
        StoredProcedureBeanTest.assertTrue((String)"Parameter set should be empty", (boolean)this.bean.getParameters().isEmpty());
    }

    public void testFindParameterByName() {
        String PARAMETER_NAME = "My parameter";
        Parameter parameter = new DefaultModelFactory().createParameter();
        parameter.setName(PARAMETER_NAME);
        this.bean.addParameter(parameter);
        StoredProcedureBeanTest.assertSame((String)"Unable to find parameter", (Object)parameter, (Object)this.bean.findParameterByName(PARAMETER_NAME));
    }
}

