/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.model.spi;

import java.util.Set;
import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.model.DefaultModelFactory;
import org.jboss.dna.common.jdbc.model.api.Index;
import org.jboss.dna.common.jdbc.model.api.IndexColumn;
import org.jboss.dna.common.jdbc.model.api.IndexType;
import org.jboss.dna.common.jdbc.model.spi.IndexBean;

public class IndexBeanTest
extends TestCase {
    private Index bean;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new IndexBean();
    }

    protected void tearDown() throws Exception {
        this.bean = null;
        super.tearDown();
    }

    public void testGetColumns() {
        Set columns = this.bean.getColumns();
        IndexBeanTest.assertNotNull((String)"Unable to get columns", (Object)columns);
        IndexBeanTest.assertTrue((String)"Column set should be empty by default", (boolean)columns.isEmpty());
    }

    public void testAddColumn() {
        String COLUMN_NAME = "My column";
        IndexColumn column = new DefaultModelFactory().createIndexColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        IndexBeanTest.assertFalse((String)"Column set should not be empty", (boolean)this.bean.getColumns().isEmpty());
    }

    public void testDeleteColumn() {
        String COLUMN_NAME = "My column";
        IndexColumn column = new DefaultModelFactory().createIndexColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        IndexBeanTest.assertFalse((String)"Column set should not be empty", (boolean)this.bean.getColumns().isEmpty());
        this.bean.deleteColumn(column);
        IndexBeanTest.assertTrue((String)"Column set should be empty", (boolean)this.bean.getColumns().isEmpty());
    }

    public void testFindColumnByName() {
        String COLUMN_NAME = "My column";
        IndexColumn column = new DefaultModelFactory().createIndexColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        IndexBeanTest.assertSame((String)"Unable to find column", (Object)column, (Object)this.bean.findColumnByName(COLUMN_NAME));
    }

    public void testSetUnique() {
        Boolean unique = Boolean.TRUE;
        this.bean.setUnique(unique);
        IndexBeanTest.assertSame((String)"Unable to set unique", (Object)unique, (Object)this.bean.isUnique());
    }

    public void testSetIndexType() {
        this.bean.setIndexType(IndexType.CLUSTERED);
        IndexBeanTest.assertSame((String)"Unable to set index type", (Object)IndexType.CLUSTERED, (Object)this.bean.getIndexType());
    }

    public void testSetCardinality() {
        Integer cardinality = new Integer(1);
        this.bean.setCardinality(cardinality);
        IndexBeanTest.assertSame((String)"Unable to set cardinality", (Object)cardinality, (Object)this.bean.getCardinality());
    }

    public void testSetPages() {
        Integer pages = new Integer(1);
        this.bean.setPages(pages);
        IndexBeanTest.assertSame((String)"Unable to set pages", (Object)pages, (Object)this.bean.getPages());
    }

    public void testSetFilterCondition() {
        String filterCondition = "IS NOT NULL";
        this.bean.setFilterCondition(filterCondition);
        IndexBeanTest.assertSame((String)"Unable to set filter condition", (Object)filterCondition, (Object)this.bean.getFilterCondition());
    }
}

