/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.maven.spi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Calendar;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.ItemExistsException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.common.text.TextEncoder;
import org.jboss.dna.common.text.UrlEncoder;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.maven.ArtifactType;
import org.jboss.dna.maven.MavenI18n;
import org.jboss.dna.maven.MavenId;
import org.jboss.dna.maven.MavenRepositoryException;
import org.jboss.dna.maven.MavenUrl;
import org.jboss.dna.maven.SignatureType;
import org.jboss.dna.maven.spi.AbstractMavenUrlProvider;

public class JcrMavenUrlProvider
extends AbstractMavenUrlProvider {
    public static final String USERNAME = "dna.maven.urlprovider.username";
    public static final String PASSWORD = "dna.maven.urlprovider.password";
    public static final String WORKSPACE_NAME = "dna.maven.urlprovider.repository.workspace";
    public static final String REPOSITORY_PATH = "dna.maven.urlprovider.repository.path";
    public static final String DEFAULT_PATH_TO_TOP_OF_MAVEN_REPOSITORY = "/dnaMavenRepository";
    public static final String DEFAULT_CREATE_REPOSITORY_PATH = Boolean.TRUE.toString();
    public static final String CONTENT_NODE_NAME = "jcr:content";
    public static final String CONTENT_PROPERTY_NAME = "jcr:data";
    private final URLStreamHandler urlStreamHandler = new JcrUrlStreamHandler();
    private final TextEncoder urlEncoder;
    private final TextDecoder urlDecoder;
    private Repository repository;
    private String workspaceName;
    private Credentials credentials;
    private String pathToTopOfRepository = "/dnaMavenRepository";
    private final Logger logger = Logger.getLogger(JcrMavenUrlProvider.class);

    public JcrMavenUrlProvider() {
        UrlEncoder encoder = new UrlEncoder().setSlashEncoded(false);
        this.urlEncoder = encoder;
        this.urlDecoder = encoder;
    }

    public void configure(Properties properties) {
        super.configure(properties);
        properties = super.getProperties();
        String username = properties.getProperty(USERNAME);
        if (username != null) {
            String password = properties.getProperty(PASSWORD, "");
            this.setCredentials((Credentials)new SimpleCredentials(username, password.toCharArray()));
        }
        this.setWorkspaceName(properties.getProperty(WORKSPACE_NAME, this.getWorkspaceName()));
        this.setPathToTopOfRepository(properties.getProperty(REPOSITORY_PATH, this.getPathToTopOfRepository()));
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String getPathToTopOfRepository() {
        return this.pathToTopOfRepository;
    }

    public void setPathToTopOfRepository(String pathToTopOfRepository) {
        this.pathToTopOfRepository = pathToTopOfRepository != null ? pathToTopOfRepository.trim() : DEFAULT_PATH_TO_TOP_OF_MAVEN_REPOSITORY;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getUrl(MavenId mavenId, ArtifactType artifactType, SignatureType signatureType, boolean createIfRequired) throws MalformedURLException, MavenRepositoryException {
        String path = this.getUrlPath(mavenId, artifactType, signatureType);
        MavenUrl mavenUrl = new MavenUrl();
        mavenUrl.setWorkspaceName(this.getWorkspaceName());
        mavenUrl.setPath(path);
        if (!createIfRequired) return mavenUrl.getUrl(this.urlStreamHandler, this.urlEncoder);
        boolean metadataFile = ArtifactType.METADATA == artifactType;
        String relPath = mavenId.getRelativePath(!metadataFile);
        Session session = null;
        try {
            try {
                session = this.createSession();
                Node root = session.getRootNode();
                Node top = this.getOrCreatePath(root, this.getPathToTopOfRepository(), "nt:folder");
                session.save();
                Node current = this.getOrCreatePath(top, relPath, "nt:folder");
                if (artifactType != null) {
                    String name = metadataFile ? "" : mavenId.getArtifactId() + "-" + mavenId.getVersion();
                    name = name + artifactType.getSuffix();
                    if (signatureType != null) {
                        name = name + signatureType.getSuffix();
                    }
                    if (!(current = current.hasNode(name) ? current.getNode(name) : current.addNode(name, "nt:file")).hasNode(CONTENT_NODE_NAME)) {
                        Node contentNode = current.addNode(CONTENT_NODE_NAME, "nt:resource");
                        contentNode.setProperty("jcr:mimeType", "text/plain");
                        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                        contentNode.setProperty(CONTENT_PROPERTY_NAME, (InputStream)new ByteArrayInputStream("".getBytes()));
                    }
                }
                session.save();
                this.logger.trace("Created Maven repository node for {0}", new Object[]{mavenUrl});
            }
            catch (LoginException err) {
                throw new MavenRepositoryException(MavenI18n.unableToOpenSessiontoRepositoryWhenCreatingNode.text(new Object[]{mavenUrl, err.getMessage()}), err);
            }
            catch (NoSuchWorkspaceException err) {
                throw new MavenRepositoryException(MavenI18n.unableToFindWorkspaceWhenCreatingNode.text(new Object[]{this.getWorkspaceName(), mavenUrl, err.getMessage()}), err);
            }
            catch (PathNotFoundException err) {
                URL uRL = null;
                Object var16_21 = null;
                if (session == null) return uRL;
                session.logout();
                return uRL;
            }
            catch (RepositoryException err) {
                throw new MavenRepositoryException(MavenI18n.errorCreatingNode.text(new Object[]{mavenUrl, err.getMessage()}), err);
            }
            Object var16_20 = null;
            if (session == null) return mavenUrl.getUrl(this.urlStreamHandler, this.urlEncoder);
        }
        catch (Throwable throwable) {
            Object var16_22 = null;
            if (session == null) throw throwable;
            session.logout();
            throw throwable;
        }
        session.logout();
        return mavenUrl.getUrl(this.urlStreamHandler, this.urlEncoder);
    }

    protected Node getOrCreatePath(Node root, String relPath, String nodeType) throws PathNotFoundException, ItemExistsException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        String[] pathComponents;
        Node current = root;
        boolean created = false;
        for (String pathComponent : pathComponents = relPath.replaceFirst("^/+", "").split("/")) {
            if (pathComponent.length() == 0) continue;
            if (current.hasNode(pathComponent)) {
                current = current.getNode(pathComponent);
                continue;
            }
            current = current.addNode(pathComponent, "nt:folder");
            created = true;
        }
        if (created) {
            this.logger.debug("Created Maven repository folders {0}", new Object[]{current.getPath()});
        }
        return current;
    }

    protected Node getContentNodeForMavenResource(Session session, MavenUrl mavenUrl) throws RepositoryException {
        String mavenPath = mavenUrl.getPath().replaceFirst("^/+", "");
        String mavenRootPath = this.getPathToTopOfRepository().replaceFirst("^/+", "");
        Node root = session.getRootNode();
        Node top = root.getNode(mavenRootPath);
        Node resourceNode = top.getNode(mavenPath);
        return resourceNode.getNode(CONTENT_NODE_NAME);
    }

    protected String getUrlPath(MavenId mavenId, ArtifactType artifactType, SignatureType signatureType) {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        if (artifactType == null) {
            sb.append(mavenId.getRelativePath());
            sb.append("/");
        } else if (ArtifactType.METADATA == artifactType) {
            sb.append(mavenId.getRelativePath(false));
            sb.append("/");
        } else {
            sb.append(mavenId.getRelativePath());
            sb.append("/");
            sb.append(mavenId.getArtifactId());
            sb.append("-");
            sb.append(mavenId.getVersion());
        }
        if (artifactType != null) {
            sb.append(artifactType.getSuffix());
        }
        if (signatureType != null) {
            sb.append(signatureType.getSuffix());
        }
        return sb.toString();
    }

    protected TextEncoder getUrlEncoder() {
        return this.urlEncoder;
    }

    protected TextDecoder getUrlDecoder() {
        return this.urlDecoder;
    }

    protected Session createSession() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (this.workspaceName != null) {
            if (this.credentials != null) {
                return this.repository.login(this.credentials, this.workspaceName);
            }
            return this.repository.login(this.workspaceName);
        }
        if (this.credentials != null) {
            return this.repository.login(this.credentials);
        }
        return this.repository.login();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream getInputStream(MavenUrl mavenUrl) throws IOException {
        InputStream inputStream;
        Session session = null;
        try {
            try {
                session = this.createSession();
                Node contentNode = this.getContentNodeForMavenResource(session, mavenUrl);
                Property contentProperty = contentNode.getProperty(CONTENT_PROPERTY_NAME);
                InputStream result = contentProperty.getStream();
                inputStream = result = new MavenInputStream(session, result);
                Object var8_12 = null;
                if (session == null) return inputStream;
            }
            catch (LoginException err) {
                throw new MavenRepositoryException(MavenI18n.unableToOpenSessiontoRepositoryWhenReadingNode.text(new Object[]{mavenUrl, err.getMessage()}), err);
            }
            catch (NoSuchWorkspaceException err) {
                throw new MavenRepositoryException(MavenI18n.unableToFindWorkspaceWhenReadingNode.text(new Object[]{this.getWorkspaceName(), mavenUrl, err.getMessage()}), err);
            }
            catch (PathNotFoundException err) {
                InputStream inputStream2 = null;
                Object var8_13 = null;
                if (session == null) return inputStream2;
                session.logout();
                return inputStream2;
            }
            catch (RepositoryException err) {
                throw new MavenRepositoryException(MavenI18n.errorReadingNode.text(new Object[]{mavenUrl, err.getMessage()}), err);
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (session == null) throw throwable;
            session.logout();
            throw throwable;
        }
        session.logout();
        return inputStream;
    }

    protected OutputStream getOutputStream(MavenUrl mavenUrl) throws IOException {
        try {
            MavenOutputStream result = null;
            try {
                File tempFile = File.createTempFile("dnamaven", null);
                result = new MavenOutputStream(mavenUrl, tempFile);
            }
            catch (IOException err) {
                throw new RepositoryException("Unable to obtain a temporary file for streaming content to " + mavenUrl, (Throwable)err);
            }
            return result;
        }
        catch (LoginException err) {
            throw new MavenRepositoryException(MavenI18n.unableToOpenSessiontoRepositoryWhenReadingNode.text(new Object[]{mavenUrl, err.getMessage()}), err);
        }
        catch (NoSuchWorkspaceException err) {
            throw new MavenRepositoryException(MavenI18n.unableToFindWorkspaceWhenReadingNode.text(new Object[]{this.getWorkspaceName(), mavenUrl, err.getMessage()}), err);
        }
        catch (RepositoryException err) {
            throw new MavenRepositoryException(MavenI18n.errorReadingNode.text(new Object[]{mavenUrl, err.getMessage()}), err);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContent(MavenUrl mavenUrl, InputStream content) throws IOException {
        Session session = null;
        try {
            try {
                session = this.createSession();
                Node contentNode = this.getContentNodeForMavenResource(session, mavenUrl);
                contentNode.setProperty(CONTENT_PROPERTY_NAME, content);
                session.save();
            }
            catch (LoginException err) {
                throw new IOException(MavenI18n.unableToOpenSessiontoRepositoryWhenWritingNode.text(new Object[]{mavenUrl, err.getMessage()}));
            }
            catch (NoSuchWorkspaceException err) {
                throw new IOException(MavenI18n.unableToFindWorkspaceWhenWritingNode.text(new Object[]{this.getWorkspaceName(), mavenUrl, err.getMessage()}));
            }
            catch (RepositoryException err) {
                throw new IOException(MavenI18n.errorWritingNode.text(new Object[]{mavenUrl, err.getMessage()}));
            }
            Object var6_8 = null;
            if (session == null) return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (session == null) throw throwable;
            session.logout();
            throw throwable;
        }
        session.logout();
    }

    protected class MavenUrlConnection
    extends URLConnection {
        private final MavenUrl mavenUrl;

        protected MavenUrlConnection(URL url) {
            super(url);
            this.mavenUrl = MavenUrl.parse(url, JcrMavenUrlProvider.this.getUrlDecoder());
        }

        public void connect() throws IOException {
            if (this.mavenUrl == null) {
                String msg = "Unable to connect to JCR repository because the URL is not valid for JCR: " + this.getURL();
                throw new IOException(msg);
            }
        }

        public InputStream getInputStream() throws IOException {
            return JcrMavenUrlProvider.this.getInputStream(this.mavenUrl);
        }

        public OutputStream getOutputStream() throws IOException {
            return JcrMavenUrlProvider.this.getOutputStream(this.mavenUrl);
        }
    }

    protected class JcrUrlStreamHandler
    extends URLStreamHandler {
        protected JcrUrlStreamHandler() {
        }

        protected URLConnection openConnection(URL url) {
            return new MavenUrlConnection(url);
        }
    }

    protected class MavenOutputStream
    extends OutputStream {
        private OutputStream stream;
        private final File file;
        private final MavenUrl mavenUrl;

        protected MavenOutputStream(MavenUrl mavenUrl, File file) throws FileNotFoundException {
            this.mavenUrl = mavenUrl;
            this.file = file;
            this.stream = new BufferedOutputStream(new FileOutputStream(this.file));
            assert (this.file != null);
        }

        public void write(int b) throws IOException {
            if (this.stream == null) {
                throw new IOException(MavenI18n.unableToWriteToClosedStream.text(new Object[0]));
            }
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            if (this.stream == null) {
                throw new IOException(MavenI18n.unableToWriteToClosedStream.text(new Object[0]));
            }
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.stream == null) {
                throw new IOException(MavenI18n.unableToWriteToClosedStream.text(new Object[0]));
            }
            this.stream.write(b, off, len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void close() throws IOException {
            if (this.stream != null) {
                block24: {
                    Object v3;
                    this.stream.close();
                    BufferedInputStream inputStream = null;
                    try {
                        inputStream = new BufferedInputStream(new FileInputStream(this.file));
                        JcrMavenUrlProvider.this.setContent(this.mavenUrl, inputStream);
                        Object var3_2 = null;
                        if (inputStream == null) break block24;
                    }
                    catch (Throwable throwable) {
                        block29: {
                            Object var3_3 = null;
                            if (inputStream != null) {
                                Object v0;
                                ((InputStream)inputStream).close();
                                Object var6_7 = null;
                                try {
                                    try {
                                        this.file.delete();
                                        v0 = null;
                                    }
                                    catch (SecurityException se) {
                                        Logger.getLogger(this.getClass()).error((Throwable)se, MavenI18n.errorDeletingTempFileStreamAfterWritingContent, new Object[]{this.mavenUrl, se.getMessage()});
                                        v0 = null;
                                    }
                                }
                                catch (Throwable throwable2) {
                                    v0 = null;
                                }
                                Object var9_25 = v0;
                                this.stream = null;
                                {
                                    break block29;
                                    catch (IOException ioe) {
                                        Object v1;
                                        Logger.getLogger(this.getClass()).error((Throwable)ioe, MavenI18n.errorClosingTempFileStreamAfterWritingContent, new Object[]{this.mavenUrl, ioe.getMessage()});
                                        Object var6_8 = null;
                                        try {
                                            try {
                                                this.file.delete();
                                                v1 = null;
                                            }
                                            catch (SecurityException se) {
                                                Logger.getLogger(this.getClass()).error((Throwable)se, MavenI18n.errorDeletingTempFileStreamAfterWritingContent, new Object[]{this.mavenUrl, se.getMessage()});
                                                v1 = null;
                                            }
                                        }
                                        catch (Throwable throwable3) {
                                            v1 = null;
                                        }
                                        Object var9_26 = v1;
                                        this.stream = null;
                                    }
                                }
                                catch (Throwable throwable4) {
                                    Object v2;
                                    Object var6_9 = null;
                                    try {
                                        try {
                                            this.file.delete();
                                            v2 = null;
                                        }
                                        catch (SecurityException se) {
                                            Logger.getLogger(this.getClass()).error((Throwable)se, MavenI18n.errorDeletingTempFileStreamAfterWritingContent, new Object[]{this.mavenUrl, se.getMessage()});
                                            v2 = null;
                                        }
                                    }
                                    catch (Throwable throwable5) {
                                        v2 = null;
                                    }
                                    Object var9_27 = v2;
                                    this.stream = null;
                                    throw throwable4;
                                }
                            }
                        }
                        throw throwable;
                    }
                    ((InputStream)inputStream).close();
                    Object var6_4 = null;
                    try {
                        try {
                            this.file.delete();
                            v3 = null;
                        }
                        catch (SecurityException se) {
                            Logger.getLogger(this.getClass()).error((Throwable)se, MavenI18n.errorDeletingTempFileStreamAfterWritingContent, new Object[]{this.mavenUrl, se.getMessage()});
                            v3 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v3 = null;
                    }
                    Object var9_22 = v3;
                    this.stream = null;
                    {
                        break block24;
                        catch (IOException ioe) {
                            Object v4;
                            Logger.getLogger(this.getClass()).error((Throwable)ioe, MavenI18n.errorClosingTempFileStreamAfterWritingContent, new Object[]{this.mavenUrl, ioe.getMessage()});
                            Object var6_5 = null;
                            try {
                                try {
                                    this.file.delete();
                                    v4 = null;
                                }
                                catch (SecurityException se) {
                                    Logger.getLogger(this.getClass()).error((Throwable)se, MavenI18n.errorDeletingTempFileStreamAfterWritingContent, new Object[]{this.mavenUrl, se.getMessage()});
                                    v4 = null;
                                }
                            }
                            catch (Throwable throwable) {
                                v4 = null;
                            }
                            Object var9_23 = v4;
                            this.stream = null;
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        Object v5;
                        Object var6_6 = null;
                        try {
                            try {
                                this.file.delete();
                                v5 = null;
                            }
                            catch (SecurityException se) {
                                Logger.getLogger(this.getClass()).error((Throwable)se, MavenI18n.errorDeletingTempFileStreamAfterWritingContent, new Object[]{this.mavenUrl, se.getMessage()});
                                v5 = null;
                            }
                        }
                        catch (Throwable throwable6) {
                            v5 = null;
                        }
                        Object var9_24 = v5;
                        this.stream = null;
                        throw throwable;
                    }
                }
                super.close();
            }
        }
    }

    protected class MavenInputStream
    extends InputStream {
        private final InputStream stream;
        private final Session session;

        protected MavenInputStream(Session session, InputStream stream) {
            this.session = session;
            this.stream = stream;
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.stream.close();
            }
            finally {
                this.session.logout();
            }
        }
    }
}

