/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.explicit;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSArchiveStructureDeployer;
import org.jboss.deployers.vfs.plugins.structure.explicit.StructureMetaDataObjectFactory;
import org.jboss.deployers.vfs.plugins.structure.jar.JARStructure;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.vfs.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaredStructure
extends AbstractVFSArchiveStructureDeployer {
    private final Set<String> suffixes;

    public DeclaredStructure() {
        this(JARStructure.DEFAULT_JAR_SUFFIXES);
    }

    public DeclaredStructure(Set<String> suffixes) {
        this.setRelativeOrder(0);
        if (suffixes == null) {
            throw new IllegalArgumentException("Null suffixes");
        }
        this.suffixes = suffixes;
    }

    @Override
    protected boolean hasValidSuffix(String name) {
        int idx = name.lastIndexOf(46);
        return idx != -1 && this.suffixes.contains(name.substring(idx).toLowerCase());
    }

    @Override
    public boolean doDetermineStructure(StructureContext structureContext) throws DeploymentException {
        block8: {
            VirtualFile file = structureContext.getFile();
            try {
                boolean trace = log.isTraceEnabled();
                if (DeclaredStructure.isLeaf((VirtualFile)file)) break block8;
                boolean isJBossStructure = false;
                if (trace) {
                    log.trace((Object)(file + " is not a leaf"));
                }
                try {
                    VirtualFile jbossStructure = file.getChild("META-INF/jboss-structure.xml");
                    if (jbossStructure.exists()) {
                        if (trace) {
                            log.trace((Object)"... context has a META-INF/jboss-structure.xml");
                        }
                        URL url = jbossStructure.toURL();
                        UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
                        Unmarshaller unmarshaller = factory.newUnmarshaller();
                        StructureMetaDataObjectFactory ofactory = new StructureMetaDataObjectFactory();
                        unmarshaller.unmarshal(url.toString(), (ObjectModelFactory)ofactory, (Object)structureContext.getMetaData());
                        this.mountChildren(structureContext);
                        isJBossStructure = true;
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Exception while looking for META-INF/jboss-structure.xml: " + e));
                }
                if (trace) {
                    log.trace((Object)(file + " isJBossStructure: " + isJBossStructure));
                }
                return isJBossStructure;
            }
            catch (Exception e) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
            }
        }
        return false;
    }

    protected void mountChildren(StructureContext structureContext) throws IOException {
        StructureMetaData structureMetaData = structureContext.getMetaData();
        VirtualFile structureRoot = structureContext.getRoot();
        for (ContextInfo contextInfo : structureMetaData.getContexts()) {
            VirtualFile child;
            String contextPath = contextInfo.getPath();
            if (!this.hasValidSuffix(contextPath) || !(child = structureRoot.getChild(contextPath)).exists() || !child.isFile()) continue;
            this.performMount(child);
        }
    }
}

