/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaDataFactory;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.metadata.RequirementsMetaData;
import org.jboss.classloading.spi.metadata.helpers.AbstractRequirement;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractOptionalVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequirementIntegrationDeployer<T>
extends AbstractOptionalVFSRealDeployer<T> {
    private String integrationModuleName;

    public RequirementIntegrationDeployer(Class<T> input) {
        super(input);
        this.setStage(DeploymentStages.DESCRIBE);
        this.addInput(ClassLoadingMetaData.class);
        this.setOutput(ClassLoadingMetaData.class);
    }

    public String getIntegrationModuleName() {
        return this.integrationModuleName;
    }

    public void setIntegrationModuleName(String integrationModuleName) {
        this.integrationModuleName = integrationModuleName;
    }

    public void deploy(VFSDeploymentUnit unit, T metaData) throws DeploymentException {
        ClassLoadingMetaData clmd = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        RequirementsMetaData requirements = clmd.getRequirements();
        AbstractRequirement integrationModule = this.hasIntegrationModuleRequirement(requirements);
        if (integrationModule != null) {
            ClassLoadingMetaDataFactory factory = ClassLoadingMetaDataFactory.getInstance();
            Requirement integrationRequirement = factory.createRequireModule(this.integrationModuleName, integrationModule.getVersionRange());
            requirements.addRequirement(integrationRequirement);
        }
    }

    protected abstract AbstractRequirement hasIntegrationModuleRequirement(RequirementsMetaData var1);
}

