/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.dataset.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.database.DataSourceFragment;
import org.jboss.dashboard.dataset.AbstractDataSet;
import org.jboss.dashboard.dataset.sql.SQLStatement;
import org.jboss.dashboard.provider.DataFilter;
import org.jboss.dashboard.provider.DataProperty;
import org.jboss.dashboard.provider.DataProvider;
import org.jboss.dashboard.provider.sql.SQLDataLoader;
import org.jboss.dashboard.provider.sql.SQLDataProperty;

public class SQLDataSet
extends AbstractDataSet {
    private static transient Log log = LogFactory.getLog(SQLDataSet.class);
    protected String dataSource;
    protected String sqlQuery;
    protected transient SQLStatement lastExecutedStmt;

    public SQLDataSet(DataProvider provider, SQLDataLoader loader) {
        super(provider);
        this.dataSource = loader.getDataSource();
        this.sqlQuery = loader.getSQLQuery();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getSQLQuery() {
        return this.sqlQuery;
    }

    public SQLDataProperty createSQLProperty() {
        return new SQLDataProperty();
    }

    public SQLStatement createSQLStatament() throws Exception {
        return new SQLStatement(this.sqlQuery);
    }

    public void load() throws Exception {
        new DataSourceFragment(this.dataSource){

            protected void fragment(Connection connection) throws Exception {
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    int i;
                    SQLDataSet.this.lastExecutedStmt = SQLDataSet.this.createSQLStatament();
                    log.debug((Object)("Load data set from datasource=" + SQLDataSet.this.dataSource + " SQL=" + SQLDataSet.this.lastExecutedStmt.getSQLSentence()));
                    stmt = SQLDataSet.this.lastExecutedStmt.getPreparedStatement(connection);
                    rs = stmt.executeQuery();
                    ResultSetMetaData meta = rs.getMetaData();
                    int propsSize = meta.getColumnCount();
                    SQLDataSet.this.setPropertySize(propsSize);
                    for (i = 0; i < propsSize; ++i) {
                        SQLDataProperty dp = SQLDataSet.this.createSQLProperty();
                        dp.setPropertyId(meta.getColumnName(i + 1).toLowerCase());
                        dp.setType(meta.getColumnType(i + 1));
                        dp.setTableName(meta.getTableName(i + 1));
                        dp.setColumnName(meta.getColumnName(i + 1));
                        SQLDataSet.this.addProperty((DataProperty)dp, i);
                    }
                    while (rs.next()) {
                        Object[] row = new Object[propsSize];
                        for (int i2 = 0; i2 < propsSize; ++i2) {
                            row[i2] = rs.getObject(i2 + 1);
                        }
                        SQLDataSet.this.addRowValues(row);
                    }
                    for (i = 0; i < SQLDataSet.this.properties.length; ++i) {
                        SQLDataProperty property = (SQLDataProperty)SQLDataSet.this.properties[i];
                        property.calculateDomain();
                    }
                }
                catch (Exception e) {
                    if (SQLDataSet.this.lastExecutedStmt != null) {
                        log.error((Object)("Error in load() SQLDataset. SQL = " + SQLDataSet.this.lastExecutedStmt.getSQLSentence()), (Throwable)e);
                    }
                    throw e;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error closing ResultSet: ", (Throwable)e);
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error closing PreparedStatement: ", (Throwable)e);
                    }
                }
            }
        }.execute();
    }

    public void filter(DataFilter filter) throws Exception {
        SQLStatement currentStatement = this.createSQLStatament();
        if (!this.lastExecutedStmt.equals(currentStatement)) {
            this.load();
        }
        super.filter(filter);
    }
}

