/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.provider.csv;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.annotation.Install;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.export.DataLoaderXMLFormat;
import org.jboss.dashboard.provider.DataLoader;
import org.jboss.dashboard.provider.DataProviderType;
import org.jboss.dashboard.provider.csv.CSVDataLoader;
import org.jboss.dashboard.provider.csv.CSVDataLoaderXMLFormat;

@Install
public class CSVDataProviderType
implements DataProviderType {
    public static final String UID = "csv";
    @Inject
    @Config(value="csv")
    protected String uid;
    @Inject
    @Config(value=";")
    protected String csvSeparatedBy;
    @Inject
    @Config(value="\"")
    protected String csvQuoteChar;
    @Inject
    @Config(value="\\")
    protected String csvEscapeChar;
    @Inject
    @Config(value="MM-dd-yyyy HH:mm:ss")
    protected String csvDatePattern;
    @Inject
    @Config(value="#,###.##")
    protected String csvNumberPattern;
    @Inject
    protected LocaleManager localeManager;
    protected CSVDataLoaderXMLFormat xmlFormat = new CSVDataLoaderXMLFormat();

    public String getUid() {
        return this.uid;
    }

    public DataLoaderXMLFormat getXmlFormat() {
        return this.xmlFormat;
    }

    public String getDescription(Locale l) {
        ResourceBundle i18n = this.localeManager.getBundle("org.jboss.dashboard.provider.messages", l);
        return i18n.getString("provider.csv.description");
    }

    public DataLoader createDataLoader() {
        CSVDataLoader loader = new CSVDataLoader();
        loader.setCsvSeparatedBy(this.csvSeparatedBy);
        loader.setCsvQuoteChar(this.csvQuoteChar);
        loader.setCsvEscapeChar(this.csvEscapeChar);
        loader.setCsvDatePattern(this.csvDatePattern);
        loader.setCsvNumberPattern(this.csvNumberPattern);
        loader.setDataProviderType(this);
        return loader;
    }
}

