/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.dataset.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.dataset.AbstractDataSet;
import org.jboss.dashboard.domain.Domain;
import org.jboss.dashboard.domain.date.DateDomain;
import org.jboss.dashboard.domain.label.LabelDomain;
import org.jboss.dashboard.domain.numeric.NumericDomain;
import org.jboss.dashboard.provider.DataProperty;
import org.jboss.dashboard.provider.DataProvider;
import org.jboss.dashboard.provider.csv.CSVDataLoader;
import org.jboss.dashboard.provider.csv.CSVDataProperty;

public class CSVDataSet
extends AbstractDataSet {
    protected CSVReader csvReader;
    protected CSVDataLoader csvLoader;
    protected transient DateFormat _dateFormat;
    protected transient DecimalFormat _numberFormat;
    protected static transient Log log = LogFactory.getLog(CSVDataSet.class);

    public CSVDataSet(DataProvider provider, CSVDataLoader loader) {
        super(provider);
        this.csvLoader = loader;
        DecimalFormatSymbols numberSymbols = new DecimalFormatSymbols();
        numberSymbols.setGroupingSeparator(this.csvLoader.getCsvNumberGroupSeparator());
        numberSymbols.setDecimalSeparator(this.csvLoader.getCsvNumberDecimalSeparator());
        this._numberFormat = new DecimalFormat("#,##0.00", numberSymbols);
        this._dateFormat = new SimpleDateFormat(this.csvLoader.getCsvDatePattern());
    }

    public CSVDataProperty createCSVProperty() {
        return new CSVDataProperty();
    }

    public void load() throws Exception {
        try {
            File f = this.csvLoader.getCsvProviderFile();
            if (f == null || !f.exists() || !f.canRead()) {
                throw new IOException("Can't load data from file : '" + f + "'");
            }
            FileReader fileReader = new FileReader(f);
            BufferedReader br = new BufferedReader(fileReader);
            this.csvReader = new CSVReader((Reader)br, this.csvLoader.getCsvSeparatedBy().charAt(0), this.csvLoader.getCsvQuoteChar().charAt(0), this.csvLoader.getCsvEscapeChar().charAt(0));
            List lines = this.csvReader.readAll();
            String[] header = (String[])lines.get(0);
            String[] firstRow = (String[])lines.get(1);
            this.setPropertySize(header.length);
            for (int i = 0; i < firstRow.length; ++i) {
                String token = header[i];
                String value = firstRow[i];
                Domain domain = this.calculateDomain(value);
                CSVDataProperty dp = this.createCSVProperty();
                dp.setPropertyId(token.toLowerCase());
                dp.setDomain(domain);
                this.addProperty((DataProperty)dp, i);
            }
            for (int lc = 1; lc < lines.size(); ++lc) {
                String[] line = (String[])lines.get(lc);
                Object[] row = new Object[header.length];
                for (int i = 0; i < line.length; ++i) {
                    String valueStr = line[i];
                    CSVDataProperty prop = (CSVDataProperty)this.getProperties()[i];
                    row[i] = !StringUtils.isBlank((String)valueStr) ? this.parseValue(prop, valueStr) : null;
                }
                this.addRowValues(row);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading CSV data.", (Throwable)e);
            throw e;
        }
    }

    public Domain calculateDomain(String value) {
        try {
            this._dateFormat.parse(value);
            return new DateDomain();
        }
        catch (Exception e) {
            try {
                this._numberFormat.parse(value);
                return new NumericDomain();
            }
            catch (Exception ee) {
                return new LabelDomain();
            }
        }
    }

    public Object parseValue(CSVDataProperty prop, String value) throws Exception {
        Domain domain = prop.getDomain();
        try {
            if (domain instanceof DateDomain) {
                return this._dateFormat.parse(value);
            }
            if (domain instanceof NumericDomain) {
                return new Double(this._numberFormat.parse(value).doubleValue());
            }
            return value;
        }
        catch (ParseException e) {
            String msg = "Error parsing value: " + value + ", " + e.getMessage() + ". Check column's data type consistency!";
            log.error((Object)msg);
            throw new Exception(msg);
        }
    }
}

