/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.cluster;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jboss.dashboard.annotation.Priority;
import org.jboss.dashboard.annotation.Startable;
import org.jboss.dashboard.cluster.ClusterNode;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ClusterNodesManager
implements Startable {
    public static transient Logger log = LoggerFactory.getLogger((String)ClusterNodesManager.class.getName());
    private Long currentNodeId;
    private String currentNodeIpAddress;

    @Override
    public Priority getPriority() {
        return Priority.HIGH;
    }

    @Override
    public void start() throws Exception {
        this.currentNodeIpAddress = this.getIPAddress();
        log.info("Registering cluster node with ip address " + this.currentNodeIpAddress);
        final ClusterNode[] result = new ClusterNode[1];
        new HibernateTxFragment(true, true){

            @Override
            protected void txFragment(Session session) throws Exception {
                ClusterNode node = ClusterNodesManager.this.getNodeByIpAddress(ClusterNodesManager.this.currentNodeIpAddress);
                if (node == null) {
                    node = new ClusterNode();
                }
                node.setNodeAddress(ClusterNodesManager.this.currentNodeIpAddress);
                node.setStartupTime(new Date());
                node.setNodeStatus(ClusterNode.ClusterNodeStatus.REGISTERED.name());
                session.saveOrUpdate((Object)node);
                session.flush();
                result[0] = node;
            }

            @Override
            protected void afterRollback() throws Throwable {
                super.afterRollback();
                log.error("This cluster node cannot be registered.");
            }
        }.execute();
        if (result[0] != null) {
            this.currentNodeId = result[0].getId();
        }
        log.info("Successfully registered cluster node with ip address " + this.currentNodeIpAddress + " and identifier " + this.currentNodeId);
    }

    public void deregister(final Long nodeId) throws Exception {
        if (nodeId == null) {
            log.error("This cluster node was not previously registered.");
            return;
        }
        log.info("Deregistering cluster node with id " + nodeId);
        new HibernateTxFragment(true, true){

            @Override
            protected void txFragment(Session session) throws Exception {
                Query query = session.createQuery("delete from " + ClusterNode.class.getName() + " cn  where cn.id = :idNode");
                query.setLong("idNode", nodeId.longValue());
                query.executeUpdate();
                session.flush();
            }

            @Override
            protected void afterRollback() throws Throwable {
                super.afterRollback();
                log.error("This cluster node cannot be deregistered.");
            }
        }.execute();
        log.info("Successfully deregistered cluster node with id " + nodeId);
    }

    public List<ClusterNode> getNodeByStatus(final ClusterNode.ClusterNodeStatus status) throws Exception {
        final ArrayList<ClusterNode> result = new ArrayList<ClusterNode>();
        if (status != null) {
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    Query query = session.createQuery("from " + ClusterNode.class.getName() + " cn  where cn.nodeStatus = :nStatus");
                    query.setString("nStatus", status.name());
                    List queryResult = query.list();
                    if (queryResult != null && !queryResult.isEmpty()) {
                        for (Object obj : queryResult) {
                            result.add((ClusterNode)obj);
                        }
                    }
                }
            }.execute();
        }
        return result;
    }

    public ClusterNode getNodeById(final Long id) throws Exception {
        final ClusterNode[] result = new ClusterNode[1];
        if (id != null) {
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    Query query = session.createQuery("from " + ClusterNode.class.getName() + "  cn  where cn.id = :idToSearch");
                    query.setLong("idToSearch", id.longValue());
                    List queryResult = query.list();
                    if (queryResult.size() > 1) {
                        log.error("There is more than one cluster node resgistered for identifier " + id + ".!!!");
                    }
                    if (!queryResult.isEmpty()) {
                        result[0] = (ClusterNode)queryResult.get(0);
                    }
                }
            }.execute();
        }
        return result[0];
    }

    public ClusterNode getNodeByIpAddress(final String ip) throws Exception {
        final ClusterNode[] result = new ClusterNode[1];
        if (ip != null) {
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    Query query = session.createQuery("from " + ClusterNode.class.getName() + "  cn  where cn.nodeAddress = :ipToSearch");
                    query.setString("ipToSearch", ip);
                    List queryResult = query.list();
                    if (queryResult.size() > 1) {
                        log.error("There is more than one cluster node resgistered for IP address: " + ip + ".");
                    }
                    if (!queryResult.isEmpty()) {
                        result[0] = (ClusterNode)queryResult.get(0);
                    }
                }
            }.execute();
        }
        return result[0];
    }

    protected String getIPAddress() throws SocketException {
        String ip = null;
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            if (iface.isLoopback() || !iface.isUp()) continue;
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                ip = addr.getHostAddress();
            }
        }
        return ip;
    }

    public void setNodeStatus(final Long nodeId, final ClusterNode.ClusterNodeStatus newStatus) throws Exception {
        new HibernateTxFragment(){

            @Override
            protected void txFragment(Session session) throws Exception {
                ClusterNode node = ClusterNodesManager.this.getNodeById(nodeId);
                if (node == null) {
                    log.error("Cannot set status " + newStatus.name() + " to target node. Node with identifier " + nodeId + " not found.");
                } else {
                    node.setNodeStatus(newStatus.name());
                    session.saveOrUpdate((Object)node);
                    session.flush();
                }
            }
        }.execute();
    }

    public boolean shouldInstallModules() throws Exception {
        final Boolean[] result = new Boolean[]{true};
        new HibernateTxFragment(true, true){

            @Override
            protected void txFragment(Session session) throws Exception {
                List<ClusterNode> installingModulesNodes = ClusterNodesManager.this.getNodeByStatus(ClusterNode.ClusterNodeStatus.INSTALLING_MODULES);
                if (installingModulesNodes != null && !installingModulesNodes.isEmpty()) {
                    ClusterNode node;
                    if (installingModulesNodes.size() > 1) {
                        log.warn("More than one cluster node status is INSTALLING_MODULES. This situation can be produced due to a failured previous installation.");
                    }
                    result[0] = (node = installingModulesNodes.get(0)).getNodeAddress() != null && node.getNodeAddress().equals(ClusterNodesManager.this.getCurrentNodeIpAddress()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                } else {
                    result[0] = true;
                    ClusterNodesManager.this.setCurrentNodeStatus(ClusterNode.ClusterNodeStatus.INSTALLING_MODULES);
                }
            }
        }.execute();
        return result[0];
    }

    public void setCurrentNodeStatus(ClusterNode.ClusterNodeStatus newStatus) throws Exception {
        this.setNodeStatus(this.currentNodeId, newStatus);
    }

    public Long getCurrentNodeId() {
        return this.currentNodeId;
    }

    public String getCurrentNodeIpAddress() {
        return this.currentNodeIpAddress;
    }
}

