/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.filesystem;

import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.filesystem.FileSystemMapping;
import org.jboss.dashboard.filesystem.VfsWrapper;

@ApplicationScoped
public class FileSystemManager {
    @Inject
    private Instance<FileSystemMapping> mappings;
    @Inject
    @Config(value="default.gif")
    private String defaultFileImage;
    @Inject
    @Config(value="fileSystem/fileTypes/16x16")
    private String thumbnailFolder;
    @Inject
    @Config(value="fileSystem/fileTypes/32x32")
    private String largeIconFolder;
    @Inject
    @Config(value="avi=avi.gif,mpg=avi.gif,mpeg=avi.gif,divx=avi.gif,mp4=avi.gif,wmv=avi.gif,asf=avi.gif,cer=cer.gif,pfx=cer.gif,doc=doc.gif,exe=exe.gif,com=exe.gif,gif=gif.gif,htm=html.gif,html=html.gif,jpg=img.gif,lib=lib.gif,so=lib.gif,dll=lib.gif,o=lib.gif,mp3=mp3.gif,wma=mp3.gif,wav=mp3.gif,ogg=mp3.gif,pdf=pdf.gif,pps=pps.gif,ppt=ppt.gif,properties=properties.gif,swf=swf.gif,flash=swf.gif,tiff=tiff.gif,txt=txt.gif,xls=xls.gif,xml=xml.gif,zip=zip.gif,rar=zip.gif,arj=zip.gif,ace=zip.gif,tgz=zip.gif,bz2=zip.gif,gz=zip.gif,png=png.gif")
    private Properties fileNamesImagesMappings;
    private transient FileSystem fileSystem;

    @PostConstruct
    public void start() throws Exception {
        this.fileSystem = this.createInitialVirtualFilesystem();
        for (FileSystemMapping mapping : this.mappings) {
            mapping.addToVirtualFilesystem(this.fileSystem);
        }
    }

    public String getThumbnailFolder() {
        return this.thumbnailFolder;
    }

    public void setThumbnailFolder(String thumbnailFolder) {
        this.thumbnailFolder = thumbnailFolder;
    }

    public String getLargeIconFolder() {
        return this.largeIconFolder;
    }

    public void setLargeIconFolder(String largeIconFolder) {
        this.largeIconFolder = largeIconFolder;
    }

    public String getDefaultFileImage() {
        return this.defaultFileImage;
    }

    public void setDefaultFileImage(String defaultFileImage) {
        this.defaultFileImage = defaultFileImage;
    }

    public Properties getFileNamesImagesMappings() {
        return this.fileNamesImagesMappings;
    }

    public void setFileNamesImagesMappings(Properties fileNamesImagesMappings) {
        this.fileNamesImagesMappings = fileNamesImagesMappings;
    }

    protected FileSystem createInitialVirtualFilesystem() throws FileSystemException {
        return VfsWrapper.getManager().createVirtualFileSystem((String)null).getFileSystem();
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getURI(FileObject file) {
        for (FileSystemMapping mapping : this.mappings) {
            String uri = mapping.getURI(file);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    public String getFileNamePicture(String fileExtension) {
        return this.getFileNamesImagesMappings().getProperty(fileExtension.toLowerCase(), this.getDefaultFileImage());
    }

    public String getThumbnailPath(String fileExtension) {
        return this.getThumbnailFolder() + "/" + this.getFileNamePicture(fileExtension);
    }

    public String getLargeIconPath(String fileExtension) {
        return this.getLargeIconFolder() + "/" + this.getFileNamePicture(fileExtension);
    }
}

