/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.filesystem;

import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.filesystem.FileSystemMapping;
import org.jboss.dashboard.filesystem.VfsWrapper;

public class BinariesMapping
implements FileSystemMapping {
    @Inject
    @Config(value="file")
    private String schema;
    @Inject
    @Config(value="binaries")
    private String junctionPoint;
    @Inject
    @Config(value="../../../../binaries")
    private String junctionUrl;
    @Inject
    @Config(value="")
    private String serverUri;
    @Inject
    @Config(value="true")
    private boolean isWebappDirectoryRelative;

    public boolean isWebappDirectoryRelative() {
        return this.isWebappDirectoryRelative;
    }

    public void setWebappDirectoryRelative(boolean webappDirectoryRelative) {
        this.isWebappDirectoryRelative = webappDirectoryRelative;
    }

    public String getJunctionPoint() {
        return this.junctionPoint;
    }

    public void setJunctionPoint(String junctionPoint) {
        this.junctionPoint = junctionPoint;
    }

    public String getJunctionUrl() {
        return this.junctionUrl;
    }

    public void setJunctionUrl(String junctionUrl) {
        this.junctionUrl = junctionUrl;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public void setServerUri(String serverUri) {
        this.serverUri = serverUri;
    }

    @Override
    public void addToVirtualFilesystem(FileSystem fileSystem) throws FileSystemException {
        if (!this.isWebappDirectoryRelative()) {
            FileObject file = VfsWrapper.getManager().resolveFile(this.getSchema() + "://" + StringUtils.defaultString((String)this.getJunctionUrl()));
            file.createFolder();
            fileSystem.addJunction(this.getJunctionPoint(), file);
        } else {
            File parentFile = new File(Application.lookup().getBaseAppDirectory());
            String junctionUrl = this.getJunctionUrl();
            while (junctionUrl.startsWith("../")) {
                junctionUrl = junctionUrl.substring(3);
                parentFile = parentFile.getParentFile();
            }
            FileObject file = VfsWrapper.getManager().resolveFile(this.getSchema() + "://" + parentFile + (StringUtils.isEmpty((String)junctionUrl) ? "" : "/" + junctionUrl));
            file.createFolder();
            fileSystem.addJunction(this.getJunctionPoint(), file);
        }
    }

    @Override
    public String getURI(FileObject file) {
        String fileName;
        if (this.getServerUri() != null && (fileName = file.getName().getPath()).startsWith("/" + this.getJunctionPoint())) {
            fileName = fileName.substring(this.getJunctionPoint().length() + 1);
            String uri = this.getServerUri() + fileName;
            return uri;
        }
        return null;
    }
}

