/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.commons.message.Message;

public class MessageList
extends ArrayList {
    private Date created = new Date();

    public MessageList() {
    }

    public MessageList(Collection c) {
        super(c);
    }

    public Date getCreationDate() {
        return this.created;
    }

    public boolean addAll(Collection c, boolean discardDuplicates) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        if (!discardDuplicates) {
            return super.addAll(c);
        }
        int initialSize = this.size();
        for (Object o : c) {
            if (this.contains(o)) continue;
            this.add(o);
        }
        return initialSize != this.size();
    }

    public List getMessagesWithCode(String messageCode) {
        ArrayList<Message> results = new ArrayList<Message>();
        for (Message message : this) {
            if (!message.getMessageCode().equals(messageCode)) continue;
            results.add(message);
        }
        return results;
    }

    public List getMessagesForElement(Object element) {
        ArrayList<Message> results = new ArrayList<Message>();
        block0: for (Message message : this) {
            Object[] elements = message.getElements();
            if (elements == null) continue;
            for (int i = 0; i < elements.length; ++i) {
                if (!element.equals(elements[i])) continue;
                results.add(message);
                continue block0;
            }
        }
        return results;
    }

    public boolean hasErrors() {
        return this.containsMessagesOfType(10);
    }

    public boolean containsMessagesOfType(int type) {
        for (Message message : this) {
            if (message.getMessageType() != type) continue;
            return true;
        }
        return false;
    }

    public void removeMessagesOfType(int type) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Message message = (Message)it.next();
            if (message.getMessageType() != type) continue;
            it.remove();
        }
    }

    public void keepOnlyMessagesOfType(int type) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Message message = (Message)it.next();
            if (message.getMessageType() == type) continue;
            it.remove();
        }
    }

    public List getMessagesOfType(int type) {
        ArrayList<Message> l = new ArrayList<Message>();
        for (Message message : this) {
            if (message.getMessageType() != type) continue;
            l.add(message);
        }
        return l;
    }

    public String[] getMessagesOfTypeForElement(Object element, int type) {
        String[] messages = null;
        if (element != null) {
            MessageList l = new MessageList((Collection)this.getMessagesForElement(element));
            l.keepOnlyMessagesOfType(type);
            if (!l.isEmpty()) {
                Locale locale = LocaleManager.currentLocale();
                messages = new String[l.size()];
                for (int i = 0; i < l.size(); ++i) {
                    messages[i] = ((Message)l.get(i)).getMessage(locale);
                }
            }
        }
        return messages;
    }
}

