/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.jbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.web.tomcat.service.session.distributedcache.jbc.AbstractJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.jbc.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingAttributeGranularitySessionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeBasedJBossCacheService
extends AbstractJBossCacheService<OutgoingAttributeGranularitySessionData> {
    public AttributeBasedJBossCacheService(LocalDistributableSessionManager localManager) throws ClusteringNotSupportedException {
        super(localManager);
    }

    public AttributeBasedJBossCacheService(LocalDistributableSessionManager localManager, Cache<Object, Object> cache) {
        super(localManager, cache);
    }

    public Object getAttribute(String realId, String key) {
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        return this.unmarshall(realId, key, this.cacheWrapper_.get(fqn, key));
    }

    public void putAttribute(String realId, String key, Object value) {
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        this.cacheWrapper_.put(fqn, key, this.marshaller.marshal(value));
    }

    public void putAttribute(String realId, Map<String, Object> map) {
        HashMap<Object, Object> marshalled = new HashMap<Object, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            marshalled.put(entry.getKey(), this.marshaller.marshal(entry.getValue()));
        }
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        this.cacheWrapper_.put(fqn, marshalled);
    }

    public Object removeAttribute(String realId, String key) {
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Removing attribute from distributed store for session " + Util.maskId(realId) + ". Parent Fqn: " + fqn.getParent() + " key: " + key));
        }
        return this.unmarshall(realId, key, this.cacheWrapper_.remove(fqn, key));
    }

    public void removeAttributeLocal(String realId, String key) {
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Removing attribute from my own distributed store only for session " + Util.maskId(realId) + ". Parent Fqn: " + fqn.getParent() + " key: " + key));
        }
        this.cacheWrapper_.removeLocal(fqn, key);
    }

    public Set<String> getAttributeKeys(String realId) {
        Set keys = null;
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        try {
            Node node = this.getCache().getRoot().getChild(fqn);
            if (node != null) {
                keys = node.getKeys();
                keys.removeAll(INTERNAL_KEYS);
            }
        }
        catch (CacheException e) {
            this.log_.error((Object)("getAttributeKeys(): Exception getting keys for session " + Util.maskId(realId)), (Throwable)e);
        }
        return keys;
    }

    public Map<String, Object> getAttributes(String realId) {
        if (realId == null || realId.length() == 0) {
            Map empty = Collections.EMPTY_MAP;
            return empty;
        }
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        Node node = this.getCache().getRoot().getChild(fqn);
        Map rawData = node.getData();
        return this.getSessionAttributes(realId, rawData);
    }

    @Override
    protected Map<String, Object> getSessionAttributes(String realId, Map<Object, Object> distributedCacheData) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : distributedCacheData.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            String key = (String)entry.getKey();
            attrs.put(key, this.unmarshall(realId, key, entry.getValue()));
        }
        return attrs;
    }

    @Override
    protected void storeSessionAttributes(Map<Object, Object> dataMap, OutgoingAttributeGranularitySessionData sessionData) {
        Set removed;
        Fqn<String> fqn = null;
        Map map = sessionData.getModifiedSessionAttributes();
        if (map != null) {
            HashMap<Object, Object> marshalled = new HashMap<Object, Object>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                marshalled.put(entry.getKey(), this.marshaller.marshal(entry.getValue()));
            }
            fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, sessionData.getRealId());
            this.cacheWrapper_.put(fqn, marshalled);
        }
        if ((removed = sessionData.getRemovedSessionAttributes()) != null) {
            if (fqn == null) {
                fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, sessionData.getRealId());
            }
            for (String key : removed) {
                this.cacheWrapper_.remove(fqn, key);
            }
        }
    }

    private Object unmarshall(String realId, String key, Object toUnmarshall) {
        try {
            return this.marshaller.unmarshal(toUnmarshall);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception unmarshalling attribute " + key + " for session " + Util.maskId(realId), e);
        }
    }
}

