/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jndi.impl.jbc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.ha.framework.server.HAPartitionCacheHandlerImpl;
import org.jboss.ha.jndi.spi.DistributedTreeManager;
import org.jboss.logging.Logger;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheDistributedTreeManager
implements Naming,
DistributedTreeManager {
    static final long serialVersionUID = 6342802270002172451L;
    private static Logger log = Logger.getLogger(JBossCacheDistributedTreeManager.class);
    private static final NamingParser parser = new NamingParser();
    public static final String DEFAULT_ROOT = "__HA_JNDI__";
    private Cache<String, Binding> m_cache;
    private Fqn<String> m_root;
    private Naming haStub;
    private boolean treeRootSet;
    protected HAPartitionCacheHandlerImpl cacheHandler;
    protected boolean acquiredCache = false;

    public HAPartitionCacheHandlerImpl getCacheHandler() {
        return this.cacheHandler;
    }

    public void setCacheHandler(HAPartitionCacheHandlerImpl cacheHandler) {
        this.cacheHandler = cacheHandler;
    }

    public Cache<String, Binding> getClusteredCache() {
        return this.m_cache;
    }

    public void setClusteredCache(Cache<String, Binding> cache) {
        if (this.treeRootSet) {
            throw new IllegalStateException("Cannot change clusteredCache after call to init()");
        }
        this.m_cache = cache;
    }

    public void setRootFqn(String rootFqn) {
        if (this.treeRootSet) {
            throw new IllegalStateException("Cannot change rootFqn after call to init()");
        }
        this.m_root = rootFqn == null ? null : Fqn.fromString((String)rootFqn);
    }

    public String getRootFqn() {
        return this.m_root == null ? DEFAULT_ROOT : this.m_root.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.haStub == null) {
            throw new IllegalStateException("Must call setHAStub before starting");
        }
        if (this.m_cache == null) {
            if (this.cacheHandler == null) {
                throw new IllegalStateException("No clustered cache available");
            }
            try {
                Cache<Object, Object> c = null;
                HAPartitionCacheHandlerImpl hAPartitionCacheHandlerImpl = this.cacheHandler;
                synchronized (hAPartitionCacheHandlerImpl) {
                    c = this.cacheHandler.getCache();
                    if (c == null) {
                        this.cacheHandler.acquireCache();
                        c = this.cacheHandler.getCache();
                        this.acquiredCache = true;
                    }
                }
                this.cacheHandler.startCache();
                this.setClusteredCache(c);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        log.debug((Object)"initializing HAJNDITreeCache root");
        this.putTreeRoot();
    }

    public void shutdown() {
        if (this.acquiredCache) {
            try {
                this.cacheHandler.releaseCache();
            }
            catch (Exception e) {
                log.error((Object)"Caught exception releasing cache", (Throwable)e);
            }
        }
    }

    public Naming getHAStub() {
        return this.haStub;
    }

    public void setHAStub(Naming stub) {
        this.haStub = stub;
    }

    public void bind(Name name, Object obj, String className) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("bind, name=" + name));
        }
        this.internalBind(name, obj, className, false);
    }

    public void rebind(Name name, Object obj, String className) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("rebind, name=" + name));
        }
        this.internalBind(name, obj, className, true);
    }

    public void unbind(Name name) throws NamingException {
        Fqn ctx;
        if (log.isTraceEnabled()) {
            log.trace((Object)("unbind, name=" + name));
        }
        if (name.isEmpty()) {
            throw new InvalidNameException();
        }
        try {
            Fqn temp = Fqn.fromRelativeFqn(this.m_root, (Fqn)Fqn.fromString((String)name.toString()));
            if (this.m_cache.getRoot().hasChild(temp)) {
                this.m_cache.removeNode(temp);
                return;
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(String.valueOf(((Object)((Object)ce)).getClass().getName()) + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = Fqn.fromRelativeFqn(this.m_root, (Fqn)fqn);
        } else {
            ctx = this.m_root;
        }
        try {
            Object removed = this.m_cache.remove(ctx, (Object)key);
            if (removed == null) {
                if (!this.m_cache.getRoot().hasChild(ctx)) {
                    throw new NotContextException(String.valueOf(name.getPrefix(size - 1).toString()) + " not a context");
                }
                throw new NameNotFoundException(String.valueOf(key) + " not bound");
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(String.valueOf(((Object)((Object)ce)).getClass().getName()) + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Object lookup(Name name) throws NamingException {
        Fqn ctx;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("lookup, name=" + name));
        }
        if (name.isEmpty()) {
            return new NamingContext(null, parser.parse(""), this.getHAStub());
        }
        try {
            Node n = this.m_cache.getRoot().getChild(Fqn.fromRelativeFqn(this.m_root, (Fqn)Fqn.fromString((String)name.toString())));
            if (n != null) {
                Name fullName = (Name)name.clone();
                return new NamingContext(null, fullName, this.getHAStub());
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(String.valueOf(((Object)((Object)ce)).getClass().getName()) + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = Fqn.fromRelativeFqn(this.m_root, (Fqn)fqn);
        } else {
            ctx = this.m_root;
        }
        try {
            Binding b = (Binding)this.m_cache.get(ctx, (Object)key);
            return b != null ? b.getObject() : null;
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(String.valueOf(((Object)((Object)ce)).getClass().getName()) + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Collection<NameClassPair> list(Name name) throws NamingException {
        Fqn ctx;
        if (log.isTraceEnabled()) {
            log.trace((Object)("list, name=" + name));
        }
        String ctxName = "";
        int size = name.size();
        if (size >= 1) {
            ctxName = name.toString();
            Fqn fqn = Fqn.fromString((String)ctxName);
            ctx = Fqn.fromRelativeFqn(this.m_root, (Fqn)fqn);
        } else {
            ctx = this.m_root;
        }
        boolean exists = this.m_cache.getRoot().hasChild(ctx);
        if (!exists) {
            try {
                return Collections.list(new InitialContext().list(name));
            }
            catch (NamingException e) {
                throw new NotContextException(String.valueOf(ctxName) + " not a context");
            }
        }
        try {
            LinkedList<NameClassPair> list = new LinkedList<NameClassPair>();
            Node base = this.m_cache.getRoot().getChild(ctx);
            if (base != null) {
                for (Binding b : base.getData().values()) {
                    list.add(new NameClassPair(b.getName(), b.getClassName(), true));
                }
                Set children = base.getChildrenNames();
                if (children != null && !children.isEmpty()) {
                    for (Object child : children) {
                        String node = (String)child;
                        Name fullName = (Name)name.clone();
                        fullName.add(node);
                        list.add(new NameClassPair(node, NamingContext.class.getName(), true));
                    }
                }
            }
            return list;
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(String.valueOf(((Object)((Object)ce)).getClass().getName()) + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Collection<Binding> listBindings(Name name) throws NamingException {
        Fqn ctx;
        if (log.isTraceEnabled()) {
            log.trace((Object)("listBindings, name=" + name));
        }
        String ctxName = "";
        int size = name.size();
        if (size >= 1) {
            ctxName = name.toString();
            Fqn fqn = Fqn.fromString((String)ctxName);
            ctx = Fqn.fromRelativeFqn(this.m_root, (Fqn)fqn);
        } else {
            ctx = this.m_root;
        }
        boolean exists = this.m_cache.getRoot().hasChild(ctx);
        if (!exists) {
            try {
                return Collections.list(new InitialContext().listBindings(name));
            }
            catch (NamingException e) {
                throw new NotContextException(String.valueOf(ctxName) + " not a context");
            }
        }
        try {
            LinkedList<Binding> list = new LinkedList<Binding>();
            Node node = this.m_cache.getRoot().getChild(ctx);
            if (node != null) {
                Set children;
                Map data = node.getData();
                if (data != null && !data.isEmpty()) {
                    list.addAll(data.values());
                }
                if ((children = node.getChildrenNames()) != null && !children.isEmpty()) {
                    for (Object obj : children) {
                        String child = (String)obj;
                        Name fullName = (Name)name.clone();
                        fullName.add(child);
                        NamingContext subCtx = new NamingContext(null, fullName, this.getHAStub());
                        list.add(new Binding(child, NamingContext.class.getName(), subCtx, true));
                    }
                }
            }
            return list;
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(String.valueOf(((Object)((Object)ce)).getClass().getName()) + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Context createSubcontext(Name name) throws NamingException {
        Fqn pctx;
        int size;
        if (log.isTraceEnabled()) {
            log.trace((Object)("createSubcontext, name=" + name));
        }
        if ((size = name.size()) == 0) {
            throw new InvalidNameException("Cannot pass an empty name to createSubcontext");
        }
        String str = name.toString();
        Fqn fqn = Fqn.fromString((String)str);
        Fqn ctx = Fqn.fromRelativeFqn(this.m_root, (Fqn)fqn);
        if (this.m_cache.getRoot().hasChild(ctx)) {
            throw new NameAlreadyBoundException();
        }
        String newctx = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn2 = Fqn.fromString((String)prefix);
            pctx = Fqn.fromRelativeFqn(this.m_root, (Fqn)fqn2);
        } else {
            pctx = this.m_root;
        }
        boolean exists = this.m_cache.getRoot().hasChild(pctx);
        if (!exists) {
            throw new NotContextException(name.getPrefix(size - 1).toString());
        }
        Fqn newf = Fqn.fromRelativeFqn((Fqn)pctx, (Fqn)Fqn.fromString((String)newctx));
        try {
            this.m_cache.put(newf, new HashMap());
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(String.valueOf(((Object)((Object)ce)).getClass().getName()) + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        Name fullName = parser.parse("");
        fullName.addAll(name);
        return new NamingContext(null, fullName, this.getHAStub());
    }

    private void putTreeRoot() throws CacheException {
        if (this.m_root == null) {
            this.setRootFqn(DEFAULT_ROOT);
        }
        if (!this.m_cache.getRoot().hasChild(this.m_root)) {
            this.m_cache.put(this.m_root, null);
            this.treeRootSet = true;
        }
    }

    private void internalBind(Name name, Object obj, String className, boolean rebind) throws NamingException {
        Node node;
        Fqn ctx;
        if (name.isEmpty()) {
            throw new InvalidNameException();
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = Fqn.fromRelativeFqn(this.m_root, (Fqn)fqn);
        } else {
            ctx = this.m_root;
        }
        boolean exists = this.m_cache.getRoot().hasChild(ctx);
        if (!exists) {
            throw new NotContextException(String.valueOf(name.getPrefix(size - 1).toString()) + " not a context");
        }
        if (!rebind && (node = this.m_cache.getRoot().getChild(ctx)) != null && node.get((Object)key) != null) {
            throw new NameAlreadyBoundException(key);
        }
        this.m_cache.put(ctx, (Object)key, (Object)new Binding(key, className, obj, true));
    }
}

