/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.cachemanager;

import java.security.AccessController;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.PojoCacheThreadContext;
import org.jboss.cache.pojo.Reference;
import org.jboss.ha.cachemanager.CacheManagerManagedCache;
import org.jboss.logging.Logger;
import org.jboss.util.loading.ContextClassLoaderSwitcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PojoCacheManagerManagedPojoCache
implements PojoCache {
    private static final Logger log = Logger.getLogger(PojoCacheManagerManagedPojoCache.class);
    private final PojoCache delegate;
    private final ContextClassLoaderSwitcher switcher;

    PojoCacheManagerManagedPojoCache(PojoCache delegate) {
        ContextClassLoaderSwitcher unchecked;
        assert (delegate != null) : "delegate is null";
        this.delegate = delegate;
        this.switcher = unchecked = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    }

    public void create() throws CacheException {
        ContextClassLoaderSwitcher.SwitchContext switchContext = this.switcher.getSwitchContext();
        try {
            switchContext.setClassLoader(this.delegate.getClass().getClassLoader());
            this.delegate.create();
        }
        finally {
            switchContext.reset();
        }
    }

    public void start() throws CacheException {
        ContextClassLoaderSwitcher.SwitchContext switchContext = this.switcher.getSwitchContext();
        try {
            switchContext.setClassLoader(this.delegate.getClass().getClassLoader());
            this.delegate.start();
        }
        finally {
            switchContext.reset();
        }
    }

    public void stop() throws PojoCacheException {
        log.warn((Object)"stop() should not be directly called on caches obtained from a PojoCacheManager -- use CacheManager.releaseCache()", (Throwable)new UnsupportedOperationException("stop() is not supported"));
        this.delegate.stop();
    }

    public void destroy() throws PojoCacheException {
        log.warn((Object)"destroy() should not be directly called on caches obtained from a PojoCacheManager -- use CacheManager.releaseCache()", (Throwable)new UnsupportedOperationException("destroy() is not supported"));
        this.delegate.destroy();
    }

    public void addListener(Object arg0) {
        this.delegate.addListener(arg0);
    }

    public void addListener(Object arg0, Pattern arg1) {
        this.delegate.addListener(arg0, arg1);
    }

    public Object attach(String arg0, Object arg1) throws PojoCacheException {
        return this.delegate.attach(arg0, arg1);
    }

    public Object attach(Fqn<?> arg0, Object arg1) throws PojoCacheException {
        return this.delegate.attach(arg0, arg1);
    }

    public Object detach(String arg0) throws PojoCacheException {
        return this.delegate.detach(arg0);
    }

    public Object detach(Fqn<?> arg0) throws PojoCacheException {
        return this.delegate.detach(arg0);
    }

    public boolean exists(Fqn<?> arg0) {
        return this.delegate.exists(arg0);
    }

    public Object find(String arg0) throws PojoCacheException {
        return this.delegate.find(arg0);
    }

    public Object find(Fqn<?> arg0) throws PojoCacheException {
        return this.delegate.find(arg0);
    }

    public Map<Fqn<?>, Object> findAll(String arg0) throws PojoCacheException {
        return this.delegate.findAll(arg0);
    }

    public Map<Fqn<?>, Object> findAll(Fqn<?> arg0) throws PojoCacheException {
        return this.delegate.findAll(arg0);
    }

    public Cache<Object, Object> getCache() {
        Cache c = this.delegate.getCache();
        return c == null ? null : new CacheManagerManagedCache(c);
    }

    public Fqn<?> getInternalFqn(Object arg0) {
        return this.delegate.getInternalFqn(arg0);
    }

    public Collection<Reference> getReferences(Object arg0) {
        return this.delegate.getReferences(arg0);
    }

    public Collection<Object> getListeners() {
        return this.delegate.getListeners();
    }

    public PojoCacheThreadContext getThreadContext() {
        return this.delegate.getThreadContext();
    }

    public void removeListener(Object arg0) {
        this.delegate.removeListener(arg0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PojoCacheManagerManagedPojoCache) {
            PojoCacheManagerManagedPojoCache other = (PojoCacheManagerManagedPojoCache)obj;
            return this.delegate.equals(other.delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

