/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocatorConfig;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.FileCacheLoaderConfig;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;
import org.jboss.cache.transaction.BatchModeTransactionManagerLookup;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.impl.DistributedCacheManagerFactoryImpl;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.TestDistributedCacheManagerFactory;

public class TestDistributedCacheManagerFactoryImpl
implements TestDistributedCacheManagerFactory {
    private static final Logger log = Logger.getLogger(TestDistributedCacheManagerFactoryImpl.class);
    private DistributedCacheManagerFactoryImpl delegate = new DistributedCacheManagerFactoryImpl();

    public void configure(boolean local, String passivationDir, boolean totalReplication, boolean marshalling, boolean purgeCacheLoader) {
        PojoCache pc = TestDistributedCacheManagerFactoryImpl.createCache(local, passivationDir, totalReplication, marshalling, purgeCacheLoader);
        this.delegate.setPojoCache(pc);
    }

    public <T extends OutgoingDistributableSessionData> DistributedCacheManager<T> getDistributedCacheManager(LocalDistributableSessionManager localManager) throws ClusteringNotSupportedException {
        return this.delegate.getDistributedCacheManager(localManager);
    }

    public void cleanup(boolean doRemove) {
        PojoCache cache = this.delegate.getPojoCache();
        if (cache == null) {
            return;
        }
        if (doRemove && CacheStatus.STARTED.equals((Object)cache.getCache().getCacheStatus())) {
            try {
                log.info((Object)("Removing /JSESSION from " + cache.getCache().getLocalAddress()));
                cache.getCache().removeNode(Fqn.fromString((String)"/JSESSION"));
            }
            catch (Exception e) {
                log.error((Object)("Cache " + cache + ": " + e.getMessage()), (Throwable)e);
            }
        }
        try {
            cache.stop();
            cache.destroy();
        }
        catch (Exception e) {
            log.error((Object)("Cache " + cache + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private static PojoCache createCache(boolean local, String passivationDir, boolean totalReplication, boolean marshalling, boolean purgeCacheLoader) {
        Configuration cfg = TestDistributedCacheManagerFactoryImpl.getConfiguration(local, passivationDir, totalReplication, marshalling, purgeCacheLoader);
        return PojoCacheFactory.createCache((Configuration)cfg, (boolean)true);
    }

    private static Configuration getConfiguration(boolean local, String passivationDir, boolean totalReplication, boolean marshalling, boolean purgeCacheLoader) {
        Configuration config = new Configuration();
        config.setClusterName("Tomcat-TestCluster");
        config.setTransactionManagerLookupClass(BatchModeTransactionManagerLookup.class.getName());
        config.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        config.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        config.setSyncReplTimeout(20000L);
        config.setLockAcquisitionTimeout(15000L);
        config.setCacheMode(local ? Configuration.CacheMode.LOCAL : Configuration.CacheMode.REPL_SYNC);
        config.setUseRegionBasedMarshalling(marshalling);
        config.setInactiveOnStartup(marshalling);
        config.setSerializationExecutorPoolSize(0);
        config.setListenerAsyncPoolSize(0);
        config.setSyncCommitPhase(true);
        config.setSyncRollbackPhase(true);
        if (passivationDir != null) {
            CacheLoaderConfig clc = new CacheLoaderConfig();
            clc.setPassivation(true);
            clc.setShared(false);
            FileCacheLoaderConfig fclc = new FileCacheLoaderConfig();
            fclc.setLocation(passivationDir);
            fclc.setFetchPersistentState(true);
            fclc.setPurgeOnStartup(purgeCacheLoader);
            fclc.setAsync(false);
            fclc.setIgnoreModifications(false);
            ArrayList<FileCacheLoaderConfig> iclcs = new ArrayList<FileCacheLoaderConfig>();
            iclcs.add(fclc);
            clc.setIndividualCacheLoaderConfigs(iclcs);
            config.setCacheLoaderConfig(clc);
        }
        if (!local && !totalReplication) {
            BuddyReplicationConfig brc = new BuddyReplicationConfig();
            brc.setEnabled(true);
            NextMemberBuddyLocatorConfig blc = new NextMemberBuddyLocatorConfig();
            blc.setNumBuddies(1);
            blc.setIgnoreColocatedBuddies(true);
            brc.setBuddyLocatorConfig((BuddyReplicationConfig.BuddyLocatorConfig)blc);
            brc.setBuddyPoolName("default");
            brc.setBuddyCommunicationTimeout(20000);
            brc.setAutoDataGravitation(false);
            brc.setDataGravitationRemoveOnFind(true);
            brc.setDataGravitationSearchBackupTrees(true);
            config.setBuddyReplicationConfig(brc);
        }
        return config;
    }

    public Object getLocalAddress() {
        PojoCache pc = this.delegate.getPojoCache();
        return pc == null ? null : pc.getCache().getLocalAddress();
    }

    public List<Object> getMembers() {
        PojoCache pc = this.delegate.getPojoCache();
        return pc == null ? null : new ArrayList(pc.getCache().getMembers());
    }
}

