/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.AbstractJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.CacheListenerBase;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.JBossCacheWrapper;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

@org.jboss.cache.notifications.annotation.CacheListener
public class CacheListener
extends CacheListenerBase {
    private static final int POJO_ATTRIBUTE_FQN_INDEX = 3;
    private static final int POJO_KEY_FQN_INDEX = 4;
    private static final int POJO_INTERNAL_FQN_INDEX = 3;
    private static final int POJO_INTERNAL_FQN_SIZE = 4;
    private static Logger log_ = Logger.getLogger(CacheListener.class);
    private boolean attributeBased_;
    private boolean fieldBased_;

    CacheListener(JBossCacheWrapper wrapper, LocalDistributableSessionManager manager, String contextHostPath, ReplicationGranularity granularity) {
        super(manager, contextHostPath);
        if (granularity == ReplicationGranularity.FIELD) {
            this.fieldBased_ = true;
        } else if (granularity == ReplicationGranularity.ATTRIBUTE) {
            this.attributeBased_ = true;
        }
    }

    @NodeRemoved
    public void nodeRemoved(NodeRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        boolean local = event.isOriginLocal();
        if (!this.fieldBased_ && local) {
            return;
        }
        Fqn fqn = event.getFqn();
        boolean isBuddy = CacheListener.isBuddyFqn(fqn);
        if (!local && CacheListener.isFqnSessionRootSized(fqn, isBuddy) && this.isFqnForOurWebapp(fqn, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
            this.manager_.notifyRemoteInvalidation(sessId);
        } else if (local && !isBuddy && CacheListener.isPossibleInternalPojoFqn(fqn) && this.isFqnForOurWebapp(fqn, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
            this.manager_.notifyLocalAttributeModification(sessId);
        }
    }

    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        if (event.isPre()) {
            return;
        }
        boolean local = event.isOriginLocal();
        if (!this.fieldBased_ && local) {
            return;
        }
        Fqn fqn = event.getFqn();
        boolean isBuddy = CacheListener.isBuddyFqn(fqn);
        if (!local && CacheListener.isFqnSessionRootSized(fqn, isBuddy) && this.isFqnForOurWebapp(fqn, isBuddy)) {
            Map data = event.getData();
            AtomicInteger version = (AtomicInteger)data.get(AbstractJBossCacheService.VERSION_KEY);
            if (version != null) {
                String realId = CacheListener.getIdFromFqn(fqn, isBuddy);
                String owner = isBuddy ? CacheListener.getBuddyOwner(fqn) : null;
                AtomicLong timestamp = (AtomicLong)data.get(AbstractJBossCacheService.TIMESTAMP_KEY);
                if (timestamp == null) {
                    log_.warn((Object)("No timestamp attribute found in " + fqn));
                } else {
                    boolean updated = this.manager_.sessionChangedInDistributedCache(realId, owner, version.get(), timestamp.get(), (DistributableSessionMetadata)data.get(AbstractJBossCacheService.METADATA_KEY));
                    if (!updated && !isBuddy) {
                        log_.warn((Object)("Possible concurrency problem: Replicated version id " + version + " is less than or equal to in-memory version for session " + realId));
                    }
                }
            } else if (!this.attributeBased_) {
                log_.warn((Object)("No version attribute found in " + fqn));
            }
        } else if (local && !isBuddy && CacheListener.isPossibleInternalPojoFqn(fqn) && this.isFqnForOurWebapp(fqn, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
            this.manager_.notifyLocalAttributeModification(sessId);
        }
    }

    public static String getPojoKeyFromFqn(Fqn fqn, boolean isBuddy) {
        return (String)fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 4 : 4);
    }

    public static boolean isPossibleInternalPojoFqn(Fqn fqn) {
        return fqn.size() > 4 && !"ATTRIBUTE".equals(fqn.get(3));
    }
}

