/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.AbstractJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeBasedJBossCacheService
extends AbstractJBossCacheService {
    public AttributeBasedJBossCacheService(LocalDistributableSessionManager localManager) throws ClusteringNotSupportedException {
        super(localManager);
    }

    public AttributeBasedJBossCacheService(LocalDistributableSessionManager localManager, Cache cache) {
        super(localManager, cache);
    }

    public boolean getSupportsAttributeOperations() {
        return true;
    }

    public Object getAttribute(String realId, String key) {
        Fqn fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        return this.getUnMarshalledValue(this.cacheWrapper_.get(fqn, key));
    }

    public void putAttribute(String realId, String key, Object value) {
        Fqn fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        this.cacheWrapper_.put(fqn, key, this.getMarshalledValue(value));
    }

    public void putAttribute(String realId, Map<String, Object> map) {
        HashMap<String, Object> marshalled = new HashMap<String, Object>(map.size());
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            marshalled.put(entry.getKey(), this.getMarshalledValue(entry.getValue()));
        }
        Fqn fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        this.cacheWrapper_.put(fqn, marshalled);
    }

    public Object removeAttribute(String realId, String key) {
        Fqn fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Remove attribute from distributed store. Fqn: " + fqn + " key: " + key));
        }
        return this.getUnMarshalledValue(this.cacheWrapper_.remove(fqn, key));
    }

    public void removeAttributeLocal(String realId, String key) {
        Fqn fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Remove attribute from distributed store. Fqn: " + fqn + " key: " + key));
        }
        this.cacheWrapper_.removeLocal(fqn, key);
    }

    public Set getAttributeKeys(String realId) {
        Set keys = null;
        Fqn fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        try {
            Node node = this.getCache().getRoot().getChild(fqn);
            if (node != null) {
                keys = node.getKeys();
                keys.removeAll(INTERNAL_KEYS);
            }
        }
        catch (CacheException e) {
            this.log_.error((Object)("getAttributeKeys(): Exception getting keys for session " + realId), (Throwable)e);
        }
        return keys;
    }

    public Map<String, Object> getAttributes(String realId) {
        if (realId == null || realId.length() == 0) {
            return Collections.EMPTY_MAP;
        }
        Fqn fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        Node node = this.getCache().getRoot().getChild(fqn);
        Map rawData = node.getData();
        return this.getSessionAttributes(realId, rawData);
    }

    @Override
    protected Map<String, Object> getSessionAttributes(String realId, Map<Object, Object> distributedCacheData) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : distributedCacheData.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            attrs.put((String)entry.getKey(), this.getUnMarshalledValue(entry.getValue()));
        }
        return attrs;
    }

    @Override
    protected boolean isFieldBased() {
        return false;
    }

    @Override
    protected boolean getStoreAttributesInSingleKey() {
        return false;
    }
}

