/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.sso.ispn;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.config.Configuration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.ha.ispn.CacheContainerRegistry;
import org.jboss.ha.ispn.DefaultCacheContainerRegistry;
import org.jboss.ha.ispn.atomic.AtomicMapFactory;
import org.jboss.ha.ispn.atomic.DefaultAtomicMapFactory;
import org.jboss.logging.Logger;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.web.tomcat.service.sso.ispn.AbstractSSOKey;
import org.jboss.web.tomcat.service.sso.ispn.CredentialKey;
import org.jboss.web.tomcat.service.sso.ispn.SSOKey;
import org.jboss.web.tomcat.service.sso.ispn.SessionKey;
import org.jboss.web.tomcat.service.sso.spi.FullyQualifiedSessionId;
import org.jboss.web.tomcat.service.sso.spi.SSOCredentials;
import org.jboss.web.tomcat.service.sso.spi.SSOLocalManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SSOClusterManager
implements org.jboss.web.tomcat.service.sso.spi.SSOClusterManager {
    public static final String DEFAULT_THREAD_POOL_NAME = "jboss.system:service=ThreadPool";
    private volatile ThreadLocal<String> beingLocallyAdded = new ThreadLocal();
    private volatile ThreadLocal<String> beingLocallyRemoved = new ThreadLocal();
    private volatile ThreadLocal<String> beingRemotelyRemoved = new ThreadLocal();
    private volatile Cache<SSOKey, ?> cache = null;
    private final AtomicBoolean startedCache = new AtomicBoolean(false);
    private volatile TransactionManager tm = null;
    private volatile String threadPoolName = "jboss.system:service=ThreadPool";
    private volatile ThreadPool threadPool;
    private static final Logger log = Logger.getLogger(SSOClusterManager.class);
    private volatile MBeanServer server = null;
    private volatile SSOLocalManager ssoValve = null;
    private volatile boolean started = false;
    private volatile boolean missingCacheErrorLogged = false;
    private volatile Object localAddress = null;
    private final Set<Object> currentView = new HashSet<Object>();
    private final Object cleanupMutex = new Object();
    private final AtomicMapFactory atomicMapFactory;

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public boolean isUsingThreadPool() {
        return this.threadPool != null;
    }

    public SSOClusterManager() {
        this((AtomicMapFactory)new DefaultAtomicMapFactory());
    }

    public SSOClusterManager(AtomicMapFactory atomicMapFactory) {
        this.atomicMapFactory = atomicMapFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(String ssoId, FullyQualifiedSessionId sessionId) {
        if (ssoId == null || sessionId == null) {
            return;
        }
        if (!this.isCacheAvailable()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("addSession(): adding Session " + sessionId.getSessionId() + " to cached session set for SSO " + ssoId));
        }
        boolean doTx = false;
        try {
            if (this.tm == null) {
                this.configureFromCache();
            }
            if (this.tm.getTransaction() == null) {
                doTx = true;
            }
            if (doTx) {
                this.tm.begin();
            }
            this.putSessionInCache(ssoId, sessionId);
        }
        catch (Exception e) {
            try {
                if (doTx) {
                    this.tm.setRollbackOnly();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            log.error((Object)("caught exception adding session " + sessionId.getSessionId() + " to SSO id " + ssoId), (Throwable)e);
        }
        finally {
            if (doTx) {
                this.endTransaction();
            }
        }
    }

    public SSOLocalManager getSSOLocalManager() {
        return this.ssoValve;
    }

    public void setSSOLocalManager(SSOLocalManager localManager) {
        this.ssoValve = localManager;
        if (this.ssoValve != null) {
            String poolName;
            if (this.server == null) {
                this.server = this.ssoValve.getMBeanServer();
            }
            if ((poolName = this.ssoValve.getThreadPoolName()) != null) {
                this.threadPoolName = poolName;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(String ssoId) {
        if (!this.isCacheAvailable()) {
            return;
        }
        if (ssoId.equals(this.beingLocallyRemoved.get())) {
            return;
        }
        this.beingLocallyRemoved.set(ssoId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registering logout of SSO " + ssoId + " in clustered cache"));
        }
        try {
            this.removeSSOFromCache(ssoId);
        }
        catch (Exception e) {
            log.error((Object)("Exception attempting to logout " + ssoId), (Throwable)e);
        }
        finally {
            this.beingLocallyRemoved.set(null);
        }
    }

    public SSOCredentials lookup(String ssoId) {
        if (!this.isCacheAvailable()) {
            return null;
        }
        try {
            return this.getCredentialsFromCache(ssoId);
        }
        catch (Exception e) {
            log.error((Object)("caught exception looking up SSOCredentials for SSO id " + ssoId), (Throwable)e);
            return null;
        }
    }

    public void register(String ssoId, String authType, String username, String password) {
        if (!this.isCacheAvailable()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registering SSO " + ssoId + " in clustered cache"));
        }
        this.storeCredentials(ssoId, authType, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String ssoId, FullyQualifiedSessionId sessionId) {
        if (ssoId == null || sessionId == null) {
            return;
        }
        if (!this.isCacheAvailable()) {
            return;
        }
        if (ssoId.equals(this.beingRemotelyRemoved.get())) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("removeSession(): removing Session " + sessionId.getSessionId() + " from cached session set for SSO " + ssoId));
        }
        boolean doTx = false;
        boolean removing = false;
        try {
            if (this.tm == null) {
                this.configureFromCache();
            }
            if (this.tm.getTransaction() == null) {
                doTx = true;
            }
            if (doTx) {
                this.tm.begin();
            }
            this.removeSessionFromCache(ssoId, sessionId);
        }
        catch (Exception e) {
            try {
                if (doTx) {
                    this.tm.setRollbackOnly();
                }
            }
            catch (Exception x) {
                // empty catch block
            }
            log.error((Object)("caught exception removing session " + sessionId.getSessionId() + " from SSO id " + ssoId), (Throwable)e);
        }
        finally {
            try {
                if (removing) {
                    this.beingLocallyRemoved.set(null);
                }
            }
            finally {
                if (doTx) {
                    this.endTransaction();
                }
            }
        }
    }

    public void updateCredentials(String ssoId, String authType, String username, String password) {
        if (!this.isCacheAvailable()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating credentials for SSO " + ssoId + " in clustered cache"));
        }
        this.storeCredentials(ssoId, authType, username, password);
    }

    @CacheEntryRemoved
    public void cacheEntryRemoved(CacheEntryRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        SSOKey key = (SSOKey)event.getKey();
        String ssoId = key.getId();
        if (ssoId == null || !(key instanceof SessionKey)) {
            return;
        }
        if (!ssoId.equals(this.beingLocallyRemoved.get())) {
            this.deregisterSSO(ssoId);
        }
        this.notifySSOEmpty(ssoId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ViewChanged
    public void viewChange(ViewChangedEvent event) {
        log.debug((Object)("Received ViewChangedEvent " + event));
        boolean masterNode = false;
        HashSet oldMembers = new HashSet(event.getOldMembers());
        Set<Object> set = this.currentView;
        synchronized (set) {
            this.currentView.clear();
            this.currentView.addAll(event.getNewMembers());
            if (this.localAddress == null || !this.currentView.contains(this.localAddress)) {
                return;
            }
            if (this.currentView.iterator().next().equals(this.localAddress)) {
                masterNode = true;
            }
            oldMembers.removeAll(this.currentView);
        }
        if (oldMembers.size() > 0 && masterNode) {
            log.debug((Object)("Members have been removed; will launch cleanup task. Dead members: " + oldMembers));
            this.launchSSOCleaner(false);
        }
    }

    private void launchSSOCleaner(boolean notifyIfEmpty) {
        SSOCleanerTask cleaner = new SSOCleanerTask(notifyIfEmpty);
        if (this.threadPool != null) {
            this.threadPool.run((Runnable)cleaner);
        } else {
            Thread t = new Thread((Runnable)cleaner, "ClusteredSSOCleaner");
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterSSO(String ssoId) {
        this.beingRemotelyRemoved.set(ssoId);
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("received a node removed message for SSO " + ssoId));
            }
            this.ssoValve.deregister(ssoId);
        }
        finally {
            this.beingRemotelyRemoved.set(null);
        }
    }

    private void notifySSOEmpty(String ssoId) {
        try {
            if (this.getSSOSessions(ssoId).size() == 0) {
                this.ssoValve.notifySSOEmpty(ssoId);
            }
        }
        catch (Exception e) {
            log.error((Object)("Caught exception checking if " + ssoId + " is empty"), (Throwable)e);
        }
    }

    @CacheEntryModified
    public void cacheEntryModified(CacheEntryModifiedEvent event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        SSOKey key = (SSOKey)event.getKey();
        String ssoId = key.getId();
        if (key instanceof CredentialKey) {
            this.handleCredentialModifiedEvent(ssoId, (SSOCredentials)event.getValue());
        } else if (key instanceof SessionKey) {
            this.handleSessionModifiedEvent(ssoId);
        }
    }

    private void handleCredentialModifiedEvent(String ssoId, SSOCredentials credentials) {
        if (ssoId.equals(this.beingLocallyAdded.get())) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("received a credentials modified message for SSO " + ssoId));
        }
        try {
            if (credentials != null) {
                this.ssoValve.remoteUpdate(ssoId, credentials);
            }
        }
        catch (Exception e) {
            log.error((Object)("failed to update credentials for SSO " + ssoId), (Throwable)e);
        }
    }

    private void handleSessionModifiedEvent(String ssoId) {
        this.ssoValve.notifySSONotEmpty(ssoId);
    }

    public void start() throws Exception {
        String[] parts;
        if (this.started) {
            throw new IllegalStateException("SSOClusterManagerImpl already Started");
        }
        String containerName = null;
        String cacheName = this.ssoValve.getCacheConfig();
        if (cacheName != null && !cacheName.trim().isEmpty() && (parts = cacheName.split(":")).length == 2) {
            containerName = parts[0];
            cacheName = parts[1];
        }
        CacheContainerRegistry registry = DefaultCacheContainerRegistry.getInstance();
        EmbeddedCacheManager container = registry.getCacheContainer(containerName);
        this.cache = container.getCache(cacheName);
        if (this.cache.getStatus() != ComponentStatus.RUNNING) {
            this.cache.start();
            this.startedCache.set(true);
        }
        this.initThreadPool();
        this.cache.addListener((Object)this);
        this.tm = this.cache.getAdvancedCache().getTransactionManager();
        this.started = true;
    }

    public void stop() throws Exception {
        if (!this.started) {
            throw new IllegalStateException("SSOClusterManagerImpl not Started");
        }
        this.cache.removeListener((Object)this);
        if (this.startedCache.compareAndSet(true, false)) {
            this.cache.stop();
        }
        this.started = false;
    }

    public int getSessionCount(String ssoId) throws Exception {
        return this.getSSOSessions(ssoId).size();
    }

    private Set<String> getSSOIds() throws Exception {
        HashSet<String> result = new HashSet<String>();
        for (SSOKey key : this.cache.keySet()) {
            result.add(key.getId());
        }
        return result;
    }

    private Set<FullyQualifiedSessionId> getSSOSessions(String ssoId) throws Exception {
        SessionKey key = new SessionKey(ssoId);
        AtomicMap map = this.atomicMapFactory.getAtomicMap(key.cast(this.cache), (Object)key, false);
        return map != null ? map.keySet() : Collections.emptySet();
    }

    private void configureFromCache() throws Exception {
        if (this.tm == null) {
            this.tm = this.cache.getAdvancedCache().getTransactionManager();
        }
        if (this.tm == null) {
            throw new IllegalStateException("Cache does not have a transaction manager; please configure a valid TransactionManagerLookupClass");
        }
        Address address = this.cache.getAdvancedCache().getRpcManager().getAddress();
        if (address != null) {
            this.localAddress = address;
        } else if (Configuration.CacheMode.LOCAL == this.cache.getConfiguration().getCacheMode()) {
            this.localAddress = "LOCAL";
        } else {
            throw new IllegalStateException("Cannot get local address from cache");
        }
        log.debug((Object)("Local address is " + this.localAddress));
    }

    private void endTransaction() {
        try {
            if (this.tm.getTransaction().getStatus() != 1) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException("SSOClusterManagerImpl.endTransaction(): ", e);
        }
    }

    private MBeanServer getMBeanServer() {
        if (this.server == null && this.ssoValve != null) {
            this.server = this.ssoValve.getMBeanServer();
        }
        return this.server;
    }

    private boolean isCacheAvailable() {
        boolean avail;
        boolean bl = avail = this.cache != null;
        if (!avail) {
            this.logMissingCacheError();
        }
        return avail;
    }

    private void putSessionInCache(String ssoId, FullyQualifiedSessionId fullyQualifiedSessionId) throws Exception {
        SessionKey key = new SessionKey(ssoId);
        AtomicMap map = this.atomicMapFactory.getAtomicMap(key.cast(this.cache), (Object)key, true);
        map.put((Object)fullyQualifiedSessionId, null);
    }

    private void putCredentialsInCache(String ssoId, SSOCredentials credentials) throws Exception {
        CredentialKey key = new CredentialKey(ssoId);
        key.cast(this.cache).put((Object)key, (Object)credentials);
    }

    private SSOCredentials getCredentialsFromCache(String ssoId) {
        CredentialKey key = new CredentialKey(ssoId);
        return (SSOCredentials)key.cast(this.cache).get((Object)key);
    }

    private void removeSSOFromCache(String ssoId) throws Exception {
        AbstractSSOKey key = new SessionKey(ssoId);
        this.cache.remove((Object)key);
        key = new CredentialKey(ssoId);
        this.cache.remove((Object)key);
    }

    private void removeSessionFromCache(String ssoId, FullyQualifiedSessionId fullyQualifiedSessionId) throws Exception {
        SessionKey key = new SessionKey(ssoId);
        AtomicMap map = this.atomicMapFactory.getAtomicMap(key.cast(this.cache), (Object)key, false);
        if (map != null) {
            map.remove((Object)fullyQualifiedSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCredentials(String ssoId, String authType, String username, String password) {
        SSOCredentials credentials = new SSOCredentials(authType, username, password);
        this.beingLocallyAdded.set(ssoId);
        try {
            this.putCredentialsInCache(ssoId, credentials);
        }
        catch (Exception e) {
            log.error((Object)("Exception attempting to add Cache nodes for SSO " + ssoId), (Throwable)e);
        }
        finally {
            this.beingLocallyAdded.set(null);
        }
    }

    private void initThreadPool() {
        if (this.threadPoolName != null && this.getMBeanServer() != null) {
            try {
                ObjectName on = new ObjectName(this.threadPoolName);
                this.threadPool = (ThreadPool)this.server.getAttribute(on, "Instance");
                log.debug((Object)("Using ThreadPool at " + this.threadPoolName + " to clean dead members"));
            }
            catch (Exception e) {
                log.info((Object)("Unable to access ThreadPool at " + this.threadPoolName + " -- will use individual threads for cleanup work"));
                log.debug((Object)("Failure to access ThreadPool due to: " + e));
            }
        } else {
            log.debug((Object)"No ThreadPool configured -- will use individual threads for cleanup work");
        }
    }

    private boolean isMissingCacheErrorLogged() {
        return this.missingCacheErrorLogged;
    }

    private void setMissingCacheErrorLogged(boolean missingCacheErrorLogged) {
        this.missingCacheErrorLogged = missingCacheErrorLogged;
    }

    private void logMissingCacheError() {
        StringBuffer msg = new StringBuffer("Cache is not set");
        msg.append(" -- Cache must be started before SSOClusterManagerImpl ");
        msg.append("can handle requests");
        if (this.isMissingCacheErrorLogged()) {
            log.warn((Object)msg);
        } else {
            log.error((Object)msg);
            this.setMissingCacheErrorLogged(true);
        }
    }

    private class SSOCleanerTask
    implements Runnable {
        private final boolean checkForEmpty;

        SSOCleanerTask(boolean checkForEmpty) {
            this.checkForEmpty = checkForEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = SSOClusterManager.this.cleanupMutex;
            synchronized (object) {
                try {
                    log.debug((Object)"check if we have to clean up SSO for any members that left the cluster.");
                    if (SSOClusterManager.this.tm == null) {
                        SSOClusterManager.this.configureFromCache();
                    }
                    Set ids = SSOClusterManager.this.getSSOIds();
                    for (String sso : ids) {
                        this.cleanSSO(sso);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Caught exception cleaning sessions from dead cluster members from SSOs ", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanSSO(String ssoId) {
            block18: {
                boolean doTx = false;
                try {
                    Set fullyQualifiedSessionIds;
                    if (SSOClusterManager.this.tm.getTransaction() == null) {
                        doTx = true;
                    }
                    if (doTx) {
                        SSOClusterManager.this.tm.begin();
                    }
                    if ((fullyQualifiedSessionIds = SSOClusterManager.this.getSSOSessions(ssoId)).size() > 0) {
                        for (FullyQualifiedSessionId fullyQualifiedSessionId : fullyQualifiedSessionIds) {
                            boolean alive;
                            Set set = SSOClusterManager.this.currentView;
                            synchronized (set) {
                                alive = SSOClusterManager.this.currentView.contains(fullyQualifiedSessionId.getHostName());
                            }
                            if (alive) continue;
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Removing peer " + fullyQualifiedSessionId + " from SSO " + ssoId));
                            }
                            SSOClusterManager.this.removeSessionFromCache(ssoId, fullyQualifiedSessionId);
                        }
                        break block18;
                    }
                    if (this.checkForEmpty) {
                        SSOClusterManager.this.ssoValve.notifySSOEmpty(ssoId);
                    }
                }
                catch (Exception e) {
                    try {
                        if (doTx) {
                            SSOClusterManager.this.tm.setRollbackOnly();
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    log.error((Object)("caught exception cleaning dead members from SSO " + ssoId), (Throwable)e);
                }
                finally {
                    if (doTx) {
                        SSOClusterManager.this.endTransaction();
                    }
                }
            }
        }
    }
}

