/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.ispn;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jboss.ha.core.framework.server.CoreGroupCommunicationService;
import org.jboss.ha.framework.interfaces.GroupMembershipNotifier;
import org.jboss.ha.framework.interfaces.GroupRpcDispatcher;
import org.jboss.ha.framework.server.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.ha.ispn.CacheContainerRegistry;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationMode;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.CacheSource;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.LockManagerSource;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jgroups.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheSource
implements CacheSource,
LockManagerSource {
    public static final Short SCOPE_ID = 222;
    public static final String SERVICE_NAME = "HTTPSESSIONOWNER";
    public static final String DEFAULT_CACHE_CONTAINER = "session";
    private final CacheContainerRegistry registry;
    private String defaultContainerName = "session";
    private final Map<String, SharedLocalYieldingClusterLockManager> lockManagers = new HashMap<String, SharedLocalYieldingClusterLockManager>();

    public DefaultCacheSource(CacheContainerRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedLocalYieldingClusterLockManager getLockManager(LocalDistributableSessionManager manager) {
        String containerName = this.getContainerName(manager.getReplicationConfig());
        Map<String, SharedLocalYieldingClusterLockManager> map = this.lockManagers;
        synchronized (map) {
            SharedLocalYieldingClusterLockManager lockManager = this.lockManagers.get(containerName);
            if (lockManager == null) {
                EmbeddedCacheManager container = this.registry.getCacheContainer(containerName);
                String cacheName = this.getCacheName(manager);
                Cache cache = container.getCache(cacheName);
                JGroupsTransport transport = (JGroupsTransport)cache.getAdvancedCache().getRpcManager().getTransport();
                Channel channel = transport.getChannel();
                CoreGroupCommunicationService gcs = new CoreGroupCommunicationService();
                gcs.setChannel(channel);
                gcs.setScopeId(SCOPE_ID);
                try {
                    gcs.start();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unexpected exception while starting group communication service for " + containerName);
                }
                lockManager = new SharedLocalYieldingClusterLockManager(SERVICE_NAME, (GroupRpcDispatcher)gcs, (GroupMembershipNotifier)gcs);
                try {
                    lockManager.start();
                    this.lockManagers.put(containerName, lockManager);
                }
                catch (Exception e) {
                    gcs.stop();
                    throw new IllegalStateException("Unexpected exception while starting lock manager for " + containerName);
                }
            }
            return lockManager;
        }
    }

    @Override
    public <K, V> Cache<K, V> getCache(LocalDistributableSessionManager manager) {
        ReplicationConfig replConfig = manager.getReplicationConfig();
        String containerName = this.getContainerName(replConfig);
        EmbeddedCacheManager container = this.registry.getCacheContainer(containerName);
        String cacheName = this.getCacheName(manager);
        Cache templateCache = container.getCache();
        Configuration configuration = templateCache.getConfiguration().clone();
        Configuration.CacheMode mode = this.getCacheMode(replConfig, configuration);
        configuration.setCacheMode(mode);
        container.defineConfiguration(cacheName, configuration);
        return container.getCache(cacheName);
    }

    private String getContainerName(ReplicationConfig replConfig) {
        String[] parts;
        String templateCacheName = replConfig.getCacheName();
        String containerName = this.defaultContainerName;
        if (templateCacheName != null && (parts = templateCacheName.split(":")).length == 2) {
            containerName = parts[0];
        }
        return containerName;
    }

    private Configuration.CacheMode getCacheMode(ReplicationConfig replConfig, Configuration configuration) {
        Integer backups = replConfig.getBackups();
        ReplicationMode replMode = replConfig.getReplicationMode();
        Configuration.CacheMode mode = configuration.getCacheMode();
        if (backups != null) {
            int value = backups;
            configuration.setNumOwners(value);
            if (value == 0) {
                mode = Configuration.CacheMode.LOCAL;
            } else {
                boolean synchronous = mode.isSynchronous();
                if (value > 0) {
                    mode = synchronous ? Configuration.CacheMode.DIST_SYNC : Configuration.CacheMode.DIST_ASYNC;
                } else {
                    Configuration.CacheMode cacheMode = mode = synchronous ? Configuration.CacheMode.REPL_SYNC : Configuration.CacheMode.REPL_ASYNC;
                }
            }
        }
        if (replMode != null) {
            switch (replMode) {
                case SYNCHRONOUS: {
                    mode = mode.toSync();
                    break;
                }
                case ASYNCHRONOUS: {
                    mode = mode.toAsync();
                }
            }
        }
        return mode;
    }

    private String getCacheName(LocalDistributableSessionManager manager) {
        String hostName = manager.getHostName();
        String host = hostName == null || hostName.isEmpty() ? "localhost" : hostName;
        String context = manager.getContextName();
        String path = context.isEmpty() || context.equals("/") ? "ROOT" : (context.startsWith("/") ? context.substring(1) : context);
        return host + "/" + path;
    }

    public void setDefaultContainerName(String defaultContainerName) {
        this.defaultContainerName = defaultContainerName;
    }
}

