/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.ispn;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.ha.ispn.CacheContainerRegistry;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationMode;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.CacheSource;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheSource
implements CacheSource {
    private final CacheContainerRegistry registry;

    public DefaultCacheSource(CacheContainerRegistry registry) {
        this.registry = registry;
    }

    @Override
    public <K, V> Cache<K, V> getCache(LocalDistributableSessionManager manager) {
        String hostName;
        String[] parts;
        ReplicationConfig config = manager.getReplicationConfig();
        String containerName = config.getCacheName();
        String templateCacheName = null;
        if (containerName != null && !containerName.isEmpty() && (parts = containerName.split("/")).length == 2) {
            containerName = parts[0];
            templateCacheName = parts[1];
        }
        String host = (hostName = manager.getHostName()) == null || hostName.isEmpty() ? "localhost" : hostName;
        String context = manager.getContextName();
        String path = context.isEmpty() || context.equals("/") ? "ROOT" : (context.startsWith("/") ? context.substring(1) : context);
        String cacheName = host + "/" + path;
        EmbeddedCacheManager container = this.registry.getCacheContainer(containerName);
        this.applyOverrides(container.defineConfiguration(cacheName, templateCacheName, new Configuration()), config);
        return container.getCache(cacheName);
    }

    private void applyOverrides(Configuration configuration, ReplicationConfig replConfig) {
        Integer backups = replConfig.getBackups();
        ReplicationMode replMode = replConfig.getReplicationMode();
        Configuration.CacheMode mode = configuration.getCacheMode();
        if (backups != null) {
            int value = backups;
            configuration.setNumOwners(value);
            if (value == 0) {
                mode = Configuration.CacheMode.LOCAL;
            } else {
                boolean synchronous = mode.isSynchronous();
                if (value > 0) {
                    mode = synchronous ? Configuration.CacheMode.DIST_SYNC : Configuration.CacheMode.DIST_ASYNC;
                } else {
                    Configuration.CacheMode cacheMode = mode = synchronous ? Configuration.CacheMode.REPL_SYNC : Configuration.CacheMode.REPL_ASYNC;
                }
            }
        }
        if (replMode != null) {
            switch (replMode) {
                case SYNCHRONOUS: {
                    mode = mode.toSync();
                    break;
                }
                case ASYNCHRONOUS: {
                    mode = mode.toAsync();
                }
            }
        }
        configuration.setCacheMode(mode);
    }
}

