/*
* JBoss, Home of Professional Open Source
* Copyright 2010, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.web.tomcat.service.session.sso.ispn;

/**
 * Used to represent the different types of entries in the cache store.
 *
 * Note that we purposely do not implement equals, which allows many different
 * entries with the same key to be added.
 *
 */
public class CacheKey
{
   public static enum Type { SESSION, CREDENTIAL }

   private final String ssoId;
   private final Type type;

   public CacheKey(String ssoId, Type type)
   {
      this.ssoId = ssoId;
      this.type = type;
   }

   public String getSSOID()
   {
      return this.ssoId;
   }

   public Type getType()
   {
      return this.type;
   }

   @Override
   public int hashCode()
   {
      int result = 17;
      result = 37*result + this.ssoId.hashCode();
      result = 37*result + this.type.ordinal();
      return result;
   }
   
   @Override
   public boolean equals(Object object)
   {
      if ((object == null) || !(object instanceof CacheKey)) return false;
      
      CacheKey key = (CacheKey) object;
      
      return (this.type == key.type) && this.ssoId.equals(key.ssoId);
   }
}
