/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.ucl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.classpool.plugins.ucl.JBossClassPool;
import org.jboss.classpool.plugins.ucl.LoaderRepositoryUrlUtil;
import org.jboss.classpool.plugins.ucl.SecurityActions;
import org.jboss.classpool.scoped.ScopedClassPool;
import org.jboss.classpool.scoped.ScopedClassPoolRepository;
import org.jboss.classpool.spi.AbstractClassPool;
import org.jboss.classpool.spi.AbstractClassPoolFactory;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;

public class ScopedJBossClassPool
extends JBossClassPool {
    static final LoaderRepositoryUrlUtil LOADER_REPOSITORY_UTIL = new LoaderRepositoryUrlUtil();
    private LoaderRepositoryUrlUtil.UrlInfo urlInfo;
    private ThreadLocal<ClassPool> lastPool = new ThreadLocal();

    public ScopedJBossClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, File tmp, URL tmpURL) {
        super(cl, src, repository, tmp, tmpURL);
        boolean parentFirst = false;
        LoaderRepository loaderRepository = null;
        ClassLoader prnt = cl;
        while (prnt != null) {
            if (prnt instanceof RepositoryClassLoader) {
                loaderRepository = ((RepositoryClassLoader)prnt).getLoaderRepository();
                if (!(loaderRepository instanceof HeirarchicalLoaderRepository3)) break;
                parentFirst = ((HeirarchicalLoaderRepository3)loaderRepository).getUseParentFirst();
                break;
            }
            prnt = SecurityActions.getParent(cl);
        }
        this.childFirstLookup = !parentFirst;
    }

    private HeirarchicalLoaderRepository3 getRepository() {
        ClassLoader cl = this.getClassLoader0();
        if (cl != null) {
            return (HeirarchicalLoaderRepository3)((RepositoryClassLoader)cl).getLoaderRepository();
        }
        return null;
    }

    private URL getResourceUrlForClass(String resourcename) {
        HeirarchicalLoaderRepository3 repo = this.getRepository();
        return repo.getResource(resourcename, super.getClassLoader());
    }

    private boolean isMine(URL url) {
        HeirarchicalLoaderRepository3 repo = this.getRepository();
        if (repo != null && url != null) {
            this.urlInfo = LOADER_REPOSITORY_UTIL.getURLInfo(this.getRepository(), this.urlInfo);
            URL[] myUrls = this.urlInfo.getLocalUrls();
            String resource = url.toString();
            for (int i = 0; i < myUrls.length; ++i) {
                if (resource.indexOf(myUrls[i].toString()) < 0) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public CtClass getCached(String classname) {
        if (classname == null) {
            return null;
        }
        if (this.isUnloadedClassLoader()) {
            return null;
        }
        if (this.generatedClasses.get(classname) != null) {
            return super.getCached(classname);
        }
        String resourcename = this.getResourceName(classname);
        URL url = this.getResourceUrlForClass(resourcename);
        boolean isMine = this.isMine(url);
        if (isMine) {
            if (this.childFirstLookup) {
                CtClass clazz = super.getCachedLocally(classname);
                if (clazz == null && (clazz = this.createCtClass(classname, false)) != null) {
                    this.lockInCache(clazz);
                }
                if (clazz != null) {
                    return clazz;
                }
            }
            return super.getCached(classname);
        }
        try {
            ClassPool pool = this.getCorrectPoolForResource(classname, url);
            if (pool != this.lastPool.get()) {
                this.lastPool.set(pool);
                CtClass ctClass = pool.get(classname);
                return ctClass;
            }
        }
        catch (NotFoundException e) {
        }
        catch (StackOverflowError e) {
            throw e;
        }
        finally {
            this.lastPool.set(null);
        }
        return null;
    }

    protected boolean includeInGlobalSearch() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPool getCorrectPoolForResource(String classname, URL url) {
        ClassPoolRepository classPoolRepository = ClassPoolRepository.getInstance();
        Map map = classPoolRepository.getRegisteredCLs();
        synchronized (map) {
            ArrayList<AbstractClassPool> noAnnotationURLClassLoaderPools = null;
            String resource = url.toString();
            for (ScopedClassPool scopedClassPool : classPoolRepository.getRegisteredCLs().values()) {
                AbstractClassPool candidate = (AbstractClassPool)scopedClassPool;
                if (candidate.isUnloadedClassLoader()) {
                    classPoolRepository.unregisterClassLoader(candidate.getClassLoader());
                    continue;
                }
                if (candidate.getClassLoader() instanceof RepositoryClassLoader) {
                    RepositoryClassLoader rcl = (RepositoryClassLoader)candidate.getClassLoader();
                    URL[] urls = rcl.getClasspath();
                    for (int i = 0; i < urls.length; ++i) {
                        if (resource.indexOf(urls[i].getFile()) < 0) continue;
                        return candidate;
                    }
                    continue;
                }
                if (!this.isInstanceOfNoAnnotationURLClassLoader(candidate.getClassLoader())) continue;
                if (noAnnotationURLClassLoaderPools == null) {
                    noAnnotationURLClassLoaderPools = new ArrayList<AbstractClassPool>();
                }
                noAnnotationURLClassLoaderPools.add(candidate);
            }
            if (noAnnotationURLClassLoaderPools != null) {
                for (AbstractClassPool abstractClassPool : noAnnotationURLClassLoaderPools) {
                    try {
                        abstractClassPool.get(classname);
                        return abstractClassPool;
                    }
                    catch (NotFoundException ignoreTryNext) {
                    }
                }
            }
        }
        return ClassPoolRepository.getInstance().getClassPoolFactory().create(AbstractClassPoolFactory.getSystemClassPool(), (ScopedClassPoolRepository)ClassPoolRepository.getInstance());
    }

    private boolean isInstanceOfNoAnnotationURLClassLoader(ClassLoader loader) {
        for (Class<?> parent = loader.getClass(); parent != null; parent = parent.getSuperclass()) {
            if (!"NoAnnotationURLClassLoader".equals(parent.getSimpleName())) continue;
            return true;
        }
        return false;
    }
}

