/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.classpool.plugins.jbosscl;

import org.jboss.classloading.spi.dependency.Module;

/**
 * Interface to find the parent deployment unit loader for a Module.
 * 
 * @see ParentUnitLoaderFinders
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public interface ParentUnitLoaderFinder
{
   /**
    * Check if we can we handle a module of the given type
    * 
    * @param module the module we are checking
    * @return true if we can handle it
    */
   boolean handle(Module module);
   
   /**
    * Find the parent unit loader
    * 
    * @param module the module we are checking
    * @return the classloader to use as the parent
    */
   ClassLoader findParentUnitLoader(Module module);
}
