/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.jbosscl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassPool;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classpool.scoped.ScopedClassPool;
import org.jboss.classpool.spi.ClassPoolRepository;

public class JBossClDelegatingClassPoolRepository
extends ClassPoolRepository {
    private static final JBossClDelegatingClassPoolRepository instance = new JBossClDelegatingClassPoolRepository();
    protected Map<Module, ScopedClassPool> registeredModules = Collections.synchronizedMap(new WeakHashMap());

    public static JBossClDelegatingClassPoolRepository getInstance() {
        return instance;
    }

    public ClassPool registerClassLoader(ClassLoader classLoader) {
        ScopedClassPool classPool = (ScopedClassPool)super.registerClassLoader(classLoader);
        if (classPool == null) {
            super.unregisterClassLoader(classLoader);
        } else {
            Module module = this.getModuleForClassLoader(classLoader);
            this.registeredModules.put(module, classPool);
        }
        return classPool;
    }

    public void unregisterClassLoader(ClassLoader classLoader, Module module) {
        ScopedClassPool classPool = this.registeredModules.remove(module);
        if (classLoader == null) {
            if (classPool == null) {
                throw new IllegalStateException("Module " + module + " is not registered");
            }
            classPool.close();
        } else {
            this.unregisterClassLoader(classLoader);
        }
    }

    private Module getModuleForClassLoader(final ClassLoader classLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<Module>(){

            @Override
            public Module run() {
                return ClassLoading.getModuleForClassLoader((ClassLoader)classLoader);
            }
        });
    }
}

