/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.classfilewriter.AccessFlag;
import org.jboss.classfilewriter.ClassField;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.WritableEntry;
import org.jboss.classfilewriter.annotations.AnnotationBuilder;
import org.jboss.classfilewriter.annotations.AnnotationsAttribute;
import org.jboss.classfilewriter.attributes.Attribute;
import org.jboss.classfilewriter.constpool.ConstPool;
import org.jboss.classfilewriter.util.ByteArrayDataOutputStream;
import org.jboss.classfilewriter.util.DescriptorUtils;

public class ClassFile
implements WritableEntry {
    private final String name;
    private final String superclass;
    private final int accessFlags;
    private final int version;
    private final ConstPool constPool = new ConstPool();
    private final List<String> interfaces = new ArrayList<String>();
    private final Set<ClassField> fields = new HashSet<ClassField>();
    private final Set<ClassMethod> methods = new HashSet<ClassMethod>();
    private byte[] bytecode;
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final AnnotationsAttribute runtimeVisibleAnnotationsAttribute;
    private final ClassLoader classLoader;
    private static Method defineClass1;
    private static Method defineClass2;

    public ClassFile(String name, String superclass, String ... interfaces) {
        this(name, AccessFlag.of(32, 1), superclass, (ClassLoader)null, interfaces);
    }

    public ClassFile(String name, int accessFlags, String superclass, String ... interfaces) {
        this(name, accessFlags, superclass, (ClassLoader)null, interfaces);
    }

    public ClassFile(String name, String superclass, ClassLoader classLoader, String ... interfaces) {
        this(name, AccessFlag.of(32, 1), superclass, classLoader, interfaces);
    }

    public ClassFile(String name, int accessFlags, String superclass, ClassLoader classLoader, String ... interfaces) {
        this(name, accessFlags, superclass, 50, classLoader, interfaces);
    }

    public ClassFile(String name, int accessFlags, String superclass, int version, ClassLoader classLoader, String ... interfaces) {
        if (version > 50 && classLoader == null) {
            throw new IllegalArgumentException("ClassLoader must be specified if version is greater than Java 6");
        }
        this.version = version;
        this.classLoader = classLoader;
        this.name = name.replace('/', '.');
        this.superclass = superclass;
        this.accessFlags = accessFlags;
        this.interfaces.addAll(Arrays.asList(interfaces));
        this.runtimeVisibleAnnotationsAttribute = new AnnotationsAttribute(AnnotationsAttribute.Type.RUNTIME_VISIBLE, this.constPool);
        this.attributes.add(this.runtimeVisibleAnnotationsAttribute);
    }

    public void addInterface(String iface) {
        this.interfaces.add(iface);
    }

    public ClassField addField(int accessFlags, String name, String descriptor) {
        return this.addField(accessFlags, name, descriptor, null);
    }

    public ClassField addField(int accessFlags, String name, String descriptor, String signature) {
        ClassField field = new ClassField((short)accessFlags, name, descriptor, this, this.constPool);
        if (this.fields.contains(field)) {
            throw new DuplicateMemberException("Field  already exists. Field: " + name + " Descriptor:" + signature);
        }
        this.fields.add(field);
        field.setSignature(signature);
        return field;
    }

    public ClassField addField(int accessFlags, String name, Class<?> type) {
        return this.addField(accessFlags, name, DescriptorUtils.makeDescriptor(type));
    }

    public ClassField addField(int accessFlags, String name, Class<?> type, String genericSignature) {
        return this.addField(accessFlags, name, DescriptorUtils.makeDescriptor(type), genericSignature);
    }

    public ClassField addField(Field field) {
        ClassField classField = this.addField((int)((short)field.getModifiers()), field.getName(), field.getType(), null);
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            classField.getRuntimeVisibleAnnotationsAttribute().addAnnotation(AnnotationBuilder.createAnnotation(this.constPool, annotation));
        }
        return classField;
    }

    public ClassMethod addMethod(int accessFlags, String name, String returnType, String ... parameters) {
        ClassMethod method = new ClassMethod(name, returnType, parameters, accessFlags, this);
        if (this.methods.contains(method)) {
            throw new DuplicateMemberException("Method  already exists. Method: " + name + " Parameters:" + Arrays.toString(parameters) + " Return Type: " + returnType);
        }
        this.methods.add(method);
        return method;
    }

    public ClassMethod addMethod(Method method) {
        ClassMethod classMethod = this.addMethod(method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF, method.getName(), DescriptorUtils.makeDescriptor(method.getReturnType()), DescriptorUtils.parameterDescriptors(method.getParameterTypes()));
        for (Class<?> e : method.getExceptionTypes()) {
            classMethod.addCheckedExceptions(e);
        }
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            classMethod.getRuntimeVisibleAnnotationsAttribute().addAnnotation(AnnotationBuilder.createAnnotation(this.constPool, annotation));
        }
        int count = 0;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = annotationArray[i]) {
                classMethod.getRuntimeVisibleParameterAnnotationsAttribute().addAnnotation(count, AnnotationBuilder.createAnnotation(this.constPool, annotation));
            }
            ++count;
        }
        return classMethod;
    }

    public ClassMethod addConstructor(Constructor<?> method) {
        ClassMethod classMethod = this.addMethod(method.getModifiers(), "<init>", "V", DescriptorUtils.parameterDescriptors(method.getParameterTypes()));
        for (Class<?> e : method.getExceptionTypes()) {
            classMethod.addCheckedExceptions(e);
        }
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            classMethod.getRuntimeVisibleAnnotationsAttribute().addAnnotation(AnnotationBuilder.createAnnotation(this.constPool, annotation));
        }
        int count = 0;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = annotationArray[i]) {
                classMethod.getRuntimeVisibleParameterAnnotationsAttribute().addAnnotation(count, AnnotationBuilder.createAnnotation(this.constPool, annotation));
            }
            ++count;
        }
        return classMethod;
    }

    @Override
    public void write(ByteArrayDataOutputStream stream) throws IOException {
        short nameIndex = this.constPool.addClassEntry(this.name);
        short superClassIndex = this.constPool.addClassEntry(this.superclass);
        ArrayList<Short> interfaceIndexes = new ArrayList<Short>(this.interfaces.size());
        for (String i : this.interfaces) {
            interfaceIndexes.add(this.constPool.addClassEntry(i));
        }
        stream.writeInt(-889275714);
        stream.writeInt(this.version);
        this.constPool.write(stream);
        stream.writeShort(this.accessFlags);
        stream.writeShort(nameIndex);
        stream.writeShort(superClassIndex);
        stream.writeShort(interfaceIndexes.size());
        Iterator<Object> iterator = interfaceIndexes.iterator();
        while (iterator.hasNext()) {
            short i = (Short)((Object)iterator.next());
            stream.writeShort(i);
        }
        stream.writeShort(this.fields.size());
        for (ClassField field : this.fields) {
            field.write(stream);
        }
        stream.writeShort(this.methods.size());
        for (ClassMethod method : this.methods) {
            method.write(stream);
        }
        stream.writeShort(this.attributes.size());
        for (Attribute attribute : this.attributes) {
            attribute.write(stream);
        }
    }

    public Class<?> define() {
        return this.define(this.classLoader, null);
    }

    @Deprecated
    public Class<?> define(ClassLoader loader) {
        return this.define(loader, null);
    }

    public Class<?> define(ProtectionDomain domain) {
        return this.define(this.classLoader, domain);
    }

    @Deprecated
    public Class<?> define(ClassLoader loader, ProtectionDomain domain) {
        try {
            Object[] args;
            Method method;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                int index = this.name.lastIndexOf(46);
                String packageName = index == -1 ? "" : this.name.substring(0, index);
                RuntimePermission permission = new RuntimePermission("defineClassInPackage." + packageName);
                sm.checkPermission(permission);
            }
            byte[] b = this.toBytecode();
            if (domain == null) {
                method = defineClass1;
                args = new Object[]{this.name.replace('/', '.'), b, new Integer(0), new Integer(b.length)};
            } else {
                method = defineClass2;
                args = new Object[]{this.name.replace('/', '.'), b, new Integer(0), new Integer(b.length), domain};
            }
            Class clazz = (Class)method.invoke((Object)loader, args);
            return clazz;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toBytecode() {
        if (this.bytecode == null) {
            try {
                ByteArrayDataOutputStream out = new ByteArrayDataOutputStream();
                this.write(out);
                this.bytecode = out.getBytes();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.bytecode;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public String getDescriptor() {
        return 'L' + this.name + ';';
    }

    public AnnotationsAttribute getRuntimeVisibleAnnotationsAttribute() {
        return this.runtimeVisibleAnnotationsAttribute;
    }

    public String getName() {
        return this.name;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public List<String> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public Set<ClassField> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Set<ClassMethod> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Class<?> cl = Class.forName("java.lang.ClassLoader", false, null);
                    defineClass1 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                    defineClass1.setAccessible(true);
                    defineClass2 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    defineClass2.setAccessible(true);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("cannot initialize ClassFile", pae.getException());
        }
    }
}

