/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.annotations;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jboss.classfilewriter.annotations.AnnotationValue;
import org.jboss.classfilewriter.constpool.ConstPool;

public class FloatAnnotationValue
extends AnnotationValue {
    private final int valueIndex;
    private final float value;

    public FloatAnnotationValue(ConstPool constPool, String name, float value) {
        super(constPool, name);
        this.value = value;
        this.valueIndex = constPool.addFloatEntry(value);
    }

    @Override
    public char getTag() {
        return 'F';
    }

    @Override
    public void writeData(DataOutputStream stream) throws IOException {
        stream.writeShort(this.valueIndex);
    }

    public float getValue() {
        return this.value;
    }
}

