/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.annotations;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jboss.classfilewriter.annotations.AnnotationValue;
import org.jboss.classfilewriter.constpool.ConstPool;

public class StringAnnotationValue
extends AnnotationValue {
    private final int valueIndex;
    private final String value;

    public StringAnnotationValue(ConstPool constPool, String name, String value) {
        super(constPool, name);
        this.value = value;
        this.valueIndex = constPool.addStringEntry(value);
    }

    @Override
    public char getTag() {
        return 's';
    }

    @Override
    public void writeData(DataOutputStream stream) throws IOException {
        stream.writeShort(this.valueIndex);
    }

    public String getValue() {
        return this.value;
    }
}

