/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.annotations;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jboss.classfilewriter.annotations.AnnotationValue;
import org.jboss.classfilewriter.constpool.ConstPool;
import org.jboss.classfilewriter.util.DescriptorUtils;

public class ClassAnnotationValue
extends AnnotationValue {
    private final int valueIndex;

    public ClassAnnotationValue(ConstPool constPool, String name, Class<?> value) {
        super(constPool, name);
        this.valueIndex = constPool.addUtf8Entry(DescriptorUtils.makeDescriptor(value));
    }

    public ClassAnnotationValue(ConstPool constPool, String name, String descriptor) {
        super(constPool, name);
        this.valueIndex = constPool.addUtf8Entry(descriptor);
    }

    @Override
    public char getTag() {
        return 'c';
    }

    @Override
    public void writeData(DataOutputStream stream) throws IOException {
        stream.writeShort(this.valueIndex);
    }
}

