/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.plugins.visitor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.RootAwareResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceContext
implements ResourceContext,
RootAwareResource {
    private ClassLoader classLoader;
    private String resourceName;

    public AbstractResourceContext(String resourceName, ClassLoader classLoader) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Null resourceName");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        this.resourceName = resourceName;
        this.classLoader = classLoader;
    }

    @Override
    public URL getRootUrl() {
        throw new RuntimeException("Not implemented, override in non-abstract class / implementation.");
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getClassName() {
        return ClassLoaderUtils.resourceNameToClassName((String)this.getResourceName());
    }

    @Override
    public boolean isClass() {
        return this.resourceName.endsWith(".class");
    }

    @Override
    public Class<?> loadClass() {
        String className = this.getClassName();
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected error loading class: " + className, e);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URL url = this.getUrl();
        if (url == null) {
            throw new IllegalArgumentException("Null url: " + this.resourceName);
        }
        return url.openStream();
    }

    @Override
    public byte[] getBytes() throws IOException {
        return ClassLoaderUtils.loadBytes((InputStream)this.getInputStream());
    }
}

