/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency.wildcard;

import java.util.Set;
import org.jboss.classloading.plugins.metadata.PackageRequirement;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.RequirementDependencyItem;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.dependency.plugins.ResolvedState;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.util.collection.ConcurrentSet;

public class WildcardRequirementDependencyItem
extends RequirementDependencyItem {
    private Set<Module> resolvedModules = new ConcurrentSet();

    public WildcardRequirementDependencyItem(Module module, Requirement requirement, ControllerState state) {
        super(module, requirement, state);
        this.check();
    }

    public WildcardRequirementDependencyItem(Module module, Requirement requirement, ControllerState whenRequired, ControllerState dependentState) {
        super(module, requirement, whenRequired, dependentState);
        this.check();
    }

    private void check() {
        Requirement requirement = super.getRequirement();
        if (requirement == null || !(requirement instanceof PackageRequirement)) {
            throw new IllegalArgumentException("Illegal requirement: " + requirement);
        }
        PackageRequirement pr = (PackageRequirement)requirement;
        if (!pr.isWildcard()) {
            throw new IllegalArgumentException("Requirement is not wildcard: " + pr);
        }
        if (this.getModule() == null) {
            throw new IllegalArgumentException("Null module");
        }
    }

    public PackageRequirement getRequirement() {
        return (PackageRequirement)super.getRequirement();
    }

    public boolean resolve(Controller controller) {
        this.setResolved(true);
        return this.isResolved();
    }

    protected void addDependsOnMe(Controller controller, ControllerContext context) {
    }

    public void setResolved(ResolvedState resolved) {
        if (resolved == ResolvedState.UNRESOLVED) {
            for (Module module : this.resolvedModules) {
                this.removeDepends(module);
            }
        }
        super.setResolved(resolved);
    }

    void addIDependOn(Module module) {
        this.addDepends(module);
        this.resolvedModules.add(module);
    }
}

