/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency.wildcard;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.ClassLoadingTask;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.plugins.metadata.PackageRequirement;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Domain;
import org.jboss.classloading.spi.dependency.ExportPackage;
import org.jboss.classloading.spi.dependency.LifeCycle;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.ModuleRegistry;
import org.jboss.classloading.spi.dependency.wildcard.WildcardRequirementDependencyItem;
import org.jboss.util.collection.ConcurrentReferenceHashMap;
import org.jboss.util.collection.ConcurrentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardClassLoaderPolicy
extends ClassLoaderPolicy
implements ModuleRegistry {
    private Domain domain;
    private WildcardRequirementDependencyItem item;
    private PackageRequirement requirement;
    private Module module;
    private List<Module> modules = new CopyOnWriteArrayList<Module>();
    private int parentsBefore;
    private Map<String, ClassLoader> resourceCache = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    private Set<Module> used = new ConcurrentSet();
    private Map<Module, ClassLoader> classLoaders = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WildcardClassLoaderPolicy(Domain domain, WildcardRequirementDependencyItem item) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        if (item == null) {
            throw new IllegalArgumentException("Null item");
        }
        this.domain = domain;
        this.item = item;
        this.requirement = item.getRequirement();
        this.module = item.getModule();
        ClassLoading classLoading = domain.getClassLoading();
        WildcardClassLoaderPolicy wildcardClassLoaderPolicy = this;
        synchronized (wildcardClassLoaderPolicy) {
            classLoading.addModuleRegistry(this);
            this.fillModules(domain);
            this.modules.remove(this.module);
        }
    }

    protected ClassLoader getClassLoader(Module m) {
        ClassLoader cl = this.classLoaders.get(m);
        if (cl != null) {
            return cl;
        }
        cl = ClassLoading.getClassLoaderForModule(m);
        if (cl != null) {
            this.classLoaders.put(m, cl);
        }
        return cl;
    }

    protected void addUsed(Module m) {
        if (this.used.add(m) && !m.isCascadeShutdown()) {
            this.item.addIDependOn(m);
        }
    }

    protected ClassLoader findClassLoader(String resource) {
        ClassLoader cached = this.resourceCache.get(resource);
        if (cached != null) {
            return cached;
        }
        ClassFilter filter = this.requirement.toClassFilter();
        if (filter.matchesResourcePath(resource)) {
            for (Module m : this.modules) {
                URL url;
                ClassLoader cl = this.getClassLoader(m);
                if (cl == null || (url = cl.getResource(resource)) == null) continue;
                this.resourceCache.put(resource, cl);
                this.addUsed(m);
                return cl;
            }
        }
        return null;
    }

    public URL getResource(String path) {
        ClassLoader cached = this.resourceCache.get(path);
        if (cached != null) {
            return cached.getResource(path);
        }
        ClassFilter filter = this.requirement.toClassFilter();
        if (filter.matchesResourcePath(path)) {
            for (Module m : this.modules) {
                URL url;
                ClassLoader cl = this.getClassLoader(m);
                if (cl == null || (url = cl.getResource(path)) == null) continue;
                this.resourceCache.put(path, cl);
                this.addUsed(m);
                return url;
            }
        }
        return null;
    }

    public void getResources(String name, Set<URL> urls) throws IOException {
        ClassFilter filter = this.requirement.toClassFilter();
        if (filter.matchesResourcePath(name)) {
            for (Module m : this.modules) {
                ClassLoader cl = this.getClassLoader(m);
                if (cl == null) continue;
                boolean visited = false;
                Enumeration<URL> eu = cl.getResources(name);
                while (eu.hasMoreElements()) {
                    if (!visited) {
                        this.addUsed(m);
                        visited = true;
                    }
                    urls.add(eu.nextElement());
                }
            }
        }
    }

    protected boolean isCacheable() {
        return false;
    }

    protected Domain getDomain(Module module) {
        Domain current;
        String domainName = module.getDeterminedDomainName();
        for (current = this.domain; current != null && !domainName.equals(this.domain.getName()); current = current.getParentDomain()) {
        }
        return current;
    }

    protected void reset() {
        this.resourceCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModule(Module current) {
        Domain md = this.getDomain(current);
        if (md != null && current.canResolve(this.requirement)) {
            boolean isAncestor = this.domain != md;
            WildcardClassLoaderPolicy wildcardClassLoaderPolicy = this;
            synchronized (wildcardClassLoaderPolicy) {
                boolean isParentFirst = this.domain.isParentFirst();
                this.addModule(current, isAncestor, isParentFirst);
            }
        }
    }

    private void addModule(Module current, boolean isAncestor, boolean isParentFirst) {
        if (isAncestor) {
            if (isParentFirst) {
                this.modules.add(this.parentsBefore, current);
                ++this.parentsBefore;
            } else {
                this.modules.add(current);
            }
        } else {
            this.modules.add(this.parentsBefore, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModule(Module current) {
        boolean cascade = current.isCascadeShutdown();
        if (cascade) {
            LifeCycle lifeCycle;
            boolean sameModule = this.module == current;
            boolean resolvedModule = false;
            if (!sameModule) {
                WildcardClassLoaderPolicy wildcardClassLoaderPolicy = this;
                synchronized (wildcardClassLoaderPolicy) {
                    if (this.modules.remove(current)) {
                        boolean isAncestor;
                        this.classLoaders.remove(current);
                        resolvedModule = true;
                        Domain md = this.getDomain(current);
                        boolean bl = isAncestor = this.domain != md;
                        if (isAncestor && this.domain.isParentFirst()) {
                            --this.parentsBefore;
                        }
                        this.reset();
                    }
                }
            }
            if (sameModule) {
                ClassLoading classLoading = this.domain.getClassLoading();
                classLoading.removeModuleRegistry(this);
                this.module = null;
            }
            if (resolvedModule && this.used.remove(current) && (lifeCycle = this.module.getLifeCycle()) != null) {
                try {
                    lifeCycle.bounce();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error bouncing module: " + this.module, e);
                }
            }
        }
    }

    protected void fillModules(Domain current) {
        Collection<ExportPackage> eps;
        Domain parent = current.getParentDomain();
        boolean parentFirst = current.isParentFirst();
        if (parent != null && parentFirst) {
            this.fillModules(parent);
        }
        if ((eps = current.getExportedPackages(this.requirement.getName(), this.requirement.getVersionRange())) != null && !eps.isEmpty()) {
            boolean isAncestor = current != this.domain;
            boolean isParentFirst = this.domain.isParentFirst();
            for (ExportPackage ep : eps) {
                Module m = ep.getModule();
                this.addModule(m, isAncestor, isParentFirst);
            }
        }
        if (parent != null && !parentFirst) {
            this.fillModules(parent);
        }
    }

    BaseClassLoader getBaseClassLoader(String context) {
        ClassLoader cl = this.findClassLoader(context);
        if (cl != null && cl instanceof BaseClassLoader) {
            return (BaseClassLoader)BaseClassLoader.class.cast(cl);
        }
        return null;
    }

    protected BaseClassLoader getClassLoader(ClassLoadingTask task) {
        if (task == null) {
            throw new IllegalArgumentException("Null task");
        }
        String path = ClassLoaderUtils.classNameToPath((String)task.getClassName());
        return this.getBaseClassLoader(path);
    }
}

