/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.ImportType;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.ShutdownPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.plugins.metadata.PackageCapability;
import org.jboss.classloading.plugins.metadata.PackageRequirement;
import org.jboss.classloading.spi.dependency.ClassLoadingSpace;
import org.jboss.classloading.spi.dependency.Domain;
import org.jboss.classloading.spi.dependency.ExportPackage;
import org.jboss.classloading.spi.dependency.LifeCycle;
import org.jboss.classloading.spi.dependency.RequirementDependencyItem;
import org.jboss.classloading.spi.dependency.wildcard.WildcardRequirementDependencyItem;
import org.jboss.classloading.spi.helpers.NameAndVersionSupport;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaDataFactory;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.metadata.ExportPackages;
import org.jboss.classloading.spi.metadata.OptionalPackages;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.metadata.RequirementWithImportType;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.dependency.plugins.ResolvedState;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Module
extends NameAndVersionSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(Module.class);
    private static Map<ClassLoader, Module> modulesByClassLoader = new ConcurrentHashMap<ClassLoader, Module>();
    private static Set<Module> lazyShutdownModules = new CopyOnWriteArraySet<Module>();
    private String contextName;
    private List<Capability> capabilities;
    private List<Requirement> requirements;
    private ControllerContext context;
    private Domain domain;
    private ClassLoadingSpace space;
    private List<RequirementDependencyItem> requirementDependencies;
    private LifeCycle lifeCycle;
    private Boolean cascadeShutdown;
    private Set<RequirementDependencyItem> depends = new CopyOnWriteArraySet<RequirementDependencyItem>();

    protected static void registerModuleClassLoader(Module module, ClassLoader classLoader) {
        LifeCycle lifeCycle;
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        modulesByClassLoader.put(classLoader, module);
        module.cascadeShutdown = module.isCascadeShutdown();
        if (!module.cascadeShutdown.booleanValue()) {
            module.enableLazyShutdown();
        }
        if ((lifeCycle = module.getLifeCycle()) != null) {
            lifeCycle.fireResolved();
        }
    }

    protected static void unregisterModuleClassLoader(Module module, ClassLoader classLoader) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        modulesByClassLoader.remove(classLoader);
        module.unresolveDependencies();
        LifeCycle lifeCycle = module.getLifeCycle();
        if (lifeCycle != null) {
            lifeCycle.fireUnresolved();
        }
        if (!module.isCascadeShutdown() && !module.depends.isEmpty()) {
            lazyShutdownModules.add(module);
        }
    }

    public Module(String name) {
        this(name, name, null);
    }

    public Module(String name, Object version) {
        this(name, name, version);
    }

    public Module(String name, String contextName, Object version) {
        super(name, version);
        if (contextName == null) {
            contextName = name + version.toString();
        }
        this.contextName = contextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    Domain getDomain() {
        return this.domain;
    }

    void setDomain(Domain domain) {
        this.domain = domain;
    }

    protected Domain checkDomain() {
        Domain result = this.domain;
        if (result == null) {
            throw new IllegalStateException("Domain is not set for " + this);
        }
        return result;
    }

    public boolean isValid() {
        return this.domain != null;
    }

    public String getDomainName() {
        return null;
    }

    public String getDeterminedDomainName() {
        String domainName = this.getDomainName();
        if (domainName == null) {
            domainName = "DefaultDomain";
        }
        return domainName;
    }

    public String getParentDomainName() {
        return null;
    }

    public String getDeterminedParentDomainName() {
        String parentDomain = this.getParentDomainName();
        if (parentDomain == null && !"DefaultDomain".equals(this.getDeterminedDomainName())) {
            return "DefaultDomain";
        }
        return parentDomain;
    }

    ClassLoadingSpace getClassLoadingSpace() {
        return this.space;
    }

    void setClassLoadingSpace(ClassLoadingSpace space) {
        this.space = space;
    }

    public ExportAll getExportAll() {
        return null;
    }

    public ShutdownPolicy getShutdownPolicy() {
        return null;
    }

    public boolean isCascadeShutdown() {
        if (this.cascadeShutdown != null) {
            return this.cascadeShutdown;
        }
        ClassLoader cl = this.getClassLoader();
        if (cl != null && cl instanceof BaseClassLoader) {
            ShutdownPolicy shutdownPolicy = ((BaseClassLoader)cl).getShutdownPolicy();
            return ShutdownPolicy.GARBAGE_COLLECTION != shutdownPolicy;
        }
        return true;
    }

    public ClassFilter getIncluded() {
        return null;
    }

    public ClassFilter getExcluded() {
        return null;
    }

    public ClassFilter getExcludedExport() {
        return null;
    }

    public boolean isImportAll() {
        return false;
    }

    public boolean isJ2seClassLoadingCompliance() {
        return true;
    }

    public ParentPolicy getDeterminedParentPolicy() {
        if (this.isJ2seClassLoadingCompliance()) {
            return ParentPolicy.BEFORE;
        }
        return ParentPolicy.AFTER_BUT_ONLY_JAVA_BEFORE;
    }

    protected boolean isCacheable() {
        return true;
    }

    protected boolean isBlackListable() {
        return true;
    }

    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public void setLifeCycle(LifeCycle lifeCycle) {
        if (lifeCycle != null && lifeCycle.getModule() != this) {
            throw new IllegalArgumentException("Cannot setLifeCycle on module " + this + " it is associated with a different module: " + lifeCycle.getModule());
        }
        this.lifeCycle = lifeCycle;
    }

    static Module getModuleForClassLoader(ClassLoader cl) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        if (cl != null) {
            return modulesByClassLoader.get(cl);
        }
        return null;
    }

    public static Module getModuleForClass(Class<?> clazz) {
        ClassLoader cl;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        if ((cl = Module.getClassLoaderForClass(clazz)) != null) {
            return modulesByClassLoader.get(cl);
        }
        return null;
    }

    public Module getModuleForClass(String className) throws ClassNotFoundException {
        ClassLoader cl;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        if ((cl = this.getClassLoaderForClass(className)) != null) {
            return modulesByClassLoader.get(cl);
        }
        return null;
    }

    protected static ClassLoader getClassLoaderForClass(final Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }

    protected ClassLoader getClassLoaderForClass(String className) throws ClassNotFoundException {
        final Class<?> clazz = this.loadClass(className);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("No classloader for this module " + this);
        }
        return classLoader.loadClass(className);
    }

    public URL getResource(String resourceName) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("No classloader for this module " + this);
        }
        return classLoader.getResource(resourceName);
    }

    public Enumeration<URL> getResources(String resourceName) throws IOException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("No classloader for this module " + this);
        }
        return classLoader.getResources(resourceName);
    }

    protected ClassLoader getClassLoader() {
        return null;
    }

    public void visit(ResourceVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.visit(visitor, visitor.getFilter());
    }

    public void visit(ResourceVisitor visitor, ResourceFilter filter) {
        this.visit(visitor, filter, null, new URL[0]);
    }

    public void visit(ResourceVisitor visitor, ResourceFilter filter, ResourceFilter recurseFilter, URL ... urls) {
        throw new UnsupportedOperationException("The module " + this.getContextName() + " does not support filtering: " + this.getClass().getName());
    }

    public List<? extends DelegateLoader> getDelegates() {
        if (this.requirementDependencies == null || this.requirementDependencies.isEmpty()) {
            return null;
        }
        CopyOnWriteArrayList<DelegateLoader> result = new CopyOnWriteArrayList<DelegateLoader>();
        CopyOnWriteArrayList<DelegateLoader> dynamic = new CopyOnWriteArrayList<DelegateLoader>();
        HashSet<Module> visited = new HashSet<Module>();
        this.addDelegates(this, result, dynamic, visited, false);
        result.addAll(dynamic);
        return result;
    }

    protected List<RequirementDependencyItem> getRequirementDependencyItems() {
        return this.requirementDependencies;
    }

    protected void addDelegates(Module module, List<DelegateLoader> delegates, List<DelegateLoader> dynamic, Set<Module> visited, boolean reExport) {
        DelegateLoader delegate;
        if (visited.contains(module)) {
            return;
        }
        visited.add(module);
        List<RequirementDependencyItem> dependencies = module.getRequirementDependencyItems();
        if (dependencies == null || dependencies.isEmpty()) {
            return;
        }
        LinkedHashMap delegateToRequiredPackages = new LinkedHashMap();
        for (RequirementDependencyItem requirementDependencyItem : dependencies) {
            Requirement requirement = requirementDependencyItem.getRequirement();
            if (reExport && !requirement.isReExport()) continue;
            if (!requirementDependencyItem.isResolved()) {
                throw new IllegalStateException("Item not resolved: " + (Object)((Object)requirementDependencyItem));
            }
            if (requirement.isDynamic()) {
                delegate = this.createLazyDelegateLoader(this.checkDomain(), requirementDependencyItem);
                delegate.setImportType(Module.getImportType(requirement));
                dynamic.add(delegate);
                continue;
            }
            Module iDependOnModule = requirementDependencyItem.getResolvedModule();
            if (iDependOnModule == null) {
                String name = (String)requirementDependencyItem.getIDependOn();
                if (name != null) {
                    iDependOnModule = this.checkDomain().getModule(name);
                }
                if (iDependOnModule == null) {
                    if (requirement.isOptional()) continue;
                    throw new IllegalStateException("Module not found for requirement: " + (Object)((Object)requirementDependencyItem));
                }
            }
            if (requirement.wantReExports()) {
                this.addDelegates(iDependOnModule, delegates, dynamic, visited, true);
            }
            if (iDependOnModule == module) continue;
            if (requirement instanceof PackageRequirement) {
                ArrayList<String> packageNames = (ArrayList<String>)delegateToRequiredPackages.get(iDependOnModule);
                if (packageNames == null) {
                    packageNames = new ArrayList<String>();
                    delegateToRequiredPackages.put(iDependOnModule, packageNames);
                }
                PackageRequirement packageRequirement = (PackageRequirement)requirement;
                packageNames.add(packageRequirement.getName());
                continue;
            }
            DelegateLoader delegate2 = iDependOnModule.getDelegateLoader(module, requirement);
            if (delegate2 == null) {
                throw new IllegalStateException("Cannot obtain delegate for: " + requirement);
            }
            delegate2.setImportType(Module.getImportType(requirement));
            delegates.add(delegate2);
        }
        for (Map.Entry entry : delegateToRequiredPackages.entrySet()) {
            Module iDependOnModule = (Module)entry.getKey();
            delegate = iDependOnModule.getDelegateLoader(module, (List)entry.getValue());
            delegates.add(delegate);
        }
    }

    protected static ImportType getImportType(Requirement requirement) {
        if (requirement instanceof RequirementWithImportType) {
            RequirementWithImportType rwit = (RequirementWithImportType)requirement;
            return rwit.getImportType();
        }
        return ImportType.BEFORE;
    }

    public abstract DelegateLoader createLazyDelegateLoader(Domain var1, RequirementDependencyItem var2);

    public abstract DelegateLoader getDelegateLoader(Module var1, Requirement var2);

    public abstract DelegateLoader getDelegateLoader(Module var1, List<String> var2);

    public Collection<ExportPackage> getExportedPackages() {
        HashSet<ExportPackage> result = new HashSet<ExportPackage>();
        List<Capability> capabilities = this.getCapabilitiesRaw();
        if (capabilities != null && !capabilities.isEmpty()) {
            for (Capability capability : capabilities) {
                if (!(capability instanceof PackageCapability)) continue;
                ExportPackage exportPackage = new ExportPackage(this, (PackageCapability)capability);
                result.add(exportPackage);
            }
        }
        return result;
    }

    public static void refreshModules(Module ... modules) throws Exception {
        if (modules == null || modules.length == 0) {
            HashSet<Module> snapshot = new HashSet<Module>(lazyShutdownModules);
            modules = snapshot.toArray(new Module[snapshot.size()]);
        }
        if (modules.length == 0) {
            return;
        }
        HashSet<LifeCycle> lifecycles = new HashSet<LifeCycle>();
        HashSet<Module> processed = new HashSet<Module>();
        for (Module module : modules) {
            if (module == null) {
                throw new IllegalArgumentException("Null module");
            }
            module.addRefreshModule(lifecycles, processed);
        }
        if (!lifecycles.isEmpty()) {
            LifeCycle[] result = lifecycles.toArray(new LifeCycle[lifecycles.size()]);
            result[0].bounce(result);
        }
    }

    private void addRefreshModule(Set<LifeCycle> lifecycles, Set<Module> processed) {
        if (processed.contains(this)) {
            return;
        }
        processed.add(this);
        if (this.getClassLoader() != null) {
            LifeCycle lifeCycle = this.getLifeCycle();
            if (lifeCycle != null) {
                lifecycles.add(lifeCycle);
            } else {
                log.warn((Object)(this + " has no lifecycle, don't know how to refresh it."));
            }
        }
        if (!this.isCascadeShutdown() && !this.depends.isEmpty()) {
            for (RequirementDependencyItem item : this.depends) {
                item.getModule().addRefreshModule(lifecycles, processed);
            }
        }
    }

    public static boolean resolveModules(Module ... modules) throws Exception {
        if (modules == null || modules.length == 0) {
            return true;
        }
        LifeCycle[] lifeCycles = new LifeCycle[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            Module module = modules[i];
            if (module == null) {
                throw new IllegalArgumentException("Null module");
            }
            LifeCycle lifeCycle = module.getLifeCycle();
            if (lifeCycle == null) {
                throw new IllegalStateException(module + " has no lifecycle, don't know how to resolve it.");
            }
            lifeCycles[i] = lifeCycle;
        }
        return lifeCycles[0].resolve(lifeCycles);
    }

    public boolean canResolve(Requirement requirement) {
        List<Capability> capabilities = this.getCapabilitiesRaw();
        if (capabilities != null && !capabilities.isEmpty()) {
            for (Capability capability : capabilities) {
                if (!capability.resolves(this, requirement)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Capability> getCapabilities() {
        if (this.capabilities != null) {
            return this.capabilities;
        }
        List<Capability> capabilities = this.determineCapabilities();
        if (capabilities == null) {
            capabilities = this.defaultCapabilities();
        }
        capabilities = this.checkDomain().mergeGlobalCapabilities(capabilities);
        this.capabilities = capabilities;
        return capabilities;
    }

    protected List<Capability> determineCapabilities() {
        return null;
    }

    protected List<Capability> defaultCapabilities() {
        CopyOnWriteArrayList<Capability> capabilities = new CopyOnWriteArrayList<Capability>();
        ClassLoadingMetaDataFactory factory = ClassLoadingMetaDataFactory.getInstance();
        Capability capability = factory.createModule(this.getName(), this.getVersion());
        capabilities.add(capability);
        return capabilities;
    }

    List<Capability> getCapabilitiesRaw() {
        return this.capabilities;
    }

    public String[] getPackageNames() {
        List<String> packageNames = this.determinePackageNames(true);
        return packageNames.toArray(new String[packageNames.size()]);
    }

    public List<String> determinePackageNames(boolean optional) {
        List<Requirement> requirements;
        List<String> packageNames = Collections.emptyList();
        List<Capability> capabilities = this.getCapabilities();
        if (capabilities != null && !capabilities.isEmpty()) {
            for (Capability capability : capabilities) {
                ExportPackages exported;
                Set<String> exportPackages;
                if (!(capability instanceof ExportPackages) || (exportPackages = (exported = (ExportPackages)((Object)capability)).getPackageNames(this)) == null) continue;
                if (packageNames.isEmpty()) {
                    packageNames = new ArrayList<String>();
                }
                packageNames.addAll(exportPackages);
            }
        }
        if ((requirements = this.getRequirements()) != null && !requirements.isEmpty()) {
            for (Requirement requirement : this.getRequirements()) {
                OptionalPackages exported;
                Set<String> optionalPackages;
                if (optional || !(requirement instanceof OptionalPackages) || (optionalPackages = (exported = (OptionalPackages)((Object)requirement)).getOptionalPackageNames(this)) == null || packageNames.isEmpty()) continue;
                packageNames.removeAll(optionalPackages);
            }
        }
        return packageNames;
    }

    public PackageCapability getExportCapability(String exportedPackage) {
        List<Capability> capabilities = this.getCapabilities();
        if (capabilities != null && !capabilities.isEmpty()) {
            for (Capability capability : capabilities) {
                if (!(capability instanceof PackageCapability)) continue;
                PackageCapability exported = (PackageCapability)capability;
                for (String packageName : exported.getPackageNames(this)) {
                    if (!packageName.equals(exportedPackage)) continue;
                    return exported;
                }
            }
        }
        return null;
    }

    public ControllerState getClassLoaderState() {
        return ControllerState.INSTALLED;
    }

    public List<Requirement> getRequirements() {
        if (this.requirements != null) {
            return this.requirements;
        }
        List<Requirement> requirements = this.determineRequirements();
        this.requirements = requirements;
        return requirements;
    }

    public List<Requirement> determineRequirements() {
        return Collections.emptyList();
    }

    List<Requirement> getRequirementsRaw() {
        return this.requirements;
    }

    public URL getDynamicClassRoot() {
        return null;
    }

    List<RequirementDependencyItem> getDependencies() {
        return this.requirementDependencies;
    }

    protected void createDependencies() {
        ControllerState classLoaderState = this.getClassLoaderState();
        List<Requirement> requirements = this.getRequirements();
        if (requirements != null) {
            this.requirementDependencies = new ArrayList<RequirementDependencyItem>();
            for (Requirement requirement : requirements) {
                RequirementDependencyItem item = requirement instanceof PackageRequirement && ((PackageRequirement)requirement).isWildcard() ? new WildcardRequirementDependencyItem(this, requirement, classLoaderState, classLoaderState) : new RequirementDependencyItem(this, requirement, classLoaderState, classLoaderState);
                this.addIDependOn(item);
                this.requirementDependencies.add(item);
            }
        }
    }

    protected void removeDependencies() {
        if (this.requirementDependencies != null && !this.requirementDependencies.isEmpty()) {
            for (RequirementDependencyItem item : this.requirementDependencies) {
                this.removeIDependOn(item);
            }
        }
        this.requirementDependencies = null;
    }

    protected void unresolveDependencies() {
        Controller controller = this.context.getController();
        if (this.requirementDependencies != null && !this.requirementDependencies.isEmpty()) {
            for (RequirementDependencyItem item : this.requirementDependencies) {
                item.unresolved(controller);
            }
        }
    }

    protected ControllerContext getControllerContext() {
        return this.context;
    }

    protected void setControllerContext(ControllerContext context) {
        this.context = context;
    }

    protected void addIDependOn(RequirementDependencyItem item) {
        if (this.context == null) {
            throw new IllegalStateException("No controller context");
        }
        this.context.getDependencyInfo().addIDependOn((DependencyItem)item);
    }

    protected void removeIDependOn(RequirementDependencyItem item) {
        if (this.context == null) {
            throw new IllegalStateException("No controller context");
        }
        item.setResolved(ResolvedState.UNRESOLVED);
        DependencyInfo dependencyInfo = this.context.getDependencyInfo();
        dependencyInfo.removeIDependOn((DependencyItem)item);
    }

    protected void removeDependsOnMe(RequirementDependencyItem item) {
        if (this.context == null) {
            return;
        }
        DependencyInfo dependencyInfo = this.context.getDependencyInfo();
        dependencyInfo.removeDependsOnMe((DependencyItem)item);
    }

    void addDepends(RequirementDependencyItem item) {
        this.depends.add(item);
    }

    void removeDepends(RequirementDependencyItem item) {
        this.depends.remove((Object)item);
        if (this.depends.isEmpty()) {
            lazyShutdownModules.remove(this);
        }
    }

    public Collection<Module> getImportingModules(Class<? extends Requirement> type) {
        HashSet<Module> result = new HashSet<Module>();
        if (!this.depends.isEmpty()) {
            for (RequirementDependencyItem item : this.depends) {
                Requirement requirement = item.getRequirement();
                if (type != null && !type.isInstance(requirement)) continue;
                result.add(item.getModule());
            }
        }
        return result;
    }

    protected Module resolveModule(RequirementDependencyItem dependency, boolean resolveSpace) {
        ClassLoadingSpace space = this.getClassLoadingSpace();
        if (resolveSpace && space != null) {
            space.resolve(this);
        }
        Requirement requirement = dependency.getRequirement();
        return this.checkDomain().resolveModule(this, requirement);
    }

    public void release() {
        Domain domain = this.domain;
        if (domain != null) {
            domain.removeModule(this);
        }
        this.reset();
    }

    public void reset() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader != null) {
            Module.unregisterModuleClassLoader(this, classLoader);
        }
        this.capabilities = null;
        this.requirements = null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Module)) {
            return false;
        }
        return super.equals(obj);
    }

    private void enableLazyShutdown() {
        Set items;
        DependencyInfo info;
        ControllerContext ctx = this.getControllerContext();
        if (ctx != null && (info = ctx.getDependencyInfo()) != null && (items = info.getDependsOnMe(RequirementDependencyItem.class)) != null && !items.isEmpty()) {
            for (DependencyItem item : items) {
                info.removeDependsOnMe(item);
            }
        }
    }
}

