/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.sqlite;

import android.content.ContentValues;
import android.database.Cursor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.capedwarf.common.sql.Column;
import org.jboss.capedwarf.common.sql.Key;
import org.jboss.capedwarf.common.sql.OnDelete;
import org.jboss.capedwarf.common.sql.OnInsert;
import org.jboss.capedwarf.common.sql.OnLoad;
import org.jboss.capedwarf.common.sql.OnUpdate;
import org.jboss.capedwarf.sqlite.AbstractSQLiteEntityModel;
import org.jboss.capedwarf.sqlite.SQLiteTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionSQLiteEntityModel<T>
extends AbstractSQLiteEntityModel<T> {
    private String key;
    private Map<String, Property> propertys = new LinkedHashMap<String, Property>();

    public ReflectionSQLiteEntityModel(Class<T> entityClass) throws Exception {
        super(entityClass);
        this.init();
    }

    protected void init() throws Exception {
        Method[] ms;
        OnDelete onDelete;
        OnUpdate onUpdate;
        OnLoad onLoad;
        OnInsert onInsert = this.entityClass.getAnnotation(OnInsert.class);
        if (onInsert != null) {
            this.putListener(OnInsert.class.getSimpleName(), this.loadEntityListener(onInsert.value()));
        }
        if ((onLoad = this.entityClass.getAnnotation(OnLoad.class)) != null) {
            this.putListener(OnLoad.class.getSimpleName(), this.loadEntityListener(onLoad.value()));
        }
        if ((onUpdate = this.entityClass.getAnnotation(OnUpdate.class)) != null) {
            this.putListener(OnUpdate.class.getSimpleName(), this.loadEntityListener(onUpdate.value()));
        }
        if ((onDelete = this.entityClass.getAnnotation(OnDelete.class)) != null) {
            this.putListener(OnDelete.class.getSimpleName(), this.loadEntityListener(onDelete.value()));
        }
        for (Method m : ms = this.entityClass.getMethods()) {
            Column column = m.getAnnotation(Column.class);
            if (column != null) {
                boolean setter = false;
                String upper = null;
                Class<?> type = null;
                String methodName = m.getName();
                Class<?>[] pt = m.getParameterTypes();
                if (pt.length == 0) {
                    if (methodName.startsWith("get")) {
                        upper = methodName.substring(3);
                        type = m.getReturnType();
                    } else if (methodName.startsWith("is")) {
                        upper = methodName.substring(2);
                        type = m.getReturnType();
                    }
                }
                if (upper == null && methodName.startsWith("set") && pt.length == 1) {
                    upper = methodName.substring(3);
                    type = pt[0];
                    setter = true;
                }
                if (upper == null) {
                    throw new IllegalArgumentException("Column is not on getter/setter: " + m);
                }
                if (setter) {
                    this.entityClass.getMethod((type == Boolean.TYPE ? "is" : "get") + upper, new Class[0]);
                } else {
                    this.entityClass.getMethod("set" + upper, type);
                }
                String name = column.name().length() > 0 ? column.name() : upper.toLowerCase();
                this.propertys.put(name, new Property(upper, type, column.defaultValue()));
            }
            this.readKey(m);
        }
        if (this.getKey() == null) {
            throw new IllegalArgumentException("Missing @Key: " + this.entityClass);
        }
        if (this.propertys.isEmpty()) {
            throw new IllegalArgumentException("Empty propertys: " + this.entityClass);
        }
    }

    protected void readKey(Method m) throws NoSuchMethodException {
        Key key = m.getAnnotation(Key.class);
        if (key != null) {
            if (this.key != null) {
                throw new IllegalArgumentException("Key already set: " + this.key);
            }
            String keyName = key.value();
            Method keyGetter = this.entityClass.getMethod("get" + ReflectionSQLiteEntityModel.toCapitalize(keyName), new Class[0]);
            Class<?> rt = keyGetter.getReturnType();
            if (!(rt == Long.class || rt == Long.TYPE)) {
                throw new IllegalArgumentException("Only long/Long keys allowed.");
            }
            this.key = keyName;
        }
    }

    protected static String toCapitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Set<String> getColumns() {
        return this.propertys.keySet();
    }

    @Override
    public String[] getColumnsDescription() {
        String[] result = new String[this.propertys.size()];
        int i = 0;
        for (Map.Entry<String, Property> entry : this.propertys.entrySet()) {
            Property value = entry.getValue();
            result[i++] = entry.getKey() + " " + value.getSQLType() + value.getDefaultValue();
        }
        return result;
    }

    @Override
    public Long getKeyValue(T entity) {
        if (this.key == null || entity == null) {
            return null;
        }
        try {
            Method m = this.entityClass.getMethod("get" + ReflectionSQLiteEntityModel.toCapitalize(this.key), new Class[0]);
            return (Long)m.invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setKeyValue(T entity, Long id) {
        if (this.key == null || entity == null) {
            return;
        }
        try {
            Method m = this.entityClass.getMethod("set" + ReflectionSQLiteEntityModel.toCapitalize(this.key), Long.class);
            m.invoke(entity, id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<T> readValues(Cursor cursor) {
        ArrayList results = new ArrayList();
        do {
            try {
                Object instance = this.entityClass.newInstance();
                String[] columns = cursor.getColumnNames();
                for (int i = 0; i < columns.length; ++i) {
                    Object value;
                    String column = columns[i];
                    if (column.equals(this.getKey())) {
                        this.setKeyValue(instance, cursor.getLong(i));
                        continue;
                    }
                    Property property = this.propertys.get(column);
                    if (property == null) {
                        throw new IllegalArgumentException("No such matching property: " + column);
                    }
                    Class type = property.type;
                    if (cursor.isNull(i)) {
                        value = null;
                    } else if (type == String.class) {
                        value = cursor.getString(i);
                    } else if (type == Byte.class || type == Byte.TYPE) {
                        value = cursor.getInt(i);
                    } else if (type == Short.class || type == Short.TYPE) {
                        value = cursor.getShort(i);
                    } else if (type == Integer.class || type == Integer.TYPE) {
                        value = cursor.getInt(i);
                    } else if (type == Long.class || type == Long.TYPE) {
                        value = cursor.getLong(i);
                    } else if (type == Float.class || type == Float.TYPE) {
                        value = Float.valueOf(cursor.getFloat(i));
                    } else if (type == Double.class || type == Double.TYPE) {
                        value = cursor.getDouble(i);
                    } else if (type == Boolean.class || type == Boolean.TYPE) {
                        value = cursor.getInt(i) > 0;
                    } else if (type == byte[].class) {
                        value = cursor.getBlob(i);
                    } else if (Enum.class.isAssignableFrom(type)) {
                        value = this.toEnum(type, cursor.getInt(i));
                    } else {
                        throw new IllegalArgumentException("Cannot support value type: " + property);
                    }
                    property.setValue(instance, value);
                }
                results.add(instance);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } while (cursor.moveToNext());
        return results;
    }

    @Override
    public ContentValues getContentValues(T entity) {
        if (entity == null) {
            return new ContentValues(0);
        }
        ContentValues cv = new ContentValues(this.propertys.size());
        for (Map.Entry<String, Property> entry : this.propertys.entrySet()) {
            String key = entry.getKey();
            Property property = entry.getValue();
            Object value = property.getValue(entity);
            if (value == null) {
                cv.putNull(key);
                continue;
            }
            if (value instanceof String) {
                cv.put(key, (String)value);
                continue;
            }
            if (value instanceof Byte) {
                cv.put(key, (Byte)value);
                continue;
            }
            if (value instanceof Short) {
                cv.put(key, (Short)value);
                continue;
            }
            if (value instanceof Integer) {
                cv.put(key, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                cv.put(key, (Long)value);
                continue;
            }
            if (value instanceof Float) {
                cv.put(key, (Float)value);
                continue;
            }
            if (value instanceof Double) {
                cv.put(key, (Double)value);
                continue;
            }
            if (value instanceof Boolean) {
                cv.put(key, (Boolean)value);
                continue;
            }
            if (value instanceof byte[]) {
                cv.put(key, (byte[])value);
                continue;
            }
            if (value instanceof Enum) {
                cv.put(key, Integer.valueOf(((Enum)value).ordinal()));
                continue;
            }
            throw new IllegalArgumentException("Cannot support value type: " + property);
        }
        return cv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Property {
        private String upper;
        private Class<?> type;
        private Method getter;
        private Method setter;
        private String defaultValue;

        private Property(String upper, Class<?> type, String defaultValue) {
            this.upper = upper;
            this.type = type;
            if (defaultValue != null && defaultValue.length() > 0) {
                this.defaultValue = " DEFAULT " + defaultValue;
            }
        }

        public Object getValue(T entity) {
            try {
                if (this.getter == null) {
                    this.getter = ReflectionSQLiteEntityModel.this.entityClass.getMethod((this.type == Boolean.TYPE ? "is" : "get") + this.upper, new Class[0]);
                }
                return this.getter.invoke(entity, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(this.toString() + " -> " + entity, e);
            }
        }

        public void setValue(T instance, Object value) throws Exception {
            try {
                if (this.setter == null) {
                    this.setter = ReflectionSQLiteEntityModel.this.entityClass.getMethod("set" + this.upper, this.type);
                }
                this.setter.invoke(instance, value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(this.toString() + " -> " + instance + "::" + value, e);
            }
        }

        public String getSQLType() {
            return SQLiteTypes.getSQLType(this.type).name();
        }

        public String getDefaultValue() {
            return this.defaultValue != null ? this.defaultValue : "";
        }

        public String toString() {
            return ReflectionSQLiteEntityModel.this.entityClass + "$" + this.upper.toLowerCase() + "#" + this.type;
        }
    }
}

