/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.sqlite;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SQLiteTypes {
    NONE,
    INTEGER,
    TEXT,
    REAL,
    NUMERIC,
    BLOB;

    private static final Map<Class<?>, SQLiteTypes> affinities;

    public static SQLiteTypes getSQLType(Class<?> type) {
        if (type == null) {
            return NONE;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return INTEGER;
        }
        SQLiteTypes affinity = affinities.get(type);
        return affinity != null ? affinity : NONE;
    }

    static {
        affinities = new HashMap();
        affinities.put(String.class, TEXT);
        affinities.put(Byte.class, INTEGER);
        affinities.put(Byte.TYPE, INTEGER);
        affinities.put(Short.class, INTEGER);
        affinities.put(Short.TYPE, INTEGER);
        affinities.put(Integer.class, INTEGER);
        affinities.put(Integer.TYPE, INTEGER);
        affinities.put(Long.class, INTEGER);
        affinities.put(Long.TYPE, INTEGER);
        affinities.put(Float.class, REAL);
        affinities.put(Float.TYPE, REAL);
        affinities.put(Double.class, REAL);
        affinities.put(Double.TYPE, REAL);
        affinities.put(Boolean.class, INTEGER);
        affinities.put(Boolean.TYPE, INTEGER);
        affinities.put(byte[].class, BLOB);
    }
}

