/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.sqlite;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.capedwarf.common.dto.Identity;
import org.jboss.capedwarf.common.sql.SQLObject;
import org.jboss.capedwarf.sqlite.AbstractSQLiteEntityModel;
import org.jboss.capedwarf.sqlite.ColumnMapper;
import org.jboss.capedwarf.sqlite.EntityListener;
import org.jboss.capedwarf.sqlite.Phase;
import org.jboss.capedwarf.sqlite.ReflectionSQLiteEntityModel;
import org.jboss.capedwarf.sqlite.SQLObjectSQLiteEntityModel;
import org.jboss.capedwarf.sqlite.SQLiteEntityModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSQLiteOpenHelper
extends SQLiteOpenHelper {
    private static final String TAG = "AbstractSQLiteOpenHelper";
    private static final Map<Class<?>, SQLiteEntityModel> models = new ConcurrentHashMap();
    private static ThreadLocal<SQLiteDatabase> dbTL = new ThreadLocal();
    private volatile boolean initialized;

    public AbstractSQLiteOpenHelper(Context context, String name, int version) {
        super(context, name, null, version);
    }

    public void onOpen(SQLiteDatabase db) {
        if (!this.initialized && !db.isReadOnly()) {
            this.initialized = true;
            this.onCreate(db);
        }
    }

    public void onCreate(SQLiteDatabase db) {
        for (SQLiteEntityModel em : models.values()) {
            String table = em.getTable();
            if (this.tableExists(db, em, true)) continue;
            StringBuilder builder = new StringBuilder("CREATE TABLE ");
            builder.append(table).append(" (");
            String key = em.getKey();
            builder.append(key).append(" INTEGER PRIMARY KEY, ");
            String[] columns = em.getColumnsDescription();
            if (columns == null || columns.length == 0) {
                throw new IllegalArgumentException("Illegale columns: " + em);
            }
            builder.append(columns[0]);
            for (int i = 1; i < columns.length; ++i) {
                builder.append(", ").append(columns[i]);
            }
            builder.append(")");
            String sql = builder.toString();
            Log.i((String)TAG, (String)("SQL ==> " + sql));
            db.execSQL(sql);
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.i((String)TAG, (String)("Upgrading database from version " + oldVersion + " to " + newVersion + ", which will destroy all old data"));
        for (SQLiteEntityModel em : models.values()) {
            String sql = "DROP TABLE IF EXISTS " + em.getTable();
            Log.i((String)TAG, (String)("SQL ==> " + sql));
            db.execSQL(sql);
        }
        this.onCreate(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tableExists(SQLiteDatabase db, SQLiteEntityModel em, boolean alter) {
        String table = em.getTable();
        Cursor cursor = db.query("sqlite_master", new String[]{"sql"}, "tbl_name = ?", new String[]{table}, null, null, null);
        if (cursor == null) {
            return false;
        }
        try {
            boolean exists;
            int count = cursor.getCount();
            boolean bl = exists = count > 0;
            if (exists && alter) {
                cursor.moveToFirst();
                String sql = cursor.getString(0);
                String[] columns = em.getKeyAndColumns();
                String[] desc = em.getColumnsDescription();
                for (int i = 0; i < columns.length; ++i) {
                    if (sql.contains(columns[i])) continue;
                    db.execSQL("ALTER TABLE " + table + " ADD COLUMN " + desc[i - 1]);
                }
            }
            boolean bl2 = exists;
            return bl2;
        }
        finally {
            cursor.close();
        }
    }

    public static <T> SQLiteEntityModel<T> getEntityModel(Class<T> entityClass) {
        ReflectionSQLiteEntityModel em = models.get(entityClass);
        if (em == null) {
            try {
                em = SQLObject.class.isAssignableFrom(entityClass) ? new SQLObjectSQLiteEntityModel<T>(entityClass) : new ReflectionSQLiteEntityModel<T>(entityClass);
                models.put(entityClass, em);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return em;
    }

    public static <T> SQLiteEntityModel<T> putEntityModel(Class<T> clazz, SQLiteEntityModel<T> em) {
        if (em == null) {
            return models.remove(clazz);
        }
        return models.put(clazz, em);
    }

    public static <T> T getSingleResult(List<T> results) {
        return results == null || results.isEmpty() ? null : (T)results.get(0);
    }

    public static SQLiteDatabase getDB() {
        SQLiteDatabase db = dbTL.get();
        if (db == null) {
            throw new IllegalArgumentException("Missing DB, forgot begin()?");
        }
        return db;
    }

    public void begin() {
        SQLiteDatabase db = this.getWritableDatabase();
        dbTL.set(db);
        db.beginTransaction();
    }

    public void commit() {
        SQLiteDatabase db = AbstractSQLiteOpenHelper.getDB();
        db.setTransactionSuccessful();
    }

    public void rollback() {
    }

    public void end() {
        SQLiteDatabase db = AbstractSQLiteOpenHelper.getDB();
        dbTL.remove();
        db.endTransaction();
    }

    public boolean initialize(int currentVersion) {
        boolean isNew;
        SQLiteDatabase db = this.getWritableDatabase();
        int version = db.getVersion();
        boolean bl = isNew = currentVersion > version;
        if (isNew) {
            this.onUpgrade(db, version, currentVersion);
        }
        return isNew;
    }

    public <T> T load(Class<T> entityClass, long pk) {
        return AbstractSQLiteOpenHelper.load(this.getReadableDatabase(), entityClass, pk);
    }

    public static long persist(SQLObject entity) {
        if (entity == null) {
            return -1L;
        }
        SQLiteDatabase db = AbstractSQLiteOpenHelper.getDB();
        return AbstractSQLiteOpenHelper.insertOrUpdate(db, entity);
    }

    public static int update(SQLObject entity) {
        if (entity == null) {
            return 0;
        }
        SQLiteDatabase db = AbstractSQLiteOpenHelper.getDB();
        return AbstractSQLiteOpenHelper.update(db, AbstractSQLiteOpenHelper.getEntityModel(entity.getClass()), entity, entity.getPk(), "pk");
    }

    public static int delete(SQLObject entity) {
        SQLiteDatabase db = AbstractSQLiteOpenHelper.getDB();
        return AbstractSQLiteOpenHelper.delete(db, entity, "pk = ?", entity.getPk());
    }

    public <T> List<T> select(Class<T> entityClass, String selection, String[] selectionArgs, String orderBy, String limit) {
        SQLiteDatabase db = this.getReadableDatabase();
        return AbstractSQLiteOpenHelper.select(db, entityClass, selection, selectionArgs, orderBy, limit);
    }

    public <T> List select(Class<T> entityClass, List<ColumnMapper> mappers, String selection, String[] selectionArgs, String orderBy, String limit) {
        SQLiteDatabase db = this.getReadableDatabase();
        return AbstractSQLiteOpenHelper.select(db, entityClass, mappers, selection, selectionArgs, orderBy, limit);
    }

    public <T> List<Long> pks(Class<T> entityClass, String selection, String[] selectionArgs, String orderBy, String limit) {
        SQLiteDatabase db = this.getReadableDatabase();
        return AbstractSQLiteOpenHelper.pks(db, entityClass, selection, selectionArgs, orderBy, limit);
    }

    public int count(Class<?> entityClass, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.getReadableDatabase();
        return AbstractSQLiteOpenHelper.count(db, entityClass, selection, selectionArgs);
    }

    public static <T> T load(SQLiteDatabase db, Class<T> entityClass, Long pk) {
        SQLiteEntityModel<T> em = AbstractSQLiteOpenHelper.getEntityModel(entityClass);
        return AbstractSQLiteOpenHelper.getSingleResult(AbstractSQLiteOpenHelper.select(db, em, em.getKey() + " = ?", AbstractSQLiteOpenHelper.toSelectionArgs(pk), null, "1"));
    }

    public static <T extends Identity> T loadIdentity(SQLiteDatabase db, Class<T> entityClass, Long id) {
        SQLiteEntityModel<T> em = AbstractSQLiteOpenHelper.getEntityModel(entityClass);
        return (T)((Identity)AbstractSQLiteOpenHelper.getSingleResult(AbstractSQLiteOpenHelper.select(db, em, "id = ?", AbstractSQLiteOpenHelper.toSelectionArgs(id), null, "1")));
    }

    public static <T> List<T> select(SQLiteDatabase db, Class<T> entityClass, String selection, Object selectionArg) {
        return AbstractSQLiteOpenHelper.select(db, entityClass, selection, AbstractSQLiteOpenHelper.toSelectionArgs(selectionArg), null, null);
    }

    public static <T> List<T> select(SQLiteDatabase db, Class<T> entityClass, String selection, String[] selectionArgs, String orderBy, String limit) {
        SQLiteEntityModel<T> em = AbstractSQLiteOpenHelper.getEntityModel(entityClass);
        return AbstractSQLiteOpenHelper.select(db, em, selection, selectionArgs, orderBy, limit);
    }

    public static <T> List select(SQLiteDatabase db, Class<T> entityClass, List<ColumnMapper> mappers, String selection, String[] selectionArgs, String orderBy, String limit) {
        SQLiteEntityModel<T> em = AbstractSQLiteOpenHelper.getEntityModel(entityClass);
        return AbstractSQLiteOpenHelper.select(db, em.getTable(), mappers, selection, selectionArgs, orderBy, limit);
    }

    public static <T> List<Long> pks(SQLiteDatabase db, Class<T> entityClass, String selection, String[] selectionArgs, String orderBy, String limit) {
        final SQLiteEntityModel<T> em = AbstractSQLiteOpenHelper.getEntityModel(entityClass);
        ColumnMapper<Long> idMapper = new ColumnMapper<Long>(){

            @Override
            public String column() {
                return em.getKey();
            }

            @Override
            public Long value(Cursor cursor, int i) {
                return cursor.getLong(i);
            }
        };
        return AbstractSQLiteOpenHelper.select(db, em.getTable(), Collections.singletonList(idMapper), selection, selectionArgs, orderBy, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List select(SQLiteDatabase db, String table, List<ColumnMapper> mappers, String selection, String[] selectionArgs, String orderBy, String limit) {
        int n = mappers.size();
        if (n == 0) {
            throw new IllegalArgumentException("Empty mappers!");
        }
        String[] columns = new String[n];
        for (int i = 0; i < n; ++i) {
            columns[i] = mappers.get(i).column();
        }
        Cursor cursor = db.query(table, columns, selection, selectionArgs, null, null, orderBy, limit);
        if ((cursor = AbstractSQLiteEntityModel.toFirst(cursor)) == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            do {
                if (n > 1) {
                    Object[] array = new Object[n];
                    for (int index = 0; index < n; ++index) {
                        array[index] = mappers.get(index).value(cursor, index);
                    }
                    result.add(array);
                    continue;
                }
                result.add(mappers.get(0).value(cursor, 0));
            } while (cursor.moveToNext());
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            cursor.close();
        }
    }

    public static <T> List<T> select(SQLiteDatabase db, SQLiteEntityModel<T> em, String selection, String[] selectionArgs, String orderBy, String limit) {
        EntityListener listener = em.onLoad();
        if (listener != null) {
            listener.action(db, null, Phase.BEFORE);
        }
        Cursor cursor = db.query(em.getTable(), em.getKeyAndColumns(), selection, selectionArgs, null, null, orderBy, limit);
        List<T> result = em.readCursor(cursor);
        if (listener != null && !result.isEmpty()) {
            for (T entity : result) {
                listener.action(db, entity, Phase.AFTER);
            }
        }
        return result;
    }

    public static long insertOrUpdate(SQLiteDatabase db, SQLObject entity) {
        return AbstractSQLiteOpenHelper.insertOrUpdate(db, entity, entity.getPk(), "pk");
    }

    public static long insertOrUpdate(SQLiteDatabase db, Object entity, Long pk, String key) {
        SQLiteEntityModel<?> em = AbstractSQLiteOpenHelper.getEntityModel(entity.getClass());
        if (pk == null) {
            pk = AbstractSQLiteOpenHelper.insert(db, em, entity);
        } else {
            AbstractSQLiteOpenHelper.update(db, em, entity, pk, key);
        }
        return pk != null ? pk : -1L;
    }

    public static Long insert(SQLiteDatabase db, SQLiteEntityModel em, Object entity) {
        EntityListener listener = em.onInsert();
        if (listener != null) {
            listener.action(db, entity, Phase.BEFORE);
        }
        Long pk = db.insert(em.getTable(), null, em.getContentValues(entity));
        em.setKeyValue(entity, pk);
        if (pk < 0L) {
            Log.v((String)TAG, (String)("Error inserting new entity: " + entity));
        }
        if (listener != null && pk != -1L) {
            listener.action(db, entity, Phase.AFTER);
        }
        return pk;
    }

    public static int update(SQLiteDatabase db, SQLiteEntityModel em, Object entity, Long pk, String key) {
        int result;
        EntityListener listener = em.onUpdate();
        if (listener != null) {
            listener.action(db, entity, Phase.BEFORE);
        }
        if ((result = db.update(em.getTable(), em.getContentValues(entity), key + " = ?", AbstractSQLiteOpenHelper.toSelectionArgs(pk))) <= 0) {
            Log.v((String)TAG, (String)("No matching entity to update: " + em + ", pk=" + pk));
        }
        if (listener != null && result > 0) {
            listener.action(db, entity, Phase.AFTER);
        }
        return result;
    }

    public static int delete(SQLiteDatabase db, Object entity, String selection, Object selectionArg) {
        SQLiteEntityModel<?> em = AbstractSQLiteOpenHelper.getEntityModel(entity.getClass());
        EntityListener listener = em.onDelete();
        if (listener != null) {
            listener.action(db, entity, Phase.BEFORE);
        }
        int result = db.delete(em.getTable(), selection, AbstractSQLiteOpenHelper.toSelectionArgs(selectionArg));
        if (listener != null && result > 0) {
            listener.action(db, entity, Phase.AFTER);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int count(SQLiteDatabase db, Class<?> entityClass, String selection, String[] selectionArgs) {
        SQLiteEntityModel<?> em = AbstractSQLiteOpenHelper.getEntityModel(entityClass);
        Cursor cursor = db.query(em.getTable(), new String[]{em.getKey()}, selection, selectionArgs, null, null, null);
        try {
            int n = cursor != null ? cursor.getCount() : 0;
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public static String toQuery(Iterable arg) {
        StringBuilder builder = new StringBuilder();
        for (Object i : arg) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append("?");
        }
        return builder.toString();
    }

    public static String[] toSelectionArgs(Object ... args) {
        if (args == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Object arg : args) {
            if (arg instanceof Iterable) {
                for (Object it : (Iterable)arg) {
                    results.add(AbstractSQLiteOpenHelper.toSelectionArg(it));
                }
                continue;
            }
            results.add(AbstractSQLiteOpenHelper.toSelectionArg(arg));
        }
        return results.toArray(new String[results.size()]);
    }

    private static String toSelectionArg(Object arg) {
        if (Boolean.class.isInstance(arg)) {
            arg = Boolean.TRUE.equals(arg) ? 1 : 0;
        } else if (Enum.class.isInstance(arg)) {
            arg = ((Enum)arg).ordinal();
        }
        return arg == null ? null : String.valueOf(arg);
    }
}

