/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.sqlite;

import android.database.Cursor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.capedwarf.common.sql.OnDelete;
import org.jboss.capedwarf.common.sql.OnInsert;
import org.jboss.capedwarf.common.sql.OnLoad;
import org.jboss.capedwarf.common.sql.OnUpdate;
import org.jboss.capedwarf.common.sql.Table;
import org.jboss.capedwarf.sqlite.EntityListener;
import org.jboss.capedwarf.sqlite.SQLiteEntityModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSQLiteEntityModel<T>
implements SQLiteEntityModel<T> {
    protected Class<T> entityClass;
    private Map<String, EntityListener> listeners;
    private volatile String table;
    private volatile String[] keyAndColumns;

    protected AbstractSQLiteEntityModel(Class<T> entityClass) throws Exception {
        if (entityClass == null) {
            throw new IllegalArgumentException("Null entity class");
        }
        this.entityClass = entityClass;
        this.listeners = new ConcurrentHashMap<String, EntityListener>();
    }

    @Override
    public String getTable() {
        if (this.table == null) {
            Table t = this.entityClass.getAnnotation(Table.class);
            this.table = t != null && t.name().length() > 0 ? t.name() : this.entityClass.getSimpleName();
        }
        return this.table;
    }

    protected abstract Set<String> getColumns();

    @Override
    public String[] getKeyAndColumns() {
        if (this.keyAndColumns == null) {
            LinkedHashSet<String> all = new LinkedHashSet<String>();
            all.add(this.getKey());
            all.addAll(this.getColumns());
            this.keyAndColumns = all.toArray(new String[all.size()]);
        }
        return this.keyAndColumns;
    }

    static Cursor toFirst(Cursor cursor) {
        if (cursor == null) {
            return null;
        }
        if (!cursor.moveToFirst()) {
            cursor.close();
            return null;
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> readCursor(Cursor cursor) {
        if ((cursor = AbstractSQLiteEntityModel.toFirst(cursor)) == null) {
            return Collections.emptyList();
        }
        try {
            List<T> list = this.readValues(cursor);
            return list;
        }
        finally {
            cursor.close();
        }
    }

    protected abstract List<T> readValues(Cursor var1);

    protected EntityListener loadEntityListener(String className) {
        try {
            Class<?> elc = this.getClass().getClassLoader().loadClass(className);
            Object result = elc.newInstance();
            if (!EntityListener.class.isInstance(result)) {
                throw new IllegalArgumentException("Not an EntityListener: " + className);
            }
            return (EntityListener)result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void putListener(String key, EntityListener listener) {
        if (listener == null) {
            this.listeners.remove(key);
        } else {
            this.listeners.put(key, listener);
        }
    }

    @Override
    public EntityListener onInsert() {
        return this.listeners.get(OnInsert.class.getSimpleName());
    }

    @Override
    public EntityListener onLoad() {
        return this.listeners.get(OnLoad.class.getSimpleName());
    }

    @Override
    public EntityListener onUpdate() {
        return this.listeners.get(OnUpdate.class.getSimpleName());
    }

    @Override
    public EntityListener onDelete() {
        return this.listeners.get(OnDelete.class.getSimpleName());
    }

    protected Object toEnum(Class<?> enumClass, int ordinal) {
        try {
            Method m = enumClass.getMethod("values", new Class[0]);
            Object[] values = (Object[])m.invoke(null, new Object[0]);
            return values[ordinal];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.entityClass.getSimpleName();
    }
}

