/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.collection;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;
import org.jboss.cache.pojo.util.AopUtil;
import org.jboss.cache.pojo.util.CacheApiUtil;
import org.jboss.cache.pojo.util.Null;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedSetImpl
extends AbstractSet {
    private PojoCacheImpl pojoCache;
    private Cache<Object, Object> cache;
    private AbstractCollectionInterceptor interceptor;

    public CachedSetImpl(PojoCacheImpl cache, AbstractCollectionInterceptor interceptor) {
        this.pojoCache = cache;
        this.cache = this.pojoCache.getCache();
        this.interceptor = interceptor;
    }

    private Set<Node> getNodeChildren() {
        return CacheApiUtil.getNodeChildren(this.cache, this.getFqn());
    }

    private Fqn getFqn() {
        return this.interceptor.getFqn();
    }

    @Override
    public boolean add(Object o) {
        o = Null.toNullObject(o);
        int hashCode = o.hashCode();
        int size = this.size();
        for (int i = 0; i < size + 1; ++i) {
            String key = this.toLong(hashCode, i);
            Object o2 = this.getNoUnmask(key);
            if (o2 == null) {
                this.attach(key, o, true);
                return true;
            }
            if (!o.equals(o2)) continue;
            return false;
        }
        throw new CacheException();
    }

    @Override
    public void clear() {
        Set<Node> children = this.getNodeChildren();
        for (Node n : children) {
            this.pojoCache.detach(n.getFqn());
        }
    }

    @Override
    public boolean contains(Object o) {
        o = Null.toNullObject(o);
        int hashCode = o.hashCode();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String key = this.toLong(hashCode, i);
            Object o2 = this.getNoUnmask(key);
            if (o2 == null) {
                return false;
            }
            if (!o.equals(o2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        Node node = this.cache.getRoot().getChild(this.getFqn());
        if (node == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return new IteratorImpl(node);
    }

    @Override
    public boolean remove(Object o) {
        String key;
        Object o2;
        o = Null.toNullObject(o);
        int hashCode = o.hashCode();
        int size = this.size();
        boolean removed = false;
        String oldkey = null;
        for (int i = 0; i < size && (o2 = this.getNoUnmask(key = this.toLong(hashCode, i))) != null; ++i) {
            if (removed) {
                this.detach(key);
                this.attach(oldkey, o2);
            }
            if (o.equals(o2)) {
                this.detach(key, true);
                removed = true;
            }
            oldkey = key;
        }
        return removed;
    }

    @Override
    public int size() {
        Set<Node> children = this.getNodeChildren();
        return children == null ? 0 : children.size();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (key == this.interceptor.getBoundProxy()) {
                key = "(this set)";
            }
            buf.append("[").append(key).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private String toLong(long hashCode, long count) {
        long key = hashCode & 0xFFFFL | count << 32;
        return Long.toHexString(key);
    }

    private Object attach(Object key, Object pojo) {
        return this.attach(key, pojo, false);
    }

    private Object attach(Object key, Object pojo, boolean add) {
        Fqn fqn = AopUtil.constructFqn(this.getFqn(), key);
        Object o = this.pojoCache.attach(fqn, pojo);
        if (add) {
            this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)"ADD");
        }
        return o;
    }

    private Object detach(Object key) {
        return this.detach(key, false);
    }

    private Object detach(Object key, boolean remove) {
        Fqn fqn = AopUtil.constructFqn(this.getFqn(), key);
        if (remove) {
            this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)"REMOVE");
        }
        return this.pojoCache.detach(fqn);
    }

    private Object getNoUnmask(Object key) {
        return this.pojoCache.find(AopUtil.constructFqn(this.getFqn(), key));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.cache.hashCode();
        result = 29 * result + this.interceptor.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        try {
            return super.equals(o);
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    private class IteratorImpl
    implements Iterator {
        private Iterator<NodeSPI> iterator;
        private Node node;
        private Object o;

        private IteratorImpl(Node node) {
            HashSet children = new HashSet(((NodeSPI)node).getChildrenDirect());
            this.iterator = children.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.node = (Node)this.iterator.next();
            this.o = Null.toNullValue(CachedSetImpl.this.pojoCache.find(this.node.getFqn()));
            return this.o;
        }

        public void remove() throws IllegalStateException {
            if (this.node == null) {
                throw new IllegalStateException();
            }
            CachedSetImpl.this.remove(this.o);
        }
    }
}

