/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.TransactionCompleted;
import org.jboss.cache.notifications.annotation.TransactionRegistered;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.TransactionalEvent;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.impl.NotificationDispatcher;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;
import org.jboss.cache.pojo.impl.PojoReference;
import org.jboss.cache.pojo.notification.NotificationContext;
import org.jboss.cache.pojo.notification.event.AttachedEvent;
import org.jboss.cache.pojo.notification.event.DetachedEvent;
import org.jboss.cache.pojo.notification.event.Event;
import org.jboss.cache.pojo.notification.event.FieldModifiedEvent;
import org.jboss.cache.pojo.notification.event.ListModifiedEvent;
import org.jboss.cache.pojo.notification.event.MapModifiedEvent;
import org.jboss.cache.pojo.notification.event.SetModifiedEvent;
import org.jboss.cache.pojo.notification.event.TransactionCompletedEvent;
import org.jboss.cache.pojo.notification.event.TransactionRegisteredEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public class CacheListenerAdaptor {
    private static final HashSet<String> internalKeys = new HashSet();
    private static final Log log = LogFactory.getLog(CacheListenerAdaptor.class);
    private PojoCacheImpl cache;
    private NotificationDispatcher dispatcher = new NotificationDispatcher();

    public CacheListenerAdaptor(PojoCacheImpl cache) {
        this.cache = cache;
    }

    public PojoCache getPojoCache() {
        return this.cache;
    }

    private FieldModifiedEvent createModifyEvent(NotificationContext context, Fqn fqn, String key, Object value, boolean local) {
        Field f;
        Object o;
        if (value instanceof PojoReference) {
            value = this.cache.find(((PojoReference)value).getFqn().toString());
        }
        if ((o = this.cache.find(fqn.toString())) == null) {
            return null;
        }
        try {
            f = o.getClass().getDeclaredField(key);
        }
        catch (NoSuchFieldException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not get field " + key + " on class " + o.getClass()));
            }
            return null;
        }
        return new FieldModifiedEvent(context, o, f, value, local);
    }

    private NotificationContext createContext(final TransactionalEvent event) {
        return new NotificationContext(){

            public PojoCache getPojoCache() {
                return CacheListenerAdaptor.this.getPojoCache();
            }

            public Transaction getTransaction() {
                return event.getTransaction();
            }
        };
    }

    private void sendNotification(Event notification, Set<NotificationDispatcher.Entry> listeners) {
        if (notification == null) {
            return;
        }
        if (listeners == null) {
            this.dispatcher.dispatch(notification);
        } else {
            this.dispatcher.dispatch(notification, listeners);
        }
    }

    @TransactionCompleted
    @TransactionRegistered
    public void handleTransaction(TransactionalEvent event) {
        if (event.getType() == Event.Type.TRANSACTION_COMPLETED) {
            boolean successful = ((org.jboss.cache.notifications.event.TransactionCompletedEvent)event).isSuccessful();
            this.sendNotification(new TransactionCompletedEvent(this.createContext(event), successful, event.isOriginLocal()), null);
        } else if (event.getType() == Event.Type.TRANSACTION_REGISTERED) {
            this.sendNotification(new TransactionRegisteredEvent(this.createContext(event), event.isOriginLocal()), null);
        }
    }

    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        block7: {
            Set<NotificationDispatcher.Entry> matched;
            boolean isLocal;
            NodeModifiedEvent.ModificationType modType;
            Fqn fqn;
            Map data;
            block5: {
                block9: {
                    Object collection;
                    block11: {
                        block10: {
                            block8: {
                                block6: {
                                    data = event.getData();
                                    boolean pre = event.isPre();
                                    fqn = event.getFqn();
                                    modType = event.getModificationType();
                                    isLocal = event.isOriginLocal();
                                    if (pre) {
                                        return;
                                    }
                                    matched = null;
                                    if (this.dispatcher.hasFilters() && (matched = this.matchListeners(fqn)) != null && matched.isEmpty()) {
                                        return;
                                    }
                                    if (modType != NodeModifiedEvent.ModificationType.PUT_DATA) break block5;
                                    if (!"ATTACHED".equals(data.get("POJOCache.Status"))) break block6;
                                    Object o = this.cache.find(fqn.toString());
                                    this.sendNotification(new AttachedEvent(this.createContext((TransactionalEvent)event), o, isLocal), matched);
                                    break block7;
                                }
                                if (!"DETACHING".equals(data.get("POJOCache.Status"))) break block8;
                                Object o = this.cache.find(fqn.toString());
                                this.sendNotification(new DetachedEvent(this.createContext((TransactionalEvent)event), o, isLocal), matched);
                                break block7;
                            }
                            if (!data.containsKey("POJOCache.Operation")) break block9;
                            collection = this.cache.find(fqn.getParent().toString());
                            if (!(collection instanceof List)) break block10;
                            int i = Integer.parseInt(fqn.getLastElementAsString());
                            ListModifiedEvent.Operation operation = ListModifiedEvent.Operation.valueOf(data.get("POJOCache.Operation").toString());
                            Object value = this.cache.find(fqn.toString());
                            this.sendNotification(new ListModifiedEvent(this.createContext((TransactionalEvent)event), (List)collection, operation, i, value, isLocal), matched);
                            break block7;
                        }
                        if (!(collection instanceof Set)) break block11;
                        SetModifiedEvent.Operation operation = SetModifiedEvent.Operation.valueOf(data.get("POJOCache.Operation").toString());
                        Object value = this.cache.find(fqn.toString());
                        this.sendNotification(new SetModifiedEvent(this.createContext((TransactionalEvent)event), (Set)collection, operation, value, isLocal), matched);
                        break block7;
                    }
                    if (!(collection instanceof Map)) break block7;
                    MapModifiedEvent.Operation operation = MapModifiedEvent.Operation.valueOf(data.get("POJOCache.Operation").toString());
                    Object value = this.cache.find(fqn.toString());
                    this.sendNotification(new MapModifiedEvent(this.createContext((TransactionalEvent)event), (Map)collection, operation, fqn.getLastElement(), value, isLocal), matched);
                    break block7;
                }
                if (!"ATTACHED".equals(this.cache.getCache().get(fqn, (Object)"POJOCache.Status"))) break block7;
                for (Map.Entry entry : data.entrySet()) {
                    String key = entry.getKey().toString();
                    Object value = entry.getValue();
                    if (internalKeys.contains(key)) continue;
                    this.sendNotification(this.createModifyEvent(this.createContext((TransactionalEvent)event), fqn, key, value, isLocal), matched);
                }
                break block7;
            }
            if (modType == NodeModifiedEvent.ModificationType.REMOVE_DATA) {
                for (Map.Entry entry : data.entrySet()) {
                    String key = entry.getKey().toString();
                    if (internalKeys.contains(key)) continue;
                    this.sendNotification(this.createModifyEvent(this.createContext((TransactionalEvent)event), fqn, key, null, isLocal), matched);
                }
            }
        }
    }

    private Set<NotificationDispatcher.Entry> matchListeners(Fqn fqn) {
        PojoInstance instance = (PojoInstance)this.cache.getCache().get(fqn, (Object)"POJOCache.PojoInstance");
        if (instance != null) {
            return this.dispatcher.getListenerEntries(instance.getReferences());
        }
        return null;
    }

    public boolean isEmpty() {
        return this.dispatcher.isEmpty();
    }

    public Collection<Object> getListeners() {
        return this.dispatcher.getListeners();
    }

    public void addListener(Object listener) {
        this.dispatcher.add(listener);
    }

    public void addListener(Object listener, Pattern pattern) {
        if (pattern == null) {
            this.dispatcher.add(listener);
        } else {
            this.dispatcher.add(listener, pattern);
        }
    }

    public void removeListener(Object listener) {
        this.dispatcher.remove(listener);
    }

    static {
        internalKeys.add("POJOCache.Status");
        internalKeys.add("POJOCache.Operation");
        internalKeys.add("POJOCache.PojoInstance");
        internalKeys.add("POJOCache.PojoReference");
        internalKeys.add("POJOCache.LOCK");
    }
}

