/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.dtest;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.byteman.contrib.dtest.CallCount;
import org.jboss.byteman.contrib.dtest.InstrumentedInstance;
import org.jboss.byteman.contrib.dtest.RemoteInterface;
import org.junit.Assert;

public class InstrumentedClass
implements RemoteInterface {
    private static final Integer STATIC_INSTANCE_ID = new Integer(-1);
    private final String className;
    private final Map<Integer, InstrumentedInstance> instrumentedInstances = new HashMap<Integer, InstrumentedInstance>();

    InstrumentedClass(String className) {
        this.className = className;
    }

    @Override
    public void trace(String methodName, Object[] args) throws RemoteException {
        InstrumentedInstance instrumentedInstance;
        Integer objectId = (Integer)args[0];
        if (objectId == null) {
            objectId = STATIC_INSTANCE_ID;
        }
        if ((instrumentedInstance = this.instrumentedInstances.get(objectId)) == null) {
            instrumentedInstance = new InstrumentedInstance(this.className, objectId);
            this.instrumentedInstances.put(objectId, instrumentedInstance);
        }
        Object[] innerArgs = new Object[args.length - 1];
        System.arraycopy(args, 1, innerArgs, 0, innerArgs.length);
        instrumentedInstance.addMethodTrace(methodName, innerArgs);
    }

    public Set<InstrumentedInstance> getInstances() {
        return new HashSet<InstrumentedInstance>(this.instrumentedInstances.values());
    }

    public void assertKnownInstances(int count) {
        Assert.assertEquals(null, (long)count, (long)this.instrumentedInstances.size());
    }

    public void assertMethodCallCount(String message, String methodName, CallCount callCount) {
        for (InstrumentedInstance instance : this.getInstances()) {
            instance.assertMethodCallCount(message, methodName, callCount);
        }
    }

    public void assertMethodCalled(String methodName) {
        this.assertMethodCallCount(null, methodName, new CallCount(1, Integer.MAX_VALUE));
    }

    public void assertMethodNotCalled(String methodName) {
        this.assertMethodCallCount(null, methodName, new CallCount(0, 0));
    }
}

