/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.bmunit;

import java.lang.reflect.Method;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMRules;
import org.jboss.byteman.contrib.bmunit.BMRunnerUtil;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMScripts;
import org.jboss.byteman.contrib.bmunit.BMUnit;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public class BMNGRunner
implements IHookable {
    BMScript classSingleScriptAnnotation;
    BMScripts classMultiScriptAnnotation;
    BMRules classMultiRuleAnnotation;
    BMRule classSingleRuleAnnotation;
    Class<?> testKlazz;

    public void run(IHookCallBack callBack, ITestResult testResult) {
        callBack.runTestMethod(testResult);
    }

    @BeforeClass(alwaysRun=true)
    public void bmngBeforeClass() throws Exception {
        this.testKlazz = this.getClass();
        this.classSingleScriptAnnotation = this.testKlazz.getAnnotation(BMScript.class);
        this.classMultiScriptAnnotation = this.testKlazz.getAnnotation(BMScripts.class);
        this.classSingleRuleAnnotation = this.testKlazz.getAnnotation(BMRule.class);
        this.classMultiRuleAnnotation = this.testKlazz.getAnnotation(BMRules.class);
        if (this.classMultiRuleAnnotation != null && this.classSingleRuleAnnotation != null) {
            throw new TestNGException("Use either BMRule or BMRules annotation but not both");
        }
        if (this.classMultiScriptAnnotation != null && this.classSingleScriptAnnotation != null) {
            throw new TestNGException("Use either BMScript or BMScripts annotation but not both");
        }
        if (this.classSingleScriptAnnotation != null) {
            String name = BMRunnerUtil.computeBMScriptName(this.classSingleScriptAnnotation.value());
            String directory = BMRunnerUtil.normaliseLoadDirectory(this.classSingleScriptAnnotation);
            BMUnit.loadScriptFile(this.testKlazz, name, directory);
        } else if (this.classMultiScriptAnnotation != null) {
            BMScript[] scripts;
            for (BMScript script : scripts = this.classMultiScriptAnnotation.scripts()) {
                String name = BMRunnerUtil.computeBMScriptName(script.value());
                String directory = BMRunnerUtil.normaliseLoadDirectory(script);
                BMUnit.loadScriptFile(this.testKlazz, name, directory);
            }
        }
        if (this.classSingleRuleAnnotation != null) {
            String scriptText = BMRunnerUtil.constructScriptText(new BMRule[]{this.classSingleRuleAnnotation});
            BMUnit.loadScriptText(this.testKlazz, null, scriptText);
        } else if (this.classMultiRuleAnnotation != null) {
            BMRule[] rules = this.classMultiRuleAnnotation.rules();
            String scriptText = BMRunnerUtil.constructScriptText(rules);
            BMUnit.loadScriptText(this.testKlazz, null, scriptText);
        }
    }

    @AfterClass(alwaysRun=true)
    public void bmngAfterClass() throws Exception {
        if (this.classSingleScriptAnnotation != null) {
            String name = BMRunnerUtil.computeBMScriptName(this.classSingleScriptAnnotation.value());
            BMUnit.unloadScriptFile(this.testKlazz, name);
        } else if (this.classMultiScriptAnnotation != null) {
            BMScript[] scripts;
            for (BMScript script : scripts = this.classMultiScriptAnnotation.scripts()) {
                String name = BMRunnerUtil.computeBMScriptName(script.value());
                BMUnit.unloadScriptFile(this.testKlazz, name);
            }
        }
        if (this.classSingleRuleAnnotation != null) {
            BMUnit.unloadScriptText(this.testKlazz, null);
        } else if (this.classMultiRuleAnnotation != null) {
            BMRule[] rules = this.classMultiRuleAnnotation.rules();
            BMUnit.unloadScriptText(this.testKlazz, null);
        }
    }

    @BeforeMethod(alwaysRun=true)
    public void bmngBeforeTest(Method method) throws Exception {
        BMScript methodSingleScriptAnnotation = method.getAnnotation(BMScript.class);
        BMScripts methodMultiScriptAnnotation = method.getAnnotation(BMScripts.class);
        BMRule methodSingleRuleAnnotation = method.getAnnotation(BMRule.class);
        BMRules methodMultiRuleAnnotation = method.getAnnotation(BMRules.class);
        if (methodMultiRuleAnnotation != null && methodSingleRuleAnnotation != null) {
            throw new TestNGException("Use either BMRule or BMRules annotation but not both");
        }
        if (methodMultiScriptAnnotation != null && methodSingleScriptAnnotation != null) {
            throw new TestNGException("Use either BMScript or BMScripts annotation but not both");
        }
        if (methodSingleScriptAnnotation != null) {
            String name = BMRunnerUtil.computeBMScriptName(methodSingleScriptAnnotation.value(), method);
            String directory = BMRunnerUtil.normaliseLoadDirectory(methodSingleScriptAnnotation);
            BMUnit.loadScriptFile(this.testKlazz, name, directory);
        } else if (methodMultiScriptAnnotation != null) {
            BMScript[] scripts;
            for (BMScript script : scripts = methodMultiScriptAnnotation.scripts()) {
                String name = BMRunnerUtil.computeBMScriptName(script.value(), method);
                String directory = BMRunnerUtil.normaliseLoadDirectory(script);
                BMUnit.loadScriptFile(this.testKlazz, name, directory);
            }
        }
        if (methodSingleRuleAnnotation != null) {
            String scriptText = BMRunnerUtil.constructScriptText(new BMRule[]{methodSingleRuleAnnotation});
            String name = method.getName();
            BMUnit.loadScriptText(this.testKlazz, name, scriptText);
        } else if (methodMultiRuleAnnotation != null) {
            BMRule[] rules = methodMultiRuleAnnotation.rules();
            String scriptText = BMRunnerUtil.constructScriptText(rules);
            String name = method.getName();
            BMUnit.loadScriptText(this.testKlazz, name, scriptText);
        }
    }

    @AfterMethod(alwaysRun=true)
    public void bmngAfterTest(Method method) throws Exception {
        BMScript methodSingleScriptAnnotation = method.getAnnotation(BMScript.class);
        BMScripts methodMultiScriptAnnotation = method.getAnnotation(BMScripts.class);
        BMRule methodSingleRuleAnnotation = method.getAnnotation(BMRule.class);
        BMRules methodMultiRuleAnnotation = method.getAnnotation(BMRules.class);
        if (methodSingleScriptAnnotation != null) {
            String name = BMRunnerUtil.computeBMScriptName(methodSingleScriptAnnotation.value(), method);
            String directory = BMRunnerUtil.normaliseLoadDirectory(methodSingleScriptAnnotation);
            BMUnit.unloadScriptFile(this.testKlazz, name);
        } else if (methodMultiScriptAnnotation != null) {
            BMScript[] scripts;
            for (BMScript script : scripts = methodMultiScriptAnnotation.scripts()) {
                String name = BMRunnerUtil.computeBMScriptName(script.value(), method);
                String directory = BMRunnerUtil.normaliseLoadDirectory(script);
                BMUnit.unloadScriptFile(this.testKlazz, name);
            }
        }
        if (methodSingleRuleAnnotation != null) {
            String scriptText = BMRunnerUtil.constructScriptText(new BMRule[]{methodSingleRuleAnnotation});
            String name = method.getName();
            BMUnit.unloadScriptText(this.testKlazz, name);
        } else if (methodMultiRuleAnnotation != null) {
            BMRule[] rules = methodMultiRuleAnnotation.rules();
            String scriptText = BMRunnerUtil.constructScriptText(rules);
            String name = method.getName();
            BMUnit.unloadScriptText(this.testKlazz, name);
        }
    }
}

