/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.util;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONException;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import java.util.Date;
import java.util.Set;
import org.jboss.bpm.console.client.util.SimpleDateFormat;

public class JSONWalk {
    private JSONValue root;

    private JSONWalk(JSONValue root) {
        this.root = root;
    }

    public static JSONWalk on(JSONValue root) {
        return new JSONWalk(root);
    }

    public JSONWrapper next(String name) {
        if (null == this.root || this.root.isObject() == null) {
            return null;
        }
        JSONObject rootObject = this.root.isObject();
        JSONWrapper match = null;
        Set keySet = rootObject.keySet();
        for (String s : keySet) {
            JSONValue child = rootObject.get(s);
            if (name.equals(s)) {
                match = new JSONWrapper(child);
                break;
            }
            match = JSONWalk.on(child).next(name);
        }
        return match;
    }

    public class JSONWrapper {
        private JSONValue value;

        public JSONWrapper(JSONValue value) {
            this.value = value;
        }

        public int asInt() {
            if (this.value.isNumber() != null) {
                return new Double(this.value.isNumber().getValue()).intValue();
            }
            throw new IllegalArgumentException("Not a number: " + this.value);
        }

        public long asLong() {
            if (this.value.isNumber() != null) {
                return new Double(this.value.isNumber().getValue()).longValue();
            }
            throw new IllegalArgumentException("Not a number: " + this.value);
        }

        public double asDouble() {
            if (this.value.isNumber() != null) {
                return this.value.isNumber().getValue();
            }
            throw new IllegalArgumentException("Not a number: " + this.value);
        }

        public String asString() {
            if (this.value.isString() != null) {
                return this.value.isString().stringValue();
            }
            throw new IllegalArgumentException("Not a string: " + this.value);
        }

        public boolean asBool() {
            if (this.value.isBoolean() != null) {
                return this.value.isBoolean().booleanValue();
            }
            throw new IllegalArgumentException("Not a boolean: " + this.value);
        }

        public Date asDate() {
            if (this.value.isString() != null) {
                SimpleDateFormat df = new SimpleDateFormat();
                return df.parse(this.value.isString().stringValue());
            }
            throw new IllegalArgumentException("Not a date string: " + this.value);
        }

        public JSONArray asArray() {
            if (this.value.isArray() != null) {
                return this.value.isArray();
            }
            throw new IllegalArgumentException("Not a number: " + this.value);
        }

        public JSONObject asObject() {
            if (this.value.isObject() != null) {
                return this.value.isObject();
            }
            throw new IllegalArgumentException("Not an object: " + this.value);
        }

        public String toString() throws JSONException {
            return this.value.toString();
        }
    }
}

