/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import org.gwt.mosaic.ui.client.DeckLayoutPanel;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;

/**
 * Maintains {@link Editor}'s
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class Workspace extends DeckLayoutPanel
{
  protected ApplicationContext appContext;
  private Menu menu;

  public Workspace(Menu menu)
  {
    super();
    this.menu = menu;
    this.setPadding(5);

  }

  public void addEditor(Editor editor, boolean closeable)
  {
    // Menu
    MenuSection menuSection = editor.provideMenuSection();
    if(menuSection!=null) // some editors don't contribute to the menu
      menu.addSection(menuSection);

    // Editor deck
    EditorDeck deck = createDeck(editor);
    deck.index = this.getWidgetCount();
    this.add(deck);
  }

  public boolean hasEditor(String id)
  {
    return findEditor(id)!=null;
  }

  public void showEditor(String id)
  {
    EditorDeck deck = findEditor(id);
    if(null==deck)
      throw new IllegalArgumentException("No such editor: " +id);
    this.showWidget(deck.index);
    
    deck.editor.initialize();    
  }

  private EditorDeck createDeck(Editor editor)
  {
    EditorDeck deck = new EditorDeck(editor);
    deck.add(editor);
    return deck;
  }

  private EditorDeck findEditor(String id)
  {
    EditorDeck match = null;
    for(int i=0; i<this.getWidgetCount(); i++)
    {
      EditorDeck deck = (EditorDeck) this.getWidget(i);
      if(id.equals( deck.editor.getEditorId()))
      {
        match = deck;
        break;
      }
    }

    return match;
  }

  private class EditorDeck extends LayoutPanel
  {
    Editor editor;
    int index;

    public EditorDeck(Editor editor)
    {
      super();
      this.editor = editor;
    }

  }
}
