/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.mvc4g.client.Controller;
import com.google.gwt.user.client.Window;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.jboss.bpm.console.client.LazyPanel;


/**
 * <h2>Composition</h2>
 * An editor can be plugged into a {@link org.jboss.bpm.console.client.Workspace}.
 * Editors do aggregate {@link com.mvc4g.client.ViewInterface}'s and {@link com.mvc4g.client.ActionInterface}'s,
 * which are maintained through a {@link com.mvc4g.client.Controller}.

 * <h2>Event handling</h2>
 * Views and actions communicate though a hirarchical controller chain by issuing events:<p>
 * <code>
 *  Controller.handleEvent( new Event(...));
 * </code>
 * <p/>
 * By default every editor get's it's own controller that delegates to the main {@link org.jboss.bpm.console.client.ApplicationContext}
 * controller as it's parent.
 *
 * <h2>Layout</h2>
 * Each Editor uses a {@link org.gwt.mosaic.ui.client.layout.BorderLayout} by default.
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public abstract class Editor extends LayoutPanel implements LazyPanel
{
  protected ApplicationContext appContext;

  protected Controller controller;

  protected boolean isInitialized;

  public Editor(ApplicationContext appContext)
  {
    super(new BorderLayout());
    this.appContext = appContext;

    // hmvc controller chain.
    //this.controller = new Controller();
    //this.controller.setParent(appContext.getController());

    this.controller = appContext.getController();
  }

  public boolean isInitialized()
  {
    return this.isInitialized;
  }

  public abstract void initialize();
    
  public abstract String getEditorId();

  public abstract String getTitle();
  
  public abstract MenuSection provideMenuSection();  
 
}
