/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import java.util.ArrayList;
import java.util.List;
import org.jboss.bpm.console.client.model.DTOParser;
import org.jboss.bpm.console.client.util.ConsoleLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Authentication {
    private String loginUrl;
    private AuthCallback callback;
    private List<String> rolesAssigned = new ArrayList<String>();
    private String username;

    public Authentication(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public Authentication(String loginUrl, AuthCallback callback) {
        this.loginUrl = loginUrl;
        this.callback = callback;
    }

    public void doLogin() {
        this.doLogin(null, null);
    }

    public void doLogin(String user, String pass) {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.GET, this.loginUrl);
        this.username = user;
        ConsoleLog.debug("Authentication against: " + rb.getUrl());
        if (user != null && pass != null) {
            rb.setUser(user);
            rb.setPassword(pass);
            if (!GWT.isScript()) {
                rb.setHeader("xtest-user", user);
                rb.setHeader("xtest-pass", pass);
            }
        }
        try {
            rb.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    if (200 == response.getStatusCode()) {
                        Authentication.this.rolesAssigned = DTOParser.parseRolesAssigned(response.getText());
                        if (Authentication.this.callback != null) {
                            Authentication.this.callback.onLoginSuccess(request, response);
                        }
                    } else {
                        this.onError(request, new Exception(response.getText()));
                    }
                }

                public void onError(Request request, Throwable t) {
                    if (Authentication.this.callback == null) {
                        throw new RuntimeException("Unknown exception upon login attempt", t);
                    }
                    Authentication.this.callback.onLoginFailed(request, t);
                }
            });
        }
        catch (RequestException e1) {
            throw new RuntimeException("Unknown error upon login attempt", e1);
        }
    }

    public void setCallback(AuthCallback callback) {
        this.callback = callback;
    }

    public native void doLogout();

    public List<String> getRolesAssigned() {
        return this.rolesAssigned;
    }

    public String getUsername() {
        return this.username;
    }

    public static interface AuthCallback {
        public void onLoginSuccess(Request var1, Response var2);

        public void onLoginFailed(Request var1, Throwable var2);
    }
}

