/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.http.client.URL;
import com.google.gwt.core.client.GWT;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.jbpm3.TokenReference;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class URLBuilder
{
  ConsoleConfig config;

  public URLBuilder(ConsoleConfig config)
  {
    this.config = config;
  }

  public String getConsoleServerUrl()
  {
    return config.getConsoleServerUrl();
  }

  public String getProcessDefinitionsURL()
  {
    return getConsoleServerUrl() + "/rs/process/definitions";
  }

  public String getProcessInstancesURL(String processId)
  {
    String encodedId = URL.encode(processId);
    return getConsoleServerUrl() + "/rs/process/definitions/" + encodedId + "/instances";
  }

  public String getUserInRoleURL(String[] possibleRoles)
  {
    StringBuffer sb = new StringBuffer();
    for (int i = 0; i < possibleRoles.length; i++)
    {
      sb.append(URL.encode(possibleRoles[i]));
      if (i < possibleRoles.length - 1)
        sb.append(",");
    }
    return getConsoleServerUrl() + "/rs/identity/user/roles?roleCheck=" + sb.toString();
  }

  public String getServerStatusURL()
  {
    return getConsoleServerUrl() + "/rs/server/status"; 
  }

  @Deprecated
  public String getRemoveDefinitionURL(String processId)
  {
    String encodedId = URL.encode(processId);
    return getConsoleServerUrl() + "/rs/process/definitions/" + encodedId+ "/remove";
  }

  public String getProcessImageURL(String processId)
  {
    String encodedId = URL.encode(processId);
    return getConsoleServerUrl() + "/rs/jbpm3/definitions/" + encodedId+ "/image";
  }

  public String getActiveNodeInfoURL(String instanceId)
  {
    return getConsoleServerUrl() + "/rs/jbpm3/instances/" + instanceId + "/activeNodeInfo";
  }

  public String getStateChangeURL(String instanceId, ProcessInstanceRef.STATE state)
  {
    return getConsoleServerUrl() + "/rs/process/instances/" + instanceId + "/state/" + state;
  }

  public String getStartNewInstanceURL(String processId)
  {
    String encodedID = URL.encode(processId);
    return getConsoleServerUrl() + "/rs/process/definitions/" + encodedID + "/instances/new";
  }

  public String getUploadDefinitionURL()
  {
    return getConsoleServerUrl() + "/rs/process/definitions/new";
  }

  public String getTaskListURL(String idRef)
  {
    return getConsoleServerUrl() + "/rs/tasks/" + URL.encode(idRef);
  }

  public String getParticipationTaskListURL(String idRef, String participation)
  {
    return getConsoleServerUrl() + "/rs/tasks/" + URL.encode(idRef) +"/participation/"+URL.encode(participation);
  }

  public String getTaskReleaseURL(long id)
  {
    return getConsoleServerUrl() + "/rs/task/" + id + "/release";
  }

  public String getTaskCompleteURL(long id)
  {
    return getConsoleServerUrl() + "/rs/task/" + id + "/close";
  }

  public String getTaskCompleteURL(long id, String outcome)
  {
    return getConsoleServerUrl() + "/rs/task/" + id + "/close/" + URL.encode(outcome);
  }

  public String getTaskAssignURL(long id, String idRef)
  {
    return getConsoleServerUrl() + "/rs/task/" + id + "/assign/" + URL.encode(idRef);
  }

  public String getExecutionSignalUrl(TokenReference tok)
  {
    return getConsoleServerUrl() + "/rs/process/tokens/" + tok.getId() + "/transition/default";
  }

  public String getExecutionSignalUrl(TokenReference tok, String signal)
  {
    String encodedSignal = URL.encode(signal);
    return getConsoleServerUrl() + "/rs/process/tokens/" + tok.getId() + "/transition?signal=" + encodedSignal;
  }

  public String getAvailableActorsUrl(String actorId)
  {
    return getConsoleServerUrl() + "/rs/identity/user/" + actorId + "/actors";
  }

  public String getProcessDefinitionByNameURL(String name)
  {
    return getConsoleServerUrl() + "/rs/process/definitions/" + name;
  }

  public String getDeployTestHarnessUrl()
  {
    return getConsoleServerUrl() + "/rs/test/deploy/harness";
  }

  public String getUndeployTestHarnessUrl()
  {
    return getConsoleServerUrl() + "/rs/test/undeploy/harness";
  }

  public String getOverviewReportUrl()
  {
    String name = URL.encode(config.getOverviewReportFile());
    String url = config.getReportServerUrl() + "/rs/report/view/" + name;
    if (!GWT.isScript())
      url += "?id=birt";
    return url;
  }

  public String getDefinitionReportUrl(String name)
  {
    String reportName = URL.encode(name);
    String reportFileName = URL.encode(config.getDefinitionReportFile());
    String url = config.getReportServerUrl() + "/rs/report/view/" + reportFileName + "?name=" + reportName;
    if (!GWT.isScript())
      url += "&id=birt";
    return url;
  }
}
