/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process.v2;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.gwt.mosaic.ui.client.DecoratedTabLayoutPanel;
import org.gwt.mosaic.ui.client.LayoutPopupPanel;
import org.gwt.mosaic.ui.client.PopupMenu;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.ToolButton;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.ColumnLayout;
import org.gwt.mosaic.ui.client.layout.ColumnLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.process.DeleteDefinitionAction;
import org.jboss.bpm.console.client.process.DeleteInstanceAction;
import org.jboss.bpm.console.client.process.InstanceListView;
import org.jboss.bpm.console.client.process.StartNewInstanceAction;
import org.jboss.bpm.console.client.process.StateChangeAction;
import org.jboss.bpm.console.client.process.UpdateDefinitionsAction;
import org.jboss.bpm.console.client.process.UpdateInstancesAction;
import org.jboss.bpm.console.client.process.v2.Explorer;
import org.jboss.bpm.console.client.process.v2.ProcessGroups;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.api.annotations.LoadTool;
import org.jboss.errai.workspaces.client.framework.Registry;

@LoadTool(name="Manage Instances", group="Processes", icon="processIcon", priority=1)
public class Explorer
implements WidgetProvider,
DataDriven,
ViewInterface {
    private LayoutPanel layout;
    private LayoutPanel definitionPanel;
    private ToolButton menuButton;
    private HTML title;
    private String selectedGroup;
    private Controller controller;
    private ProcessGroups processGroups = null;
    private ProcessDefinitionRef activeDefinition;

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void provideWidget(ProvisioningCallback callback) {
        this.initController();
        this.layout = new LayoutPanel((LayoutManager)new BorderLayout());
        this.definitionPanel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        this.definitionPanel.setPadding(0);
        ToolBar toolBar = new ToolBar();
        this.definitionPanel.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.menuButton = new ToolButton("Open", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        toolBar.add((Widget)this.menuButton);
        this.title = new HTML();
        this.title.getElement().setAttribute("style", "font-size:24px; font-weight:BOLD");
        LayoutPanel headerPanel = new LayoutPanel((LayoutManager)new ColumnLayout());
        headerPanel.add((Widget)this.title, (LayoutData)new ColumnLayoutData("70%"));
        LayoutPanel actionPanel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        actionPanel.getElement().setAttribute("style", "margin-right:10px;");
        ToolButton actions = new ToolButton("More ...");
        actions.setStyle(ToolButton.ToolButtonStyle.MENU);
        2 blank = new /* Unavailable Anonymous Inner Class!! */;
        PopupMenu actionMenu = new PopupMenu();
        actionMenu.addItem("Execution History", (Command)new /* Unavailable Anonymous Inner Class!! */);
        actionMenu.addItem("Change Version", (Command)new /* Unavailable Anonymous Inner Class!! */);
        actions.setMenu(actionMenu);
        actions.getElement().setAttribute("style", "widht:30px; height:12px; padding-right:0px;background-image:none;");
        actionPanel.add((Widget)actions, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        headerPanel.add((Widget)actionPanel, (LayoutData)new ColumnLayoutData("30%"));
        this.definitionPanel.add((Widget)headerPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        InstanceListView instanceView = new InstanceListView();
        DecoratedTabLayoutPanel tabPanel = new DecoratedTabLayoutPanel(false);
        instanceView.provideWidget((ProvisioningCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.layout.add((Widget)this.definitionPanel, (LayoutData)new BorderLayoutData(BorderLayout.Region.NORTH, 130.0));
        this.layout.add((Widget)tabPanel);
        callback.onSuccess((Widget)this.layout);
    }

    private void initController() {
        Controller controller = (Controller)Registry.get(Controller.class);
        controller.addView(Explorer.class.getName(), (ViewInterface)this);
        controller.addAction(UpdateInstancesAction.ID, (ActionInterface)new UpdateInstancesAction());
        controller.addAction(StartNewInstanceAction.ID, (ActionInterface)new StartNewInstanceAction());
        controller.addAction(StateChangeAction.ID, (ActionInterface)new StateChangeAction());
        controller.addAction(DeleteDefinitionAction.ID, (ActionInterface)new DeleteDefinitionAction());
        controller.addAction(DeleteInstanceAction.ID, (ActionInterface)new DeleteInstanceAction());
        controller.addAction(UpdateDefinitionsAction.ID, (ActionInterface)new UpdateDefinitionsAction());
    }

    public void reset() {
    }

    public void update(Object ... data) {
        this.processGroups = new ProcessGroups((List)data[0]);
        this.selectDefinition();
    }

    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.definitionPanel, (boolean)isLoading);
    }

    private void selectDefinition() {
        LayoutPopupPanel popup = new LayoutPopupPanel(true);
        popup.addStyleName("soa-PopupPanel");
        popup.setWidth("30%");
        ListBox listBox = new ListBox();
        listBox.addItem("");
        assert (this.processGroups != null) : "process definitions not loaded";
        for (String group : this.processGroups.getGroups()) {
            listBox.addItem(group);
        }
        LayoutPanel p = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        p.add((Widget)new HTML("Please select a process:"));
        p.add((Widget)listBox);
        LayoutPanel p2 = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
        p2.add((Widget)new Button("Done", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        HTML html = new HTML("Cancel");
        html.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        p2.add((Widget)html, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        p.add((Widget)p2);
        popup.setPopupPosition(this.menuButton.getAbsoluteLeft() - 2, this.menuButton.getAbsoluteTop() + 30);
        popup.setWidget((Widget)p);
        popup.pack();
        popup.show();
    }

    private void identifyActiveVersion() {
        for (ProcessDefinitionRef groupMemmber : this.processGroups.getProcessesForGroup(this.selectedGroup)) {
            if (groupMemmber.isSuspended()) continue;
            this.setActiveDefinition(groupMemmber);
            break;
        }
    }

    private void identifyMostRecentVersion() {
        ProcessDefinitionRef mostRecent = null;
        for (ProcessDefinitionRef groupMember : this.processGroups.getProcessesForGroup(this.selectedGroup)) {
            if (null != mostRecent && groupMember.getVersion() <= mostRecent.getVersion()) continue;
            mostRecent = groupMember;
        }
        this.setActiveDefinition(mostRecent);
    }

    private void refresh() {
        if (this.getActiveDefinition() != null) {
            DeferredCommand.addCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateTitle() {
        ProcessDefinitionRef ref = this.getActiveDefinition();
        String name = this.selectedGroup;
        String subtitle = "";
        if (this.selectedGroup.indexOf("}") != -1) {
            String[] qname = this.selectedGroup.split("}");
            name = qname[1];
            subtitle = qname[0].substring(1, qname[0].length());
        }
        String nameAndSubtitle = name + "<br/><div style='color:#C8C8C8;font-size:12px;text-align:left;'>" + subtitle + "</div>";
        StringBuffer sb = new StringBuffer("<p/><div style='font-size:12px;text-align:left;'>Version: ");
        String state = ref.isSuspended() ? "suspended" : "active";
        sb.append(ref.getVersion()).append(" (").append(state).append(")");
        sb.append("</div>");
        this.title.setHTML(nameAndSubtitle + sb.toString());
    }

    private void selectVersion() {
        LayoutPopupPanel popup = new LayoutPopupPanel(true);
        popup.addStyleName("soa-PopupPanel");
        ListBox listBox = new ListBox();
        listBox.addItem("");
        listBox.setWidth("50%");
        assert (this.selectedGroup != null) : "no process selected";
        for (ProcessDefinitionRef def : this.processGroups.getProcessesForGroup(this.selectedGroup)) {
            listBox.addItem(String.valueOf(def.getVersion()));
        }
        LayoutPanel p = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        p.add((Widget)new HTML("Please select a process version:"));
        p.add((Widget)listBox);
        LayoutPanel p2 = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
        p2.add((Widget)new Button("Done", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        HTML html = new HTML("Cancel");
        html.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        p2.add((Widget)html, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        p.add((Widget)p2);
        popup.setPopupPosition(this.menuButton.getAbsoluteLeft() - 2, this.menuButton.getAbsoluteTop() + 30);
        popup.setWidget((Widget)p);
        popup.pack();
        popup.show();
    }

    private ProcessDefinitionRef getSelectedVersion(ListBox listBox) {
        ProcessDefinitionRef selection = null;
        for (ProcessDefinitionRef ref : this.processGroups.getProcessesForGroup(this.selectedGroup)) {
            if (ref.getVersion() != Long.valueOf(listBox.getItemText(listBox.getSelectedIndex())).longValue()) continue;
            selection = ref;
            break;
        }
        return selection;
    }

    public void setActiveDefinition(ProcessDefinitionRef ref) {
        this.activeDefinition = ref;
    }

    private ProcessDefinitionRef getActiveDefinition() {
        return this.activeDefinition;
    }

    static /* synthetic */ Controller access$000(Explorer x0) {
        return x0.controller;
    }

    static /* synthetic */ ProcessDefinitionRef access$100(Explorer x0) {
        return x0.getActiveDefinition();
    }

    static /* synthetic */ void access$200(Explorer x0) {
        x0.selectVersion();
    }

    static /* synthetic */ String access$302(Explorer x0, String x1) {
        x0.selectedGroup = x1;
        return x0.selectedGroup;
    }

    static /* synthetic */ void access$400(Explorer x0) {
        x0.identifyActiveVersion();
    }

    static /* synthetic */ void access$500(Explorer x0) {
        x0.identifyMostRecentVersion();
    }

    static /* synthetic */ void access$600(Explorer x0) {
        x0.updateTitle();
    }

    static /* synthetic */ void access$700(Explorer x0) {
        x0.refresh();
    }

    static /* synthetic */ ProcessDefinitionRef access$800(Explorer x0, ListBox x1) {
        return x0.getSelectedVersion(x1);
    }
}

